/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.jdk.client;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.glassfish.tyrus.container.jdk.client.ParseException;
import org.glassfish.tyrus.core.TyrusUpgradeResponse;
import org.glassfish.tyrus.core.Utils;

class HttpResponseParser {
    private static final String ENCODING = "ISO-8859-1";
    private static final String LINE_SEPARATOR = "\r\n";
    private static final int BUFFER_STEP_SIZE = 256;
    static final int BUFFER_MAX_SIZE = 16384;
    private volatile boolean complete = false;
    private volatile ByteBuffer buffer;
    private volatile State findEndState = State.INIT;

    HttpResponseParser() {
        this.buffer = ByteBuffer.allocate(1024);
        this.buffer.flip();
    }

    TyrusUpgradeResponse parseUpgradeResponse() throws ParseException {
        String response = this.bufferToString();
        String[] tokens = response.split(LINE_SEPARATOR);
        TyrusUpgradeResponse tyrusUpgradeResponse = new TyrusUpgradeResponse();
        this.parseFirstLine(tokens, tyrusUpgradeResponse);
        LinkedList<String> lines = new LinkedList<String>();
        lines.addAll(Arrays.asList(tokens).subList(1, tokens.length));
        Map<String, String> headers = this.parseHeaders(lines);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            List<String> values = tyrusUpgradeResponse.getHeaders().get(entry.getKey());
            if (values == null) {
                tyrusUpgradeResponse.getHeaders().put(entry.getKey(), Utils.parseHeaderValue(entry.getValue()));
                continue;
            }
            values.addAll(Utils.parseHeaderValue(entry.getValue()));
        }
        return tyrusUpgradeResponse;
    }

    boolean isComplete() {
        return this.complete;
    }

    void appendData(ByteBuffer data) throws ParseException {
        if (this.buffer == null) {
            return;
        }
        int responseEndPosition = this.getEndPosition(data);
        if (responseEndPosition == -1) {
            this.checkResponseSize(data);
            this.buffer = Utils.appendBuffers(this.buffer, data, 16384, 256);
            return;
        }
        int limit = data.limit();
        data.limit(responseEndPosition + 1);
        this.checkResponseSize(data);
        this.buffer = Utils.appendBuffers(this.buffer, data, 16384, 256);
        data.limit(limit);
        data.position(responseEndPosition + 1);
        this.complete = true;
    }

    private void checkResponseSize(ByteBuffer partToBeAppended) throws ParseException {
        if (this.buffer.remaining() + partToBeAppended.remaining() > 16384) {
            throw new ParseException("Upgrade response too big, sizes only up to 16384B are supported.");
        }
    }

    private void parseFirstLine(String[] responseLines, TyrusUpgradeResponse tyrusUpgradeResponse) throws ParseException {
        int status;
        if (responseLines.length == 0) {
            throw new ParseException("Empty HTTP response");
        }
        String firstLine = responseLines[0];
        int versionEndIndex = firstLine.indexOf(32);
        if (versionEndIndex == -1) {
            throw new ParseException("Unexpected format of the first line of a HTTP response: " + firstLine);
        }
        int statusCodeEndIndex = firstLine.indexOf(32, versionEndIndex + 1);
        if (statusCodeEndIndex == -1) {
            throw new ParseException("Unexpected format of the first line of a HTTP response: " + firstLine);
        }
        String statusCode = firstLine.substring(versionEndIndex + 1, statusCodeEndIndex);
        String reasonPhrase = firstLine.substring(statusCodeEndIndex + 1);
        try {
            status = Integer.parseInt(statusCode);
        }
        catch (Exception e) {
            throw new ParseException("Invalid format of status code: " + statusCode);
        }
        tyrusUpgradeResponse.setStatus(status);
        tyrusUpgradeResponse.setReasonPhrase(reasonPhrase);
    }

    private Map<String, String> parseHeaders(List<String> headerLines) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String headerLine : headerLines) {
            int separatorIndex = headerLine.indexOf(58);
            if (separatorIndex == -1) continue;
            String headerKey = headerLine.substring(0, separatorIndex);
            String headerValue = headerLine.substring(separatorIndex + 1);
            if (headers.containsKey(headerKey)) {
                headers.put(headerKey, (String)headers.get(headerKey) + ", " + headerValue);
                continue;
            }
            headers.put(headerKey, headerValue);
        }
        return headers;
    }

    private String bufferToString() {
        String str;
        byte[] bytes = Utils.getRemainingArray(this.buffer);
        try {
            str = new String(bytes, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encodingISO-8859-1", e);
        }
        return str;
    }

    void destroy() {
        this.buffer = null;
    }

    void clear() {
        this.buffer.clear();
        this.buffer.flip();
        this.complete = false;
        this.findEndState = State.INIT;
    }

    private int getEndPosition(ByteBuffer buffer) {
        byte[] bytes = buffer.array();
        block6: for (int i = buffer.position(); i < buffer.limit(); ++i) {
            byte b = bytes[i];
            switch (this.findEndState) {
                case INIT: {
                    if (b != 13) continue block6;
                    this.findEndState = State.R;
                    continue block6;
                }
                case R: {
                    if (b == 10) {
                        this.findEndState = State.RN;
                        continue block6;
                    }
                    this.findEndReset(b);
                    continue block6;
                }
                case RN: {
                    if (b == 13) {
                        this.findEndState = State.RNR;
                        continue block6;
                    }
                    this.findEndState = State.INIT;
                    continue block6;
                }
                case RNR: {
                    if (b == 10) {
                        return i;
                    }
                    this.findEndReset(b);
                }
            }
        }
        return -1;
    }

    private void findEndReset(byte b) {
        this.findEndState = State.INIT;
        if (b == 13) {
            this.findEndState = State.R;
        }
    }

    private static enum State {
        INIT,
        R,
        RN,
        RNR;

    }
}

