/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.IkonHandler;
import org.kordamp.ikonli.swing.IkonResolver;

public class FontIcon
implements Icon {
    private static final Object LOCK = new Object[0];
    private Font font;
    private int width = 8;
    private int height = 8;
    private int iconSize = 8;
    private Color iconColor = Color.BLACK;
    private Ikon ikon;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        if (w <= 0 || h <= 0) {
            return;
        }
        g.translate(x, y);
        Color previousColor = g.getColor();
        Font previousFont = g.getFont();
        try {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setFont(this.font);
            g2.setColor(this.iconColor);
            int sy = g2.getFontMetrics().getAscent();
            int code = this.ikon.getCode();
            if (code <= 65535) {
                g2.drawString(String.valueOf((char)code), 0, sy);
            } else {
                char[] charPair = Character.toChars(code);
                String symbol = new String(charPair);
                g2.drawString(symbol, 0, sy);
            }
        }
        finally {
            g.translate(-x, -y);
            g.setColor(previousColor);
            g.setFont(previousFont);
        }
    }

    public ImageIcon toImageIcon() {
        return this.toImageIcon(this);
    }

    public ImageIcon toImageIcon(Icon icon) {
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(null, image.getGraphics(), 0, 0);
        return new ImageIcon(image);
    }

    public Ikon getIkon() {
        return this.ikon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIkon(Ikon ikon) {
        Objects.requireNonNull(this.iconColor, "Argument 'iconFont' must not be null");
        this.ikon = ikon;
        Object object = LOCK;
        synchronized (object) {
            IkonHandler ikonHandler = IkonResolver.getInstance().resolve(ikon.getDescription());
            this.font = ((Font)ikonHandler.getFont()).deriveFont(0, this.iconSize);
            this.setProperties();
        }
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(int iconSize) {
        if (iconSize > 0) {
            this.iconSize = iconSize;
            if (null != this.font) {
                this.font = this.font.deriveFont(0, iconSize);
                this.setProperties();
            }
        }
    }

    protected void setProperties() {
        BufferedImage tmp = new BufferedImage(this.iconSize, this.iconSize, 2);
        Graphics2D g2 = GraphicsEnvironment.getLocalGraphicsEnvironment().createGraphics(tmp);
        g2.setFont(this.font);
        this.width = g2.getFontMetrics().charWidth(this.ikon.getCode());
        this.height = g2.getFontMetrics().getHeight();
        g2.dispose();
    }

    public Color getIconColor() {
        return this.iconColor;
    }

    public void setIconColor(Color iconColor) {
        Objects.requireNonNull(iconColor, "Argument 'iconColor' must not be null");
        this.iconColor = iconColor;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public static FontIcon of(Ikon ikon) {
        return FontIcon.of(ikon, 8, Color.BLACK);
    }

    public static FontIcon of(Ikon ikon, int iconSize) {
        return FontIcon.of(ikon, iconSize, Color.BLACK);
    }

    public static FontIcon of(Ikon ikon, Color iconColor) {
        return FontIcon.of(ikon, 8, iconColor);
    }

    public static FontIcon of(Ikon ikon, int iconSize, Color iconColor) {
        FontIcon icon = new FontIcon();
        icon.setIkon(ikon);
        icon.setIconSize(iconSize);
        icon.setIconColor(iconColor);
        return icon;
    }
}

