/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli.swing;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.kordamp.ikonli.AbstractIkonResolver;
import org.kordamp.ikonli.IkonHandler;

public class IkonResolver
extends AbstractIkonResolver {
    private static final IkonResolver INSTANCE;
    private static final Set<IkonHandler> HANDLERS;
    private static final Set<IkonHandler> CUSTOM_HANDLERS;

    private IkonResolver() {
    }

    public boolean registerHandler(IkonHandler handler) {
        return this.registerHandler(handler, HANDLERS, CUSTOM_HANDLERS);
    }

    public boolean unregisterHandler(IkonHandler handler) {
        return this.unregisterHandler(handler, HANDLERS, CUSTOM_HANDLERS);
    }

    public IkonHandler resolve(String value) {
        return this.resolve(value, HANDLERS, CUSTOM_HANDLERS);
    }

    public static IkonResolver getInstance() {
        return INSTANCE;
    }

    static {
        HANDLERS = new LinkedHashSet<IkonHandler>();
        CUSTOM_HANDLERS = new LinkedHashSet<IkonHandler>();
        INSTANCE = new IkonResolver();
        ServiceLoader loader = IkonResolver.resolveServiceLoader();
        for (IkonHandler handler : loader) {
            HANDLERS.add(handler);
            try {
                InputStream stream = handler.getFontResourceAsStream();
                Font font = Font.createFont(0, stream);
                GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
                stream.close();
                handler.setFont((Object)font);
            }
            catch (FontFormatException | IOException ffe) {
                throw new IllegalStateException(ffe);
            }
        }
    }
}

