/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data;

import com.jaspersoft.studio.data.ADataAdapterComposite;
import com.jaspersoft.studio.data.HttpParametersDialog;
import com.jaspersoft.studio.data.messages.Messages;
import java.io.File;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.DataFile;
import net.sf.jasperreports.data.FileDataAdapter;
import net.sf.jasperreports.data.StandardRepositoryDataLocation;
import net.sf.jasperreports.data.http.StandardHttpDataLocation;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.ui.validator.NotEmptyFileValidator;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class AFileDataAdapterComposite
extends ADataAdapterComposite {
    protected Text textFileName;
    private Button btnBrowse;

    public AFileDataAdapterComposite(Composite parent, int style, JasperReportsContext jrContext) {
        super(parent, style, jrContext);
    }

    protected void createFileNameWidgets(Composite parent) {
        Label lblNewLabel = new Label(parent, 0);
        lblNewLabel.setText(Messages.XLSXDataAdapterComposite_0);
        lblNewLabel.setToolTipText(Messages.AFileDataAdapterComposite_0);
        this.textFileName = new Text(parent, 2048);
        GridData gd = new GridData(4, 0x1000000, true, false, 1, 1);
        gd.horizontalIndent = 8;
        gd.widthHint = 500;
        this.textFileName.setLayoutData((Object)gd);
        this.textFileName.setToolTipText(Messages.AFileDataAdapterComposite_0);
        this.textFileName.addModifyListener(e -> {
            String tt = this.textFileName.getText();
            if (!tt.isEmpty()) {
                tt = String.valueOf(tt) + "\n\n";
            }
            tt = String.valueOf(tt) + Messages.AFileDataAdapterComposite_0;
            this.textFileName.setToolTipText(tt);
        });
        this.btnBrowse = new Button(parent, 8);
        GridData gd_btnBrowse = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_btnBrowse.widthHint = 100;
        this.btnBrowse.setLayoutData((Object)gd_btnBrowse);
        this.btnBrowse.setText(Messages.AFileDataAdapterComposite_2);
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AFileDataAdapterComposite.this.textFileName.getText().matches("^(?i)(https?)://.*$")) {
                    FileDataAdapter fda = AFileDataAdapterComposite.this.getFileDataAdapter();
                    DataFile dataFile = fda.getDataFile();
                    HttpParametersDialog d = new HttpParametersDialog(AFileDataAdapterComposite.this.getShell(), (StandardHttpDataLocation)dataFile.clone());
                    if (d.open() == 0) {
                        fda.setDataFile((DataFile)d.getDataFile());
                        AFileDataAdapterComposite.this.fireFileChanged(!Misc.isNullOrEmpty((String)((StandardHttpDataLocation)dataFile).getUrl()));
                    }
                } else {
                    String old = AFileDataAdapterComposite.this.textFileName.getText();
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    FileDialog fd = new FileDialog(UIUtils.getShell());
                    fd.setFileName(AFileDataAdapterComposite.this.textFileName.getText());
                    fd.setFilterPath(root.getLocation().toOSString());
                    fd.setFilterExtensions(AFileDataAdapterComposite.this.getFileExtensions());
                    String selection = fd.open();
                    if (selection != null) {
                        IFile contextfile = (IFile)AFileDataAdapterComposite.this.getJrContext().getValue("ifile");
                        IFile[] resource = root.findFilesForLocationURI(new File(selection).toURI());
                        if (contextfile != null && resource != null && resource.length > 0 && contextfile.getProject().equals((Object)resource[0].getProject())) {
                            selection = resource[0].getProjectRelativePath().toOSString();
                        }
                        AFileDataAdapterComposite.this.textFileName.setText(selection);
                        if (!selection.equals(AFileDataAdapterComposite.this.textFileName)) {
                            AFileDataAdapterComposite.this.fireFileChanged(!Misc.isNullOrEmpty((String)old));
                        }
                    }
                }
            }
        });
    }

    protected void fireFileChanged(boolean showWarning) {
        this.pchangesuport.firePropertyChange("datafile", true, false);
    }

    protected abstract String[] getFileExtensions();

    protected void doBindFileNameWidget(DataAdapter dataAdapter) {
        NotEmptyFileValidator nefValidator = new NotEmptyFileValidator(this.getJrContext());
        Binding binding = this.bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.textFileName, (int)24), PojoObservables.observeValue((Object)new DAProxy((FileDataAdapter)dataAdapter), (String)"dataFile"), new UpdateValueStrategy().setAfterConvertValidator((IValidator)nefValidator), null);
        nefValidator.setBinding(binding);
        ControlDecorationSupport.create((ValidationStatusProvider)binding, (int)16512, null, (ControlDecorationUpdater)new ControlDecorationUpdater());
    }

    private FileDataAdapter getFileDataAdapter() {
        return (FileDataAdapter)this.dataAdapterDesc.getDataAdapter();
    }

    class DAProxy {
        private FileDataAdapter da;

        public DAProxy(FileDataAdapter da) {
            this.da = da;
        }

        public void setDataFile(String str) {
            DataFile dataFile = this.da.getDataFile();
            if (str.matches("^(?i)(https?)://.*$")) {
                AFileDataAdapterComposite.this.btnBrowse.setText(Messages.AFileDataAdapterComposite_5);
                DataFile dl = this.da.getDataFile();
                if (dataFile == null || !(dataFile instanceof StandardHttpDataLocation)) {
                    dl = new StandardHttpDataLocation();
                    this.da.setDataFile(dl);
                }
                ((StandardHttpDataLocation)dl).setUrl(str);
            } else {
                AFileDataAdapterComposite.this.btnBrowse.setText(Messages.AFileDataAdapterComposite_2);
                DataFile dl = this.da.getDataFile();
                if (dataFile == null || !(dataFile instanceof StandardRepositoryDataLocation)) {
                    dl = new StandardRepositoryDataLocation();
                    this.da.setDataFile(dl);
                }
                ((StandardRepositoryDataLocation)dl).setLocation(str);
            }
            AFileDataAdapterComposite.this.btnBrowse.getParent().layout();
        }

        public String getDataFile() {
            DataFile df = this.da.getDataFile();
            if (df instanceof StandardRepositoryDataLocation) {
                AFileDataAdapterComposite.this.btnBrowse.setText(Messages.AFileDataAdapterComposite_2);
                return ((StandardRepositoryDataLocation)df).getLocation();
            }
            if (df instanceof StandardHttpDataLocation) {
                AFileDataAdapterComposite.this.btnBrowse.setText(Messages.AFileDataAdapterComposite_5);
                return ((StandardHttpDataLocation)df).getUrl();
            }
            return "";
        }
    }
}

