/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.data.AbstractPoiXlsDataSource;
import net.sf.jasperreports.engine.design.JRDesignField;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.eclipse.core.runtime.IProgressMonitor;

public class FieldTypeGuesser {
    public static final int SAMPLESIZE = 1000;
    private static final Class<?>[] types = new Class[]{Date.class, Time.class, Timestamp.class, Integer.class, Long.class, BigInteger.class, BigDecimal.class};

    public static void guessTypes(JRDataSource ds, List<JRDesignField> columns, boolean hasNext, IProgressMonitor monitor) throws JRException {
        CopyOnWriteArrayList<JRDesignField> cols = new CopyOnWriteArrayList<JRDesignField>(columns);
        int i = 0;
        while (i < 1000 && hasNext && !cols.isEmpty()) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            for (JRDesignField f : cols) {
                try {
                    String sv;
                    Object v = ds.getFieldValue((JRField)f);
                    if (v == null || !f.getValueClass().equals(String.class) || (sv = (String)v).trim().isEmpty()) continue;
                    FieldTypeGuesser.findType(types, f, ds, cols, sv);
                }
                catch (Throwable throwable) {
                    f.setValueClass(String.class);
                    cols.remove(f);
                }
            }
            hasNext = ds.next();
            ++i;
        }
    }

    public static void guessTypes(AbstractPoiXlsDataSource xlsDS, List<JRDesignField> columns, IProgressMonitor monitor) throws JRException {
        CopyOnWriteArrayList<JRDesignField> cols = new CopyOnWriteArrayList<JRDesignField>(columns);
        boolean hasNext = true;
        int i = 0;
        while (i < 1000 && hasNext && !cols.isEmpty()) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            for (JRDesignField f : cols) {
                try {
                    String dataFormat = xlsDS.getFieldFormatPattern((JRField)f);
                    int dataFormatID = dataFormat != null ? BuiltinFormats.getBuiltinFormat((String)dataFormat) : 0;
                    BuiltinFormats.getBuiltinFormat((String)dataFormat);
                    String val = xlsDS.getStringFieldValue((JRField)f);
                    if (!StringUtils.isNotEmpty((CharSequence)val)) continue;
                    if (NumberUtils.isParsable((String)val)) {
                        if (dataFormatID == 1) {
                            f.setValueClass(Long.class);
                        } else {
                            f.setValueClass(Double.class);
                        }
                        cols.remove(f);
                        continue;
                    }
                    Boolean boolVal = BooleanUtils.toBooleanObject((String)val);
                    if (boolVal != null) {
                        f.setValueClass(Boolean.class);
                        cols.remove(f);
                        continue;
                    }
                    boolean isDate = false;
                    if (dataFormatID >= 14 && dataFormatID <= 22) {
                        isDate = true;
                    }
                    if (!isDate && xlsDS.getDateFormat() != null) {
                        xlsDS.getDateFormat().parse(val);
                        isDate = true;
                    }
                    if (!isDate && dataFormat != null) {
                        DateUtils.parseDate((String)val, (String[])new String[]{dataFormat});
                        isDate = true;
                    }
                    if (!isDate) continue;
                    f.setValueClass(java.util.Date.class);
                    cols.remove(f);
                }
                catch (ParseException | JRException throwable) {
                    f.setValueClass(String.class);
                    cols.remove(f);
                }
            }
            hasNext = xlsDS.next();
            ++i;
        }
    }

    private static void findType(Class<?>[] types, JRDesignField f, JRDataSource ds, List<JRDesignField> cols, String sv) {
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                Class<?> type = classArray[n2];
                try {
                    f.setValueClass(type);
                    Object v = ds.getFieldValue((JRField)f);
                    if (v == null) {
                        f.setValueClass(String.class);
                    } else if (v instanceof Number) {
                        if (!sv.matches("^[+-]?(\\d+(\\.\\d*)?)$")) {
                            f.setValueClass(String.class);
                            break block10;
                        }
                        if (sv.contains(".") && !type.equals(BigDecimal.class)) {
                            break block10;
                        }
                    } else if (v instanceof Date && sv.contains(":") || v instanceof Time && (sv.contains("-") || sv.contains("//"))) break block10;
                    return;
                }
                catch (Throwable throwable) {
                    f.setValueClass(String.class);
                }
            }
            ++n2;
        }
        cols.remove(f);
    }
}

