/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.csv;

import com.jaspersoft.studio.data.FieldTypeGuesser;
import com.jaspersoft.studio.data.fields.IFieldsProvider;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.utils.parameter.ParameterUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.data.csv.CsvDataAdapter;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.StringUtils;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRCsvDataSource;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.query.JRCsvQueryExecuter;
import net.sf.jasperreports.engine.query.JRCsvQueryExecuterFactory;
import org.eclipse.core.runtime.IProgressMonitor;

public class CSVFieldsProvider
implements IFieldsProvider {
    public List<JRDesignField> getFields(DataAdapterService con, JasperReportsConfiguration jConfig, JRDataset reportDataset) throws JRException, UnsupportedOperationException {
        IProgressMonitor monitor = (IProgressMonitor)jConfig.getMap().get("monitor");
        HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
        parameters.put("REPORT_PARAMETERS_MAP", new HashMap());
        con.contributeParameters(parameters);
        ParameterUtil.setParameters((JasperReportsConfiguration)jConfig, (JRDataset)reportDataset, parameters);
        parameters.put("REPORT_MAX_COUNT", Integer.valueOf(1000));
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        JRCsvDataSource ds = null;
        ArrayList<JRDesignField> columns = new ArrayList<JRDesignField>();
        CsvDataAdapter da = (CsvDataAdapter)((AbstractDataAdapterService)con).getDataAdapter();
        if (!Misc.isNullOrEmpty((Collection)da.getColumnNames())) {
            for (String key : da.getColumnNames()) {
                this.createColumn(columns, key);
            }
        }
        if (da.isQueryExecuterMode()) {
            if (reportDataset.getQuery() == null) {
                JRDesignQuery query = new JRDesignQuery();
                query.setLanguage("csv");
                ((JRDesignDataset)reportDataset).setQuery(query);
            }
            JRCsvQueryExecuter qe = (JRCsvQueryExecuter)new JRCsvQueryExecuterFactory().createQueryExecuter((JasperReportsContext)jConfig, reportDataset, ParameterUtil.convertMap(parameters, (JRDataset)reportDataset));
            ds = (JRCsvDataSource)qe.createDatasource();
        } else {
            ds = (JRCsvDataSource)parameters.get("REPORT_DATA_SOURCE");
        }
        if (ds != null) {
            ds.setUseFirstRowAsHeader(true);
            boolean hasNext = ds.next();
            if (columns.isEmpty()) {
                Map map = ds.getColumnNames();
                for (String key : map.keySet()) {
                    this.createColumn(columns, key);
                }
            }
            FieldTypeGuesser.guessTypes((JRDataSource)ds, columns, hasNext, monitor);
        }
        return columns;
    }

    private void createColumn(List<JRDesignField> columns, String key) {
        JRDesignField field = new JRDesignField();
        field.setName(StringUtils.xmlEncode((String)key, null));
        field.setValueClass(String.class);
        columns.add(field);
    }

    public boolean supportsGetFieldsOperation(JasperReportsConfiguration jConfig, JRDataset jDataset) {
        return true;
    }
}

