/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.excel;

import com.jaspersoft.studio.data.AFileDataAdapterComposite;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DateNumberFormatWidget;
import com.jaspersoft.studio.data.excel.ExcelDataAdapterDescriptor;
import com.jaspersoft.studio.data.messages.Messages;
import com.jaspersoft.studio.swt.events.ChangeEvent;
import com.jaspersoft.studio.swt.events.ChangeListener;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.excel.ExcelDataAdapter;
import net.sf.jasperreports.data.excel.ExcelDataAdapterImpl;
import net.sf.jasperreports.data.excel.ExcelFormatEnum;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.ExcelDataSource;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ExcelDataAdapterComposite
extends AFileDataAdapterComposite {
    private Text textSheetSelection;
    private TableViewer tableViewer;
    private Table table;
    private TableViewerColumn tableViewerColumnName;
    private TableViewerColumn tableViewerColumnIndex;
    private Button btnAdd;
    private Button btnDelete;
    private Button btnCheckSkipFirstLine;
    private Button btnCheckQEMode;
    private DateNumberFormatWidget dnf;
    private List<String[]> rows;
    private JasperReportsConfiguration jConfig;
    private Combo format;

    public ExcelDataAdapterComposite(Composite parent, int style, JasperReportsContext jrContext) {
        super(parent, style, jrContext);
        this.setLayout((Layout)new GridLayout(1, false));
        this.rows = new ArrayList<String[]>();
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gl_composite = new GridLayout(3, false);
        gl_composite.marginHeight = 0;
        composite.setLayout((Layout)gl_composite);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.createFileNameWidgets(composite);
        this.btnCheckQEMode = new Button((Composite)this, 32);
        this.btnCheckQEMode.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnCheckQEMode.setText(Messages.XLSDataAdapterComposite_2);
        Composite cmp = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        cmp.setLayout((Layout)layout);
        cmp.setLayoutData((Object)new GridData(768));
        new Label(cmp, 0).setText("Excel Format");
        this.format = new Combo(cmp, 8);
        this.format.setItems(new String[]{ExcelFormatEnum.AUTODETECT.getName(), ExcelFormatEnum.XLS.getName(), ExcelFormatEnum.XLSX.getName()});
        Composite composite_1 = new Composite((Composite)this, 0);
        composite_1.setLayout((Layout)new FillLayout(512));
        composite_1.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        Group grpColumnNames = new Group(composite_1, 0);
        grpColumnNames.setText(Messages.XLSDataAdapterComposite_3);
        GridLayout gl_grpColumnNames = new GridLayout(1, false);
        grpColumnNames.setLayout((Layout)gl_grpColumnNames);
        Button btnGetExcelColumnsName = new Button((Composite)grpColumnNames, 0);
        btnGetExcelColumnsName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        btnGetExcelColumnsName.setText(Messages.XLSDataAdapterComposite_4);
        Composite composite_3 = new Composite((Composite)grpColumnNames, 0);
        GridLayout gl_composite_3 = new GridLayout(2, false);
        gl_composite_3.marginWidth = 0;
        gl_composite_3.marginHeight = 0;
        composite_3.setLayout((Layout)gl_composite_3);
        GridData gdComposite3 = new GridData(4, 4, true, true);
        gdComposite3.heightHint = 150;
        composite_3.setLayoutData((Object)gdComposite3);
        this.table = new Table(composite_3, 68098);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        this.table.setLayoutData((Object)gd);
        this.table.setHeaderVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new XLSContentProvider());
        this.tableViewer.setInput(this.rows);
        this.tableViewerColumnName = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnColumnName = this.tableViewerColumnName.getColumn();
        tblclmnColumnName.setMoveable(true);
        tblclmnColumnName.setWidth(100);
        tblclmnColumnName.setText(Messages.XLSDataAdapterComposite_5);
        this.tableViewerColumnName.setLabelProvider((CellLabelProvider)new ColumnNameIndexLabelProvider(0));
        this.tableViewerColumnName.setEditingSupport((EditingSupport)new NameIndexEditingSupport(this.tableViewer, 0));
        this.tableViewerColumnIndex = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnColumnIndex = this.tableViewerColumnIndex.getColumn();
        tblclmnColumnIndex.setMoveable(true);
        tblclmnColumnIndex.setWidth(100);
        tblclmnColumnIndex.setText(Messages.XLSDataAdapterComposite_6);
        this.tableViewerColumnIndex.setLabelProvider((CellLabelProvider)new ColumnNameIndexLabelProvider(1));
        this.tableViewerColumnIndex.setEditingSupport((EditingSupport)new NameIndexEditingSupport(this.tableViewer, 1));
        Composite composite_4 = new Composite(composite_3, 0);
        composite_4.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        GridLayout gl_composite_4 = new GridLayout(1, false);
        gl_composite_4.marginWidth = 0;
        gl_composite_4.marginHeight = 0;
        composite_4.setLayout((Layout)gl_composite_4);
        this.btnAdd = new Button(composite_4, 0);
        GridData gd_btnAdd = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_btnAdd.widthHint = 100;
        this.btnAdd.setLayoutData((Object)gd_btnAdd);
        this.btnAdd.setText(Messages.XLSDataAdapterComposite_7);
        this.btnDelete = new Button(composite_4, 0);
        GridData gd_btnDelete = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_btnDelete.widthHint = 100;
        this.btnDelete.setLayoutData((Object)gd_btnDelete);
        this.btnDelete.setText(Messages.XLSDataAdapterComposite_8);
        this.btnDelete.setEnabled(false);
        ListOrderButtons listOrderButtons = new ListOrderButtons();
        listOrderButtons.createOrderButtons(composite_4, this.tableViewer);
        listOrderButtons.addChangeListener(new ChangeListener(){

            public void changed(ChangeEvent event) {
                ExcelDataAdapterComposite.this.pchangesuport.firePropertyChange("dirty", false, true);
            }
        });
        Composite composite_2 = new Composite((Composite)this, 0);
        composite_2.setLayout((Layout)new FillLayout(256));
        composite_2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Group grpOther = new Group(composite_2, 0);
        grpOther.setText(Messages.XLSDataAdapterComposite_9);
        GridLayout gl_grpOther = new GridLayout(3, false);
        grpOther.setLayout((Layout)gl_grpOther);
        this.dnf = new DateNumberFormatWidget((Composite)grpOther);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.dnf.setLayoutData(gd);
        this.btnCheckSkipFirstLine = new Button((Composite)grpOther, 32);
        this.btnCheckSkipFirstLine.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.btnCheckSkipFirstLine.setText(Messages.XLSDataAdapterComposite_14);
        new Label((Composite)grpOther, 0).setText("Sheet Selection");
        this.textSheetSelection = new Text((Composite)grpOther, 2048);
        this.textSheetSelection.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        btnGetExcelColumnsName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ExcelDataAdapterComposite.this.getExcelColumns();
                    ExcelDataAdapterComposite.this.pchangesuport.firePropertyChange("dirty", false, true);
                }
                catch (Exception e1) {
                    UIUtils.showError((Throwable)e1);
                }
            }
        });
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcelDataAdapterComposite.this.rows.add(ExcelDataAdapterComposite.this.createDataModelEntry());
                if (ExcelDataAdapterComposite.this.rows.size() == 1) {
                    ExcelDataAdapterComposite.this.btnDelete.setEnabled(true);
                }
                ExcelDataAdapterComposite.this.tableViewer.refresh();
                ExcelDataAdapterComposite.this.setTableSelection(-1);
                ExcelDataAdapterComposite.this.pchangesuport.firePropertyChange("dirty", false, true);
            }
        });
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcelDataAdapterComposite.this.removeEntries();
                ExcelDataAdapterComposite.this.pchangesuport.firePropertyChange("dirty", false, true);
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    ExcelDataAdapterComposite.this.removeEntries();
                    ExcelDataAdapterComposite.this.pchangesuport.firePropertyChange("dirty", false, true);
                }
            }
        });
        this.tableViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ExcelDataAdapterComposite.this.rows.size() <= 0) {
                    ExcelDataAdapterComposite.this.btnDelete.setEnabled(false);
                    ExcelDataAdapterComposite.this.btnCheckSkipFirstLine.setSelection(false);
                } else {
                    ExcelDataAdapterComposite.this.btnDelete.setEnabled(true);
                }
            }
        });
        this.format.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExcelDataAdapterComposite.this.dataAdapterDesc != null) {
                    ExcelDataAdapterImpl da = (ExcelDataAdapterImpl)ExcelDataAdapterComposite.this.dataAdapterDesc.getDataAdapter();
                    switch (ExcelDataAdapterComposite.this.format.getSelectionIndex()) {
                        case 0: {
                            da.setFormat(ExcelFormatEnum.AUTODETECT);
                            break;
                        }
                        case 1: {
                            da.setFormat(ExcelFormatEnum.XLS);
                            break;
                        }
                        case 2: {
                            da.setFormat(ExcelFormatEnum.XLSX);
                        }
                    }
                    ExcelDataAdapterComposite.this.pchangesuport.firePropertyChange("dirty", false, true);
                }
            }
        });
    }

    protected void bindWidgets(DataAdapter dataAdapter) {
        ExcelDataAdapter xlsDataAdapter = (ExcelDataAdapter)dataAdapter;
        this.doBindFileNameWidget((DataAdapter)xlsDataAdapter);
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this.btnCheckQEMode), PojoObservables.observeValue((Object)dataAdapter, (String)"queryExecuterMode"));
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this.btnCheckSkipFirstLine), PojoObservables.observeValue((Object)dataAdapter, (String)"useFirstRowAsHeader"));
        this.dnf.bindWidgets((DataAdapter)xlsDataAdapter, this.bindingContext, xlsDataAdapter.getLocale(), xlsDataAdapter.getTimeZone());
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.textSheetSelection, (int)24), PojoObservables.observeValue((Object)dataAdapter, (String)"sheetSelection"));
        List listColumnNames = xlsDataAdapter.getColumnNames();
        List listColumnIndexes = xlsDataAdapter.getColumnIndexes();
        if (listColumnNames != null && listColumnNames.size() > 0 && listColumnIndexes != null && listColumnIndexes.size() > 0 && listColumnNames.size() == listColumnIndexes.size()) {
            int i = 0;
            while (i < listColumnNames.size()) {
                this.rows.add(new String[]{(String)listColumnNames.get(i), ((Integer)listColumnIndexes.get(i)).toString()});
                ++i;
            }
            this.tableViewer.refresh();
            this.setTableSelection(-1);
            this.btnDelete.setEnabled(true);
        }
        if (xlsDataAdapter.getFormat() == null) {
            xlsDataAdapter.setFormat(ExcelFormatEnum.AUTODETECT);
        }
        switch (xlsDataAdapter.getFormat()) {
            case AUTODETECT: {
                this.format.select(0);
                break;
            }
            case XLS: {
                this.format.select(1);
                break;
            }
            case XLSX: {
                this.format.select(2);
            }
        }
    }

    public DataAdapterDescriptor getDataAdapter() {
        if (this.dataAdapterDesc == null) {
            this.dataAdapterDesc = new ExcelDataAdapterDescriptor();
        }
        ExcelDataAdapter dataAdapter = (ExcelDataAdapter)this.dataAdapterDesc.getDataAdapter();
        dataAdapter.setQueryExecuterMode(this.btnCheckQEMode.getSelection());
        ArrayList<String> listColumnNames = new ArrayList<String>();
        ArrayList<Integer> listColumnIndexes = new ArrayList<Integer>();
        for (String[] row : this.rows) {
            listColumnNames.add(row[0]);
            listColumnIndexes.add(Integer.valueOf(row[1]));
        }
        switch (this.format.getSelectionIndex()) {
            case 0: {
                dataAdapter.setFormat(ExcelFormatEnum.AUTODETECT);
                break;
            }
            case 1: {
                dataAdapter.setFormat(ExcelFormatEnum.XLS);
                break;
            }
            case 2: {
                dataAdapter.setFormat(ExcelFormatEnum.XLSX);
            }
        }
        dataAdapter.setColumnNames(listColumnNames);
        dataAdapter.setColumnIndexes(listColumnIndexes);
        dataAdapter.setDatePattern(this.dnf.getTextDatePattern());
        dataAdapter.setNumberPattern(this.dnf.getTextNumberPattern());
        dataAdapter.setLocale(this.dnf.getLocale());
        dataAdapter.setTimeZone(this.dnf.getTimeZone());
        dataAdapter.setSheetSelection(this.textSheetSelection.getText());
        dataAdapter.setUseFirstRowAsHeader(this.btnCheckSkipFirstLine.getSelection());
        return this.dataAdapterDesc;
    }

    private String excelCellLabelRenderer(Integer index) {
        String digits = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        if (index != null) {
            int val = index;
            String number = "" + digits.charAt(val % 26);
            while (val > 0) {
                int i = (val /= 26) % 26 - 1;
                if (val == 0) break;
                if (val % 26 == 0) {
                    val -= 26;
                    i = 25;
                }
                number = String.valueOf(digits.charAt(i)) + number;
            }
            return number;
        }
        return null;
    }

    private String[] createDataModelEntry() {
        int i = 0;
        String column = "COLUMN_" + i;
        while (!this.isColumnValid(column)) {
            column = "COLUMN_" + ++i;
        }
        return new String[]{column, String.valueOf(i)};
    }

    private void setTableSelection(int index) {
        if (this.rows != null && this.rows.size() > 0) {
            if (index == 0) {
                this.table.setSelection(index);
            } else if (index > 0 && index < this.rows.size() - 1) {
                this.table.setSelection(index - 1);
            } else {
                this.table.setSelection(this.rows.size() - 1);
            }
        }
    }

    @Override
    protected void fireFileChanged(boolean showWarning) {
        try {
            if (showWarning) {
                if (UIUtils.showConfirmation((String)Messages.CSVDataAdapterComposite_0, (String)Messages.CSVDataAdapterComposite_1)) {
                    this.getExcelColumns();
                }
            } else {
                this.getExcelColumns();
            }
        }
        catch (Exception e) {
            UIUtils.showError((Throwable)e);
        }
    }

    private void getExcelColumns() throws Exception {
        if (this.textFileName.getText().length() > 0) {
            ExcelDataSource ds = new ExcelDataSource(this.getJrContext(), this.textFileName.getText());
            ds.setUseFirstRowAsHeader(true);
            this.rows.clear();
            ds.next();
            Map names = ds.getColumnNames();
            if (names != null) {
                TreeMap<Integer, String> map = new TreeMap<Integer, String>();
                for (Map.Entry entry : names.entrySet()) {
                    map.put((Integer)entry.getValue(), (String)entry.getKey());
                }
                for (Map.Entry entry : map.entrySet()) {
                    this.rows.add(new String[]{(String)entry.getValue(), String.valueOf(entry.getKey())});
                }
            }
            this.tableViewer.setInput(this.rows);
            this.tableViewer.refresh();
            this.setTableSelection(-1);
            this.btnDelete.setEnabled(true);
        }
    }

    public void dispose() {
        if (this.jConfig != null) {
            this.jConfig.dispose();
            this.jConfig = null;
        }
        super.dispose();
    }

    private void removeEntries() {
        int[] indices = this.table.getSelectionIndices();
        if (indices.length > 0) {
            Arrays.sort(indices);
            int removedItems = 0;
            int[] nArray = indices;
            int n = indices.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                this.rows.remove(i - removedItems);
                ++removedItems;
                ++n2;
            }
            this.tableViewer.refresh();
            this.setTableSelection(indices[0]);
        }
    }

    private boolean isColumnValid(String column) {
        if (column == null || "".equals(column)) {
            return false;
        }
        for (String[] row : this.rows) {
            if (!row[0].equals(column)) continue;
            return false;
        }
        return true;
    }

    public String getHelpContextId() {
        return "com.jaspersoft.studio.doc.".concat("adapter_excel");
    }

    @Override
    protected String[] getFileExtensions() {
        return new String[]{"*.xls;*.xlsx", "*.*"};
    }

    private class ColumnNameIndexLabelProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        private ColumnNameIndexLabelProvider(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public String getText(Object element) {
            String[] row = (String[])element;
            if (this.columnIndex == 0) {
                return row[this.columnIndex].toString();
            }
            String excelCellLabel = ExcelDataAdapterComposite.this.excelCellLabelRenderer(Integer.valueOf(row[this.columnIndex].toString()));
            return String.valueOf(row[this.columnIndex]) + Messages.XLSDataAdapterComposite_22 + excelCellLabel + Messages.XLSDataAdapterComposite_23;
        }
    }

    private class NameIndexEditingSupport
    extends EditingSupport {
        private final TableViewer viewer;
        private int columnIndex;

        public NameIndexEditingSupport(TableViewer viewer, int columnIndex) {
            super((ColumnViewer)viewer);
            this.viewer = viewer;
            this.columnIndex = columnIndex;
        }

        protected CellEditor getCellEditor(Object element) {
            return new TextCellEditor((Composite)this.viewer.getTable());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return ((String[])element)[this.columnIndex].toString();
        }

        protected void setValue(Object element, Object value) {
            ((String[])element)[this.columnIndex] = String.valueOf(value);
            this.viewer.refresh();
        }
    }

    private class XLSContentProvider
    implements IStructuredContentProvider {
        private XLSContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }
    }
}

