/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.jdbc;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.ADataAdapterComposite;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.jdbc.JDBCDataAdapterDescriptor;
import com.jaspersoft.studio.data.jdbc.JDBCDriverDefinition;
import com.jaspersoft.studio.data.messages.Messages;
import com.jaspersoft.studio.property.section.widgets.CustomAutoCompleteField;
import com.jaspersoft.studio.swt.widgets.ClasspathComponent;
import com.jaspersoft.studio.swt.widgets.PropertiesComponent;
import com.jaspersoft.studio.swt.widgets.WSecretText;
import com.jaspersoft.studio.utils.UIUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.jdbc.JdbcDataAdapter;
import net.sf.jasperreports.data.jdbc.JdbcDataAdapterImpl;
import net.sf.jasperreports.data.jdbc.TransactionIsolation;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class JDBCDataAdapterComposite
extends ADataAdapterComposite {
    private static final JDBCDriverDefinition[] jdbcDefinitions;
    protected Text textJDBCUrl;
    protected Text textServerAddress;
    protected Text textDatabase;
    protected Text textUsername;
    protected WSecretText textPassword;
    protected Combo comboJDBCDriver;
    protected JDBCDriverDefinition currentdriver = null;
    private ClasspathComponent cpath;
    private PropertiesComponent cproperties;
    protected JDBCDriverDefinition[] definitions;
    private ModifyListener driverModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Combo combo = (Combo)e.widget;
            String text = combo.getText();
            int selectionIndex = -1;
            int i = 0;
            while (i < JDBCDataAdapterComposite.this.definitions.length) {
                String definition = JDBCDataAdapterComposite.this.definitions[i].toString();
                if (definition.equals(text)) {
                    selectionIndex = i;
                    break;
                }
                ++i;
            }
            if (selectionIndex != -1) {
                JDBCDataAdapterComposite.this.currentdriver = JDBCDataAdapterComposite.this.definitions[selectionIndex];
                JDBCDataAdapterComposite.this.btnWizardActionPerformed();
            } else {
                JDBCDataAdapterComposite.this.currentdriver = new JDBCDriverDefinition("", text, JDBCDataAdapterComposite.this.textJDBCUrl.getText());
                JDBCDataAdapterComposite.this.pchangesuport.firePropertyChange("dirty", false, true);
            }
        }
    };
    protected String contextId;
    private Combo bAc;
    private Combo bRO;
    private Combo bTI;

    static {
        List tmpDefinitions = JaspersoftStudioPlugin.getExtensionManager().getJDBCDriverDefinitions();
        jdbcDefinitions = tmpDefinitions.toArray(new JDBCDriverDefinition[tmpDefinitions.size()]);
        Arrays.sort(jdbcDefinitions, new Comparator<JDBCDriverDefinition>(){

            @Override
            public int compare(JDBCDriverDefinition o1, JDBCDriverDefinition o2) {
                return o1.getDbName().compareTo(o2.getDbName());
            }
        });
    }

    public JDBCDriverDefinition[] getDefinitions() {
        return jdbcDefinitions;
    }

    public JDBCDataAdapterComposite(Composite parent, int style, JasperReportsContext jrContext) {
        super(parent, style, jrContext);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.createPreWidgets((Composite)this);
        CTabFolder tabFolder = new CTabFolder((Composite)this, 1024);
        tabFolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(35));
        tabFolder.setLayoutData((Object)new GridData(1808));
        this.createLocationTab(tabFolder);
        this.createPropertiesTab(tabFolder);
        this.createClasspathTab(tabFolder);
        tabFolder.setSelection(0);
        this.contextId = "adapter_JDBC";
    }

    protected void createPreWidgets(Composite parent) {
    }

    protected void createClasspathTab(CTabFolder tabFolder) {
        CTabItem tbtmNewItem_1 = new CTabItem(tabFolder, 0);
        tbtmNewItem_1.setText(Messages.JDBCDataAdapterComposite_classpath);
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        tbtmNewItem_1.setControl((Control)composite);
        this.cpath = new ClasspathComponent(composite){

            protected void handleClasspathChanged() {
                JDBCDataAdapterComposite.this.pchangesuport.firePropertyChange("dirty", false, true);
            }
        };
        this.cpath.getControl().setLayoutData((Object)new GridData(1808));
    }

    protected void createPropertiesTab(CTabFolder tabFolder) {
        CTabItem tbtmNewItem = new CTabItem(tabFolder, 0);
        tbtmNewItem.setText(Messages.JDBCDataAdapterComposite_connectionproperties);
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        tbtmNewItem.setControl((Control)composite);
        new Label(composite, 0).setText("Auto Commit");
        this.bAc = new Combo(composite, 8);
        this.bAc.setItems(new String[]{"", "True", "False"});
        new Label(composite, 0).setText("Read Only");
        this.bRO = new Combo(composite, 8);
        this.bRO.setItems(new String[]{"", "True", "False"});
        new Label(composite, 0).setText("Transaction Isolation");
        this.bTI = new Combo(composite, 8);
        this.bTI.setItems(new String[]{"", "None", "Read Uncommitted", "Read Committed", "Repeatable Read", "Serializable"});
        this.cproperties = new PropertiesComponent(composite){

            protected void handlePropertiesChanged() {
                JDBCDataAdapterComposite.this.pchangesuport.firePropertyChange("dirty", false, true);
            }
        };
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.cproperties.getControl().setLayoutData((Object)gd);
    }

    protected void createLocationTab(CTabFolder tabFolder) {
        CTabItem tbtmNewItem_2 = new CTabItem(tabFolder, 0);
        tbtmNewItem_2.setText(Messages.JDBCDataAdapterComposite_tablocation);
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        tbtmNewItem_2.setControl((Control)composite);
        Label lbl = new Label(composite, 0);
        lbl.setLayoutData((Object)new GridData(32));
        lbl.setText(Messages.JDBCDataAdapterComposite_driverlabel);
        this.comboJDBCDriver = new Combo(composite, 0);
        this.comboJDBCDriver.setLayoutData((Object)new GridData(768));
        lbl = new Label(composite, 0);
        lbl.setLayoutData((Object)new GridData(32));
        lbl.setText(Messages.JDBCDataAdapterComposite_urllabel);
        this.textJDBCUrl = new Text(composite, 2048);
        this.textJDBCUrl.setLayoutData((Object)new GridData(768));
        this.createURLAssistant(composite);
        this.createUserPass(composite);
        this.definitions = this.getDefinitions();
        String[] items = new String[this.definitions.length];
        int i = 0;
        while (i < this.definitions.length) {
            items[i] = this.definitions[i].toString();
            ++i;
        }
        this.comboJDBCDriver.setItems(items);
        final CustomAutoCompleteField driverAutocomplete = new CustomAutoCompleteField((Control)this.comboJDBCDriver, (IControlContentAdapter)new ComboContentAdapter(), items);
        this.comboJDBCDriver.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                driverAutocomplete.closeProposalPopup();
            }
        });
        this.comboJDBCDriver.select(0);
        this.comboJDBCDriver.addModifyListener(this.driverModifyListener);
    }

    protected void createUserPass(Composite composite) {
        Label lbl = new Label(composite, 0);
        lbl.setLayoutData((Object)new GridData(32));
        lbl.setText(Messages.JDBCDataAdapterComposite_username);
        this.textUsername = new Text(composite, 2048);
        this.textUsername.setLayoutData((Object)new GridData(768));
        lbl = new Label(composite, 0);
        lbl.setLayoutData((Object)new GridData(32));
        lbl.setText(Messages.JDBCDataAdapterComposite_password);
        this.textPassword = new WSecretText(composite, 0x400800);
        this.textPassword.setLayoutData((Object)new GridData(768));
        new Label(composite, 0);
        Composite c = new Composite(composite, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        lbl = new Label(c, 1);
        lbl.setText(Messages.JDBCDataAdapterComposite_attentionlable);
        UIUtil.setBold((Control)lbl);
        lbl = new Label(c, 0);
        lbl.setText(Messages.JDBCDataAdapterComposite_attention);
    }

    protected void createURLAssistant(Composite composite) {
    }

    protected void btnWizardActionPerformed() {
        if (this.currentdriver != null) {
            this.textJDBCUrl.setText(this.currentdriver.getUrl("localhost", "database"));
            this.getDriverProperties();
        }
    }

    protected void getDriverProperties() {
    }

    public void setDataAdapter(JDBCDataAdapterDescriptor editingDataAdapter) {
        super.setDataAdapter((DataAdapterDescriptor)editingDataAdapter);
        JdbcDataAdapter jdbcDataAdapter = (JdbcDataAdapter)this.dataAdapterDesc.getDataAdapter();
        if (jdbcDataAdapter.getDriver() == null) {
            this.btnWizardActionPerformed();
        }
        if (!this.textPassword.isWidgetConfigured()) {
            this.textPassword.loadSecret("net.sf.jasperreports.data.adapter", this.textPassword.getText());
        }
        this.getDriverProperties();
    }

    protected void bindWidgets(DataAdapter dataAdapter) {
        JdbcDataAdapter jdbcDataAdapter = (JdbcDataAdapter)dataAdapter;
        String driverName = Misc.nvl((Object)jdbcDataAdapter.getDriver(), (String)"org.hsqldb.jdbcDriver");
        this.comboJDBCDriver.removeModifyListener(this.driverModifyListener);
        this.comboJDBCDriver.setText(driverName);
        this.comboJDBCDriver.addModifyListener(this.driverModifyListener);
        this.currentdriver = null;
        JDBCDriverDefinition[] jDBCDriverDefinitionArray = this.definitions;
        int n = this.definitions.length;
        int n2 = 0;
        while (n2 < n) {
            JDBCDriverDefinition d = jDBCDriverDefinitionArray[n2];
            if (d.getDriverName().equals(driverName)) {
                this.currentdriver = d;
                break;
            }
            ++n2;
        }
        if (this.currentdriver == null) {
            this.currentdriver = new JDBCDriverDefinition("", this.comboJDBCDriver.getText(), ((JdbcDataAdapter)dataAdapter).getUrl());
        }
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.textUsername, (int)24), PojoObservables.observeValue((Object)dataAdapter, (String)"username"));
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.textPassword, (int)24), PojoObservables.observeValue((Object)dataAdapter, (String)"password"));
        this.bindURLAssistant(dataAdapter);
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.textJDBCUrl, (int)24), PojoObservables.observeValue((Object)dataAdapter, (String)"url"));
        Proxy p = new Proxy((JdbcDataAdapterImpl)dataAdapter);
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeSingleSelectionIndex((Control)this.bAc), PojoObservables.observeValue((Object)p, (String)"autoCommit"));
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeSingleSelectionIndex((Control)this.bRO), PojoObservables.observeValue((Object)p, (String)"readOnly"));
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeSingleSelectionIndex((Control)this.bTI), PojoObservables.observeValue((Object)p, (String)"transactionIsolation"));
        this.cpath.setClasspaths(jdbcDataAdapter.getClasspath());
        this.cproperties.setProperties(jdbcDataAdapter.getProperties());
    }

    public static TransactionIsolation getTransactionIsolation(int indx) {
        switch (indx) {
            case 1: {
                return TransactionIsolation.NONE;
            }
            case 2: {
                return TransactionIsolation.READ_UNCOMMITTED;
            }
            case 3: {
                return TransactionIsolation.READ_COMMITTED;
            }
            case 4: {
                return TransactionIsolation.REPEATABLE_READ;
            }
            case 5: {
                return TransactionIsolation.SERIALIZABLE;
            }
        }
        return null;
    }

    protected void bindURLAssistant(DataAdapter dataAdapter) {
        if (this.textServerAddress != null) {
            this.bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.textServerAddress, (int)24), PojoObservables.observeValue((Object)dataAdapter, (String)"serverAddress"));
        }
        if (this.textDatabase != null) {
            this.bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.textDatabase, (int)24), PojoObservables.observeValue((Object)dataAdapter, (String)"database"));
        }
    }

    public DataAdapterDescriptor getDataAdapter() {
        if (this.dataAdapterDesc == null) {
            this.dataAdapterDesc = new JDBCDataAdapterDescriptor();
        }
        JdbcDataAdapter jdbcDataAdapter = (JdbcDataAdapter)this.dataAdapterDesc.getDataAdapter();
        JDBCDriverDefinition currentdriver = null;
        String selectedDriverText = this.comboJDBCDriver.getText();
        JDBCDriverDefinition[] jDBCDriverDefinitionArray = this.definitions;
        int n = this.definitions.length;
        int n2 = 0;
        while (n2 < n) {
            JDBCDriverDefinition d = jDBCDriverDefinitionArray[n2];
            if (d.toString().equals(selectedDriverText)) {
                currentdriver = d;
                break;
            }
            ++n2;
        }
        if (currentdriver == null) {
            jdbcDataAdapter.setDriver(selectedDriverText);
        } else {
            jdbcDataAdapter.setDriver(currentdriver.getDriverName());
        }
        jdbcDataAdapter.setUsername(this.textUsername.getText());
        jdbcDataAdapter.setPassword(this.textPassword.getText());
        jdbcDataAdapter.setUrl(this.textJDBCUrl.getText());
        this.getDataAdapterURLAssistant(jdbcDataAdapter);
        jdbcDataAdapter.setSavePassword(true);
        jdbcDataAdapter.setClasspath(this.cpath.getClasspaths());
        jdbcDataAdapter.setProperties(this.cproperties.getProperties());
        return this.dataAdapterDesc;
    }

    protected void getDataAdapterURLAssistant(JdbcDataAdapter jdbcDataAdapter) {
        if (this.textDatabase != null) {
            jdbcDataAdapter.setDatabase(this.textDatabase.getText());
        } else {
            jdbcDataAdapter.setDatabase("");
        }
        if (this.textServerAddress != null) {
            jdbcDataAdapter.setServerAddress(this.textServerAddress.getText());
        } else {
            jdbcDataAdapter.setServerAddress("");
        }
    }

    public String getHelpContextId() {
        return "com.jaspersoft.studio.doc.".concat(this.contextId);
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public void performAdditionalUpdates() {
        if (JaspersoftStudioPlugin.shouldUseSecureStorage()) {
            this.textPassword.persistSecret();
            JdbcDataAdapter jdbcDataAdapter = (JdbcDataAdapter)this.dataAdapterDesc.getDataAdapter();
            jdbcDataAdapter.setPassword(this.textPassword.getUUIDKey());
        }
    }

    class Proxy {
        private JdbcDataAdapterImpl da;

        public Proxy(JdbcDataAdapterImpl da) {
            this.da = da;
        }

        public int getAutoCommit() {
            if (this.da.getAutoCommit() == null) {
                return 0;
            }
            return this.da.getAutoCommit() != false ? 1 : 2;
        }

        public void setAutoCommit(int indx) {
            switch (indx) {
                case 0: {
                    this.da.setAutoCommit(null);
                    break;
                }
                case 1: {
                    this.da.setAutoCommit(Boolean.valueOf(true));
                    break;
                }
                default: {
                    this.da.setAutoCommit(Boolean.valueOf(false));
                }
            }
        }

        public int getReadOnly() {
            if (this.da.getReadOnly() == null) {
                return 0;
            }
            return this.da.getReadOnly() != false ? 1 : 2;
        }

        public void setReadOnly(int indx) {
            switch (indx) {
                case 0: {
                    this.da.setReadOnly(null);
                    break;
                }
                case 1: {
                    this.da.setReadOnly(Boolean.valueOf(true));
                    break;
                }
                default: {
                    this.da.setReadOnly(Boolean.valueOf(false));
                }
            }
        }

        public void setTransactionIsolation(int indx) {
            this.da.setTransactionIsolation(JDBCDataAdapterComposite.getTransactionIsolation(indx));
        }

        public int getTransactionIsolation() {
            TransactionIsolation ti = this.da.getTransactionIsolation();
            if (ti != null) {
                if (ti.equals((Object)TransactionIsolation.NONE)) {
                    return 1;
                }
                if (ti.equals((Object)TransactionIsolation.READ_UNCOMMITTED)) {
                    return 2;
                }
                if (ti.equals((Object)TransactionIsolation.READ_COMMITTED)) {
                    return 3;
                }
                if (ti.equals((Object)TransactionIsolation.REPEATABLE_READ)) {
                    return 4;
                }
                if (ti.equals((Object)TransactionIsolation.SERIALIZABLE)) {
                    return 5;
                }
            }
            return 0;
        }
    }
}

