/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.json;

import com.jaspersoft.studio.data.AWizardDataEditorComposite;
import com.jaspersoft.studio.data.Activator;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterEditor;
import com.jaspersoft.studio.data.FieldTypeGuesser;
import com.jaspersoft.studio.data.IWizardDataEditorProvider;
import com.jaspersoft.studio.data.fields.IFieldsProvider;
import com.jaspersoft.studio.data.json.JsonDataAdapterEditor;
import com.jaspersoft.studio.data.json.JsonWizardDataEditorComposite;
import com.jaspersoft.studio.data.querydesigner.json.JsonDataManager;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.utils.parameter.ParameterUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.data.json.JsonDataAdapter;
import net.sf.jasperreports.data.json.JsonDataAdapterImpl;
import net.sf.jasperreports.data.json.JsonExpressionLanguageEnum;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.query.JsonQLQueryExecuterFactory;
import net.sf.jasperreports.engine.query.JsonQueryExecuterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class JsonDataAdapterDescriptor
extends DataAdapterDescriptor
implements IFieldsProvider,
IWizardDataEditorProvider {
    public static final long serialVersionUID = 10200L;

    public JsonDataAdapter getDataAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new JsonDataAdapterImpl();
        }
        return (JsonDataAdapter)this.dataAdapter;
    }

    public DataAdapterEditor getEditor() {
        return new JsonDataAdapterEditor();
    }

    public Image getIcon(int size) {
        if (size == 16) {
            return Activator.getDefault().getImage("icons/json.png");
        }
        return null;
    }

    public boolean supportsGetFieldsOperation(JasperReportsConfiguration jConfig, JRDataset jDataset) {
        return true;
    }

    public List<JRDesignField> getFields(DataAdapterService con, JasperReportsConfiguration jConfig, JRDataset jDataset) throws JRException, UnsupportedOperationException {
        IProgressMonitor monitor = (IProgressMonitor)jConfig.getMap().get("monitor");
        HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
        parameters.put("REPORT_PARAMETERS_MAP", new HashMap());
        con.contributeParameters(parameters);
        ParameterUtil.setParameters((JasperReportsConfiguration)jConfig, (JRDataset)jDataset, parameters);
        parameters.put("REPORT_MAX_COUNT", Integer.valueOf(1000));
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        IOException err = null;
        ArrayList<JRDesignField> fields = new ArrayList<JRDesignField>();
        try {
            String language = JsonExpressionLanguageEnum.JSON.getName();
            if (this.getDataAdapter().getLanguage() != null) {
                language = this.getDataAdapter().getLanguage().getName();
            }
            if (jDataset.getQuery() != null) {
                language = jDataset.getQuery().getLanguage();
            }
            JsonDataManager m = new JsonDataManager(language);
            m.loadJsonDataFile(this.getDataAdapter().getDataFile(), jConfig, jDataset);
            fields.addAll(m.extractFields(jDataset.getQuery().getText()));
            JRDataSource ds = (JRDataSource)parameters.get("REPORT_DATA_SOURCE");
            if (ds == null) {
                JsonQueryExecuterFactory qef = language.equals(JsonExpressionLanguageEnum.JSON.getName()) ? new JsonQueryExecuterFactory() : new JsonQLQueryExecuterFactory();
                ds = qef.createQueryExecuter((JasperReportsContext)jConfig, jDataset, ParameterUtil.convertMap(parameters, (JRDataset)jDataset)).createDatasource();
            }
            FieldTypeGuesser.guessTypes(ds, fields, ds.next(), monitor);
        }
        catch (IOException e) {
            err = e;
        }
        if (err != null) {
            throw new JRException((Throwable)err);
        }
        return fields;
    }

    public AWizardDataEditorComposite createDataEditorComposite(Composite parent, WizardPage page) {
        return new JsonWizardDataEditorComposite(parent, page, this);
    }

    public String[] getLanguages() {
        return new String[]{JsonExpressionLanguageEnum.JSON.getName(), JsonExpressionLanguageEnum.JSONQL.getName()};
    }
}

