/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.json;

import com.jaspersoft.studio.data.ATreeWizardDataEditorComposite;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.designer.tree.NodeBoldStyledLabelProvider;
import com.jaspersoft.studio.data.messages.Messages;
import com.jaspersoft.studio.data.querydesigner.json.JsonDataManager;
import com.jaspersoft.studio.data.querydesigner.json.JsonLineStyler;
import com.jaspersoft.studio.data.querydesigner.json.JsonTreeContentProvider;
import com.jaspersoft.studio.data.querydesigner.json.JsonTreeCustomStatus;
import com.jaspersoft.studio.model.datasource.json.JsonSupportNode;
import net.sf.jasperreports.data.json.JsonDataAdapter;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRDataset;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.progress.WorkbenchJob;

public class JsonWizardDataEditorComposite
extends ATreeWizardDataEditorComposite {
    private static final int JOB_DELAY = 300;
    private JsonDataManager jsonDataManager;
    private DecorateTreeViewerJob decorateJob;
    private NodeBoldStyledLabelProvider<JsonSupportNode> treeLabelProvider;
    private JsonTreeContentProvider treeContentProvider;
    private JsonLineStyler lineStyler;

    public JsonWizardDataEditorComposite(Composite parent, WizardPage page, DataAdapterDescriptor dataAdapterDescriptor) {
        super(parent, page, dataAdapterDescriptor);
    }

    protected void init() {
        super.init();
        this.jsonDataManager = new JsonDataManager(this.getQueryLanguage());
        this.lineStyler = new JsonLineStyler();
        this.decorateJob = new DecorateTreeViewerJob();
        this.treeLabelProvider = new NodeBoldStyledLabelProvider();
        this.treeContentProvider = new JsonTreeContentProvider();
    }

    protected IBaseLabelProvider getTreeLabelProvider() {
        return this.treeLabelProvider;
    }

    protected IContentProvider getTreeContentProvider() {
        return this.treeContentProvider;
    }

    protected void createTreeViewer(Composite parent) {
        super.createTreeViewer(parent);
        this.addDoubleClickSupport();
    }

    protected void createQueryTextArea(Composite parent) {
        super.createQueryTextArea(parent);
        this.queryTextArea.addLineStyleListener((LineStyleListener)this.lineStyler);
    }

    protected void refreshTreeViewerContent(DataAdapterDescriptor da) {
        if (da != null && da.getDataAdapter() instanceof JsonDataAdapter) {
            this.treeViewer.setInput((Object)JsonTreeCustomStatus.LOADING_JSON);
            UIUtils.getDisplay().asyncExec(() -> {
                try {
                    this.jsonDataManager.loadJsonDataFile(((JsonDataAdapter)da.getDataAdapter()).getDataFile(), this.getJasperReportsConfiguration(), (JRDataset)this.getDataset());
                    this.treeViewer.setInput((Object)this.jsonDataManager.getJsonSupportModel());
                    this.treeViewer.expandToLevel(2);
                    this.decorateTreeUsingQueryText();
                }
                catch (Exception e) {
                    this.getStatusBar().showError((Throwable)e);
                    this.treeViewer.getTree().removeAll();
                    this.treeViewer.setInput((Object)JsonTreeCustomStatus.ERROR_LOADING_JSON);
                }
            });
        } else {
            this.treeViewer.getTree().removeAll();
            this.treeViewer.setInput((Object)JsonTreeCustomStatus.FILE_NOT_FOUND);
        }
    }

    private void addDoubleClickSupport() {
        this.treeViewer.addDoubleClickListener(event -> {
            TreeSelection s = (TreeSelection)this.treeViewer.getSelection();
            if (s.getFirstElement() instanceof JsonSupportNode) {
                JsonSupportNode jsonNode = (JsonSupportNode)s.getFirstElement();
                String queryExpression = this.jsonDataManager.getQueryExpression(null, jsonNode);
                this.queryTextArea.setText(queryExpression);
            }
        });
    }

    protected void decorateTreeUsingQueryText() {
        if (this.jsonDataManager.getJsonSupportModel() != null) {
            this.decorateJob.cancel();
            this.decorateJob.schedule(300L);
        }
    }

    public void dispose() {
        if (this.decorateJob != null) {
            this.decorateJob.cancel();
            this.decorateJob = null;
        }
        super.dispose();
    }

    public String getQueryLanguage() {
        JsonDataAdapter da = (JsonDataAdapter)this.getDataAdapterDescriptor().getDataAdapter();
        return da.getLanguage().getName();
    }

    private final class DecorateTreeViewerJob
    extends WorkbenchJob {
        public DecorateTreeViewerJob() {
            super(Messages.JsonWizardDataEditorComposite_Job);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!JsonWizardDataEditorComposite.this.isDisposed()) {
                monitor.beginTask(Messages.JsonWizardDataEditorComposite_Task, -1);
                String query = JsonWizardDataEditorComposite.this.queryTextArea.getText();
                JsonWizardDataEditorComposite.this.treeLabelProvider.setSelectedNodes(JsonWizardDataEditorComposite.this.jsonDataManager.getSelectableNodes(query));
                JsonWizardDataEditorComposite.this.treeViewer.refresh();
                monitor.done();
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
    }
}

