/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.querydesigner.json;

import com.jaspersoft.studio.data.querydesigner.json.JsonTokensType;
import java.util.Arrays;
import java.util.List;

public class JsonScanner {
    public static final int EOF_CHAR = -1;
    public static final int EOL_CHAR = 10;
    private static List<String> jsonKeywords;
    private static List<String> jsonOperatorsAndSymbols;
    private StringBuffer fBuffer = new StringBuffer();
    private String fDoc;
    private int fPos;
    private int fEnd;
    private int fStartToken;

    public JsonScanner() {
        this.initJsonKeywords();
        this.initJsonSymbolsAndOperators();
    }

    /*
     * Unable to fully structure code
     */
    public JsonTokensType nextToken() {
        this.fStartToken = this.fPos;
        block16: while (true) {
            c = this.read();
            switch (c) {
                case -1: {
                    return JsonTokensType.EOF;
                }
                case 36: {
                    c = this.read();
                    jrbaseExprType = null;
                    if (c == 80) {
                        jrbaseExprType = JsonTokensType.JRPARAMETER;
                    } else {
                        if (c != 70) continue block16;
                        jrbaseExprType = JsonTokensType.JRFIELD;
                    }
                    ** GOTO lbl18
                    if (c != 86) continue block16;
                    jrbaseExprType = JsonTokensType.JRVARIABLE;
lbl18:
                    // 3 sources

                    c = this.read();
                    if (c == 123) {
                        while (true) {
                            c = this.read();
                            switch (c) {
                                case 125: {
                                    return jrbaseExprType;
                                }
                                case -1: {
                                    this.unread(c);
                                    return jrbaseExprType;
                                }
                                case 92: {
                                    c = this.read();
                                }
                            }
                        }
                    }
                }
                case 34: {
                    while (true) {
                        c = this.read();
                        switch (c) {
                            case 34: {
                                return JsonTokensType.QUOTED_LITERAL;
                            }
                            case -1: {
                                this.unread(c);
                                return JsonTokensType.QUOTED_LITERAL;
                            }
                            case 92: {
                                c = this.read();
                            }
                        }
                    }
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    while (Character.isDigit((char)(c = this.read()))) {
                    }
                    this.unread(c);
                    return JsonTokensType.NUMBER;
                }
            }
            break;
        }
        if (JsonScanner.jsonOperatorsAndSymbols.contains(Character.toString((char)c))) {
            return JsonTokensType.SYMBOL;
        }
        if (Character.isWhitespace((char)c)) {
            while (Character.isWhitespace((char)(c = this.read()))) {
            }
            this.unread(c);
            return JsonTokensType.SPACE;
        }
        if (Character.isJavaIdentifierStart((char)c)) {
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)c);
            } while (Character.isJavaIdentifierPart((char)(c = this.read())));
            this.unread(c);
            if (JsonScanner.jsonKeywords.contains(this.fBuffer.toString().toLowerCase())) {
                return JsonTokensType.KEYWORD;
            }
            return JsonTokensType.OTHER;
        }
        return JsonTokensType.OTHER;
    }

    private int read() {
        if (this.fPos <= this.fEnd) {
            return this.fDoc.charAt(this.fPos++);
        }
        return -1;
    }

    private void unread(int c) {
        if (c != -1) {
            --this.fPos;
        }
    }

    public void setRange(String text) {
        this.fDoc = text;
        this.fPos = 0;
        this.fEnd = this.fDoc.length() - 1;
    }

    public int getStartOffset() {
        return this.fStartToken;
    }

    public int getLength() {
        return this.fPos - this.fStartToken;
    }

    protected void initJsonKeywords() {
        if (jsonKeywords == null) {
            jsonKeywords = Arrays.asList("true", "false", "null");
        }
    }

    protected void initJsonSymbolsAndOperators() {
        if (jsonOperatorsAndSymbols == null) {
            jsonOperatorsAndSymbols = Arrays.asList("[", "]", "=", "!", ">", "<");
        }
    }
}

