/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.querydesigner.xpath;

import com.jaspersoft.studio.data.designer.tree.ISelectableNodes;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.model.datasource.xml.XMLAttributeNode;
import com.jaspersoft.studio.model.datasource.xml.XMLNode;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuter;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuterUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDocumentManager
implements ISelectableNodes<XMLNode> {
    private Document xmlDocument;
    private JRXPathExecuter xPathExecuter;
    private Map<XMLNode, Node> documentNodesMap;
    private JasperReportsConfiguration jConfig;

    public void setDocument(Document doc) {
        this.xmlDocument = doc;
        this.getDocumentNodesMap().clear();
    }

    public boolean isDocumentSet() {
        return this.xmlDocument != null;
    }

    public MRoot getXMLDocumentModel() {
        if (this.xmlDocument != null) {
            MRoot docRoot = new MRoot(null, null);
            List<XMLNode> childrenXMLNodes = this.getChildrenXMLNodes(this.xmlDocument);
            for (XMLNode childNode : childrenXMLNodes) {
                childNode.setParent((ANode)docRoot, -1);
            }
            return docRoot;
        }
        return null;
    }

    private List<XMLNode> getChildrenXMLNodes(Node node) {
        ArrayList<XMLNode> children = new ArrayList<XMLNode>();
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                XMLAttributeNode attrNode = new XMLAttributeNode();
                this.getDocumentNodesMap().put((XMLNode)attrNode, attrs.item(i));
                attrNode.setName(attrs.item(i).getNodeName());
                children.add((XMLNode)attrNode);
                ++i;
            }
        }
        NodeList nl = node.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeType() == 1) {
                XMLNode n = new XMLNode();
                this.getDocumentNodesMap().put(n, nl.item(i));
                n.setName(nl.item(i).getNodeName());
                List<XMLNode> childrenXMLNodes = this.getChildrenXMLNodes(nl.item(i));
                for (XMLNode childNode : childrenXMLNodes) {
                    childNode.setParent((ANode)n, -1);
                }
                children.add(n);
            }
            ++i;
        }
        return children;
    }

    public String getXPathExpression(String query, XMLNode xmlNode) {
        Node selectedNode = this.getDocumentNodesMap().get(xmlNode);
        boolean isAttribute = selectedNode instanceof Attr;
        String attributePostfix = "";
        if (isAttribute) {
            attributePostfix = "/@" + selectedNode.getNodeName();
        }
        String selectedPath = this.getAbsoluteXPathExpression(selectedNode);
        if (query == null || query.equals("")) {
            return this.getAbsoluteXPathExpression(selectedNode);
        }
        List<Node> selectedNodeList = this.selectNodeList(query);
        for (Node currnode : selectedNodeList) {
            String currentPath = this.getAbsoluteXPathExpression(currnode);
            if (selectedPath.equals(currentPath)) {
                return "child::text()";
            }
            if (selectedPath.startsWith(currentPath)) {
                return selectedPath.replace(String.valueOf(currentPath) + "/", "");
            }
            if (currentPath.startsWith(selectedPath)) {
                return "ancestor::" + selectedNode.getNodeName();
            }
            if (!isAttribute || !currentPath.startsWith(selectedPath.replace(attributePostfix, ""))) continue;
            return "ancestor::" + ((Attr)selectedNode).getOwnerElement().getNodeName() + attributePostfix;
        }
        return selectedPath;
    }

    private String getAbsoluteXPathExpression(Node node) {
        StringBuffer sb = new StringBuffer();
        while (!(node instanceof Document)) {
            if (node instanceof Attr) {
                sb.insert(0, "/@" + node.getNodeName());
                node = ((Attr)node).getOwnerElement();
                continue;
            }
            sb.insert(0, "/" + node.getNodeName());
            node = node.getParentNode();
        }
        return sb.toString();
    }

    private JRXPathExecuter getXPathQueryExecuter() {
        if (this.xPathExecuter == null) {
            try {
                this.xPathExecuter = JRXPathExecuterUtils.getXPathExecuter((JasperReportsContext)this.jConfig);
            }
            catch (JRException e) {
                UIUtils.showError((Throwable)e);
            }
            catch (Error e) {
                UIUtils.showError((Throwable)e);
            }
        }
        return this.xPathExecuter;
    }

    public Map<XMLNode, Node> getDocumentNodesMap() {
        if (this.documentNodesMap == null) {
            this.documentNodesMap = new HashMap<XMLNode, Node>();
        }
        return this.documentNodesMap;
    }

    public List<Node> selectNodeList(String query) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        try {
            JRXPathExecuter xPathQueryExecuter = this.getXPathQueryExecuter();
            if (xPathQueryExecuter != null) {
                NodeList selectNodeList = xPathQueryExecuter.selectNodeList((Node)this.xmlDocument, query);
                int i = 0;
                while (i < selectNodeList.getLength()) {
                    nodes.add(selectNodeList.item(i));
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
        return nodes;
    }

    public List<XMLNode> getSelectableNodes(String query) {
        List<Node> nodes = this.selectNodeList(query);
        ArrayList<XMLNode> selected = new ArrayList<XMLNode>();
        for (XMLNode n : this.getDocumentNodesMap().keySet()) {
            if (!nodes.contains(this.getDocumentNodesMap().get(n))) continue;
            selected.add(n);
        }
        return selected;
    }

    public void setJasperConfiguration(JasperReportsConfiguration jConfig) {
        this.jConfig = jConfig;
    }
}

