/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.querydesigner.xpath;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.designer.tree.NodeBoldStyledLabelProvider;
import com.jaspersoft.studio.data.designer.tree.TreeBasedQueryDesigner;
import com.jaspersoft.studio.data.messages.Messages;
import com.jaspersoft.studio.data.querydesigner.xpath.XMLDocumentManager;
import com.jaspersoft.studio.data.querydesigner.xpath.XMLTreeCustomStatus;
import com.jaspersoft.studio.data.querydesigner.xpath.XPathTreeViewerContentProvider;
import com.jaspersoft.studio.dnd.NodeDragListener;
import com.jaspersoft.studio.dnd.NodeTransfer;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.datasource.xml.XMLAttributeNode;
import com.jaspersoft.studio.model.datasource.xml.XMLNode;
import com.jaspersoft.studio.utils.XMLUtils;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jasperreports.data.DataFile;
import net.sf.jasperreports.data.DataFileStream;
import net.sf.jasperreports.data.DataFileUtils;
import net.sf.jasperreports.data.xml.XmlDataAdapter;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.progress.UIJob;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPathQueryDesigner
extends TreeBasedQueryDesigner {
    private static final int JOB_DELAY = 300;
    private XMLDocumentManager documentManager = new XMLDocumentManager();
    private DecorateTreeViewerJob decorateJob = new DecorateTreeViewerJob();
    private XMLLoaderJob xmlLoaderJob = new XMLLoaderJob();
    private NodeBoldStyledLabelProvider<XMLNode> treeLabelProvider = new NodeBoldStyledLabelProvider();
    private Composite toolbarComposite;

    public Control createToolbar(Composite parent) {
        if (this.showAdditionalInfo()) {
            this.toolbarComposite = new Composite(parent, 0);
            this.toolbarComposite.setBackgroundMode(2);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.toolbarComposite.setLayout((Layout)layout);
            this.toolbarComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            Button btn = new Button(this.toolbarComposite, 8);
            btn.setText(Messages.XPathQueryDesigner_ReadFieldsButton);
            btn.setLayoutData((Object)new GridData(131072, 4, true, false));
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    XPathQueryDesigner.this.container.doGetFields();
                }
            });
            return this.toolbarComposite;
        }
        return null;
    }

    public Control getToolbarControl() {
        return this.toolbarComposite;
    }

    protected void createTitleBar(Composite parent) {
        if (this.showAdditionalInfo()) {
            Label titleLabel = new Label(parent, 64);
            titleLabel.setText(Messages.XPathQueryDesigner_InfoTitle);
            titleLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        }
    }

    private boolean showAdditionalInfo() {
        return this.container.getContainerType() == 2;
    }

    protected void decorateTreeUsingQueryText() {
        if (this.documentManager.isDocumentSet()) {
            this.decorateJob.cancel();
            this.decorateJob.schedule(300L);
        }
    }

    protected void createTreeViewer(Composite parent) {
        super.createTreeViewer(parent);
        if (this.showAdditionalInfo()) {
            this.addDragSupport();
            this.createContextualMenu();
        }
        this.addDoubleClickSupport();
    }

    protected IBaseLabelProvider getTreeLabelProvider() {
        return this.treeLabelProvider;
    }

    protected IContentProvider getTreeContentProvider() {
        return new XPathTreeViewerContentProvider();
    }

    private void addDoubleClickSupport() {
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection s = (TreeSelection)XPathQueryDesigner.this.treeViewer.getSelection();
                if (s.getFirstElement() instanceof XMLNode) {
                    XMLNode xmlNode = (XMLNode)s.getFirstElement();
                    String xPathExpression = XPathQueryDesigner.this.documentManager.getXPathExpression(null, xmlNode);
                    XPathQueryDesigner.this.queryTextArea.setText(xPathExpression != null ? xPathExpression : "");
                }
            }
        });
    }

    private void addDragSupport() {
        int ops = 3;
        Transfer[] transfers = new Transfer[]{NodeTransfer.getInstance(), PluginTransfer.getInstance()};
        this.treeViewer.addDragSupport(ops, transfers, (DragSourceListener)new NodeDragListener((StructuredViewer)this.treeViewer){

            public void dragStart(DragSourceEvent event) {
                TreeSelection s = (TreeSelection)XPathQueryDesigner.this.treeViewer.getSelection();
                if (s.getFirstElement() instanceof XMLNode) {
                    XMLNode xmlNode = (XMLNode)s.getFirstElement();
                    xmlNode.setXPathExpression(XPathQueryDesigner.this.documentManager.getXPathExpression(XPathQueryDesigner.this.queryTextArea.getText(), xmlNode));
                    event.doit = !s.isEmpty();
                } else {
                    event.doit = false;
                }
            }

            public void dragFinished(DragSourceEvent event) {
                if (!event.doit) {
                    return;
                }
            }
        });
    }

    private void createContextualMenu() {
        Menu contextMenu = new Menu((Control)this.treeViewer.getTree());
        final MenuItem setRecordNodeItem = new MenuItem(contextMenu, 8);
        setRecordNodeItem.setText(Messages.XPathQueryDesigner_SetRecordItem);
        setRecordNodeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object sel = ((IStructuredSelection)XPathQueryDesigner.this.treeViewer.getSelection()).getFirstElement();
                if (sel instanceof XMLNode) {
                    String xPathExpression = XPathQueryDesigner.this.documentManager.getXPathExpression(null, (XMLNode)sel);
                    XPathQueryDesigner.this.queryTextArea.setText(xPathExpression != null ? xPathExpression : "");
                }
            }
        });
        final MenuItem setDocumentRootItem = new MenuItem(contextMenu, 8);
        setDocumentRootItem.setText(Messages.XPathQueryDesigner_SetDocRootItem);
        setDocumentRootItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object sel = ((IStructuredSelection)XPathQueryDesigner.this.treeViewer.getSelection()).getFirstElement();
                try {
                    Document newDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                    Node originalNode = XPathQueryDesigner.this.documentManager.getDocumentNodesMap().get(sel);
                    Node importedNode = newDocument.importNode(originalNode, true);
                    newDocument.appendChild(importedNode);
                    XPathQueryDesigner.this.documentManager.setDocument(newDocument);
                    XPathQueryDesigner.this.treeViewer.setInput((Object)XPathQueryDesigner.this.documentManager.getXMLDocumentModel());
                }
                catch (Exception e1) {
                    UIUtils.showError((Throwable)e1);
                }
            }
        });
        new MenuItem(contextMenu, 2);
        final MenuItem addNodeAsFieldItem1 = new MenuItem(contextMenu, 8);
        addNodeAsFieldItem1.setText(Messages.XPathQueryDesigner_AddAsFieldItem);
        addNodeAsFieldItem1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object sel = ((IStructuredSelection)XPathQueryDesigner.this.treeViewer.getSelection()).getFirstElement();
                if (sel instanceof XMLNode) {
                    String xPathExpression = XPathQueryDesigner.this.documentManager.getXPathExpression(XPathQueryDesigner.this.queryTextArea.getText(), (XMLNode)sel);
                    ((XMLNode)sel).setXPathExpression(xPathExpression);
                    XPathQueryDesigner.this.createField((ANode)((XMLNode)sel));
                }
            }
        });
        final MenuItem addNodeAsFieldItem2 = new MenuItem(contextMenu, 8);
        addNodeAsFieldItem2.setText(Messages.XPathQueryDesigner_AddAsFieldAbsoluteItem);
        addNodeAsFieldItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object sel = ((IStructuredSelection)XPathQueryDesigner.this.treeViewer.getSelection()).getFirstElement();
                if (sel instanceof XMLNode) {
                    String xPathExpression = XPathQueryDesigner.this.documentManager.getXPathExpression(null, (XMLNode)sel);
                    ((XMLNode)sel).setXPathExpression(xPathExpression);
                    XPathQueryDesigner.this.createField((ANode)((XMLNode)sel));
                }
            }
        });
        new MenuItem(contextMenu, 2);
        MenuItem expandAllItem = new MenuItem(contextMenu, 8);
        expandAllItem.setText(Messages.XPathQueryDesigner_ExpandAllItem);
        expandAllItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XPathQueryDesigner.this.treeViewer.expandAll();
            }
        });
        MenuItem collapseAllItem = new MenuItem(contextMenu, 8);
        collapseAllItem.setText(Messages.XPathQueryDesigner_CollapseAllItem);
        collapseAllItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XPathQueryDesigner.this.treeViewer.collapseAll();
            }
        });
        MenuItem resetRefreshDocItem = new MenuItem(contextMenu, 8);
        resetRefreshDocItem.setText(Messages.XPathQueryDesigner_RefreshItem);
        resetRefreshDocItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XPathQueryDesigner.this.refreshTreeViewerContent(XPathQueryDesigner.this.container.getDataAdapter());
            }
        });
        this.treeViewer.getTree().setMenu(contextMenu);
        contextMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                Object selEl = ((IStructuredSelection)XPathQueryDesigner.this.treeViewer.getSelection()).getFirstElement();
                if (selEl instanceof XMLNode) {
                    addNodeAsFieldItem1.setEnabled(true);
                    addNodeAsFieldItem2.setEnabled(true);
                    if (selEl instanceof XMLAttributeNode) {
                        setRecordNodeItem.setEnabled(false);
                        setDocumentRootItem.setEnabled(false);
                    } else {
                        setRecordNodeItem.setEnabled(true);
                        setDocumentRootItem.setEnabled(true);
                    }
                } else {
                    setRecordNodeItem.setEnabled(false);
                    setDocumentRootItem.setEnabled(false);
                    addNodeAsFieldItem1.setEnabled(false);
                    addNodeAsFieldItem2.setEnabled(false);
                }
            }

            public void menuHidden(MenuEvent e) {
            }
        });
    }

    protected void refreshTreeViewerContent(DataAdapterDescriptor da) {
        if (!this.isRefreshing) {
            this.isRefreshing = true;
            this.container.getQueryStatus().showInfo("");
            this.treeViewer.setInput((Object)XMLTreeCustomStatus.LOADING_XML);
            if (da != null && da.getDataAdapter() instanceof XmlDataAdapter) {
                XmlDataAdapter xda = (XmlDataAdapter)da.getDataAdapter();
                boolean namespaceAware = XMLUtils.isNamespaceAware((XmlDataAdapter)xda, (JasperDesign)this.jConfig.getJasperDesign());
                DataFile df = xda.getDataFile();
                this.xmlLoaderJob.setDataFile(df);
                this.xmlLoaderJob.setNamespaceAware(namespaceAware);
                this.xmlLoaderJob.schedule();
            } else {
                this.treeViewer.getTree().removeAll();
                this.treeViewer.setInput((Object)XMLTreeCustomStatus.FILE_NOT_FOUND);
                this.isRefreshing = false;
            }
        }
    }

    public void dispose() {
        if (this.decorateJob != null) {
            this.decorateJob.cancel();
            this.decorateJob = null;
        }
        if (this.xmlLoaderJob != null) {
            this.xmlLoaderJob.cancel();
            this.xmlLoaderJob = null;
        }
        super.dispose();
    }

    public String getContextHelpId() {
        return ContextHelpIDs.WIZARD_QUERY_DIALOG;
    }

    private final class DecorateTreeViewerJob
    extends UIJob {
        public DecorateTreeViewerJob() {
            super(Messages.XPathQueryDesigner_RefreshJobTitle);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (XPathQueryDesigner.this.control != null && !XPathQueryDesigner.this.control.isDisposed()) {
                monitor.beginTask(Messages.XPathQueryDesigner_RefreshTaskTitle, -1);
                String query = XPathQueryDesigner.this.queryTextArea.getText();
                XPathQueryDesigner.this.treeLabelProvider.setSelectedNodes(XPathQueryDesigner.this.documentManager.getSelectableNodes(query));
                XPathQueryDesigner.this.treeViewer.refresh();
                monitor.done();
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
    }

    private final class XMLLoaderJob
    extends Job {
        private DataFile dataFile;
        private boolean namespaceAware;

        public XMLLoaderJob() {
            super(Messages.XPathQueryDesigner_XmlLoaderJobName);
            this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    IStatus result = event.getResult();
                    if (Status.OK_STATUS.equals(result)) {
                        UIUtils.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (XPathQueryDesigner.this.treeViewer != null && !XPathQueryDesigner.this.treeViewer.getTree().isDisposed()) {
                                    XPathQueryDesigner.this.treeViewer.setInput((Object)XPathQueryDesigner.this.documentManager.getXMLDocumentModel());
                                    XPathQueryDesigner.this.treeViewer.expandToLevel(2);
                                    XPathQueryDesigner.this.decorateTreeUsingQueryText();
                                }
                                XPathQueryDesigner.this.isRefreshing = false;
                            }
                        });
                    }
                }
            });
        }

        public void setNamespaceAware(boolean namespaceAware) {
            this.namespaceAware = namespaceAware;
        }

        public void setDataFile(DataFile dataFile) {
            this.dataFile = dataFile;
        }

        protected IStatus run(IProgressMonitor monitor) {
            block8: {
                DataFileStream ins = null;
                try {
                    if (this.dataFile != null) {
                        Document doc = null;
                        HashMap parameters = XPathQueryDesigner.this.jConfig.getJRParameters();
                        if (parameters == null) {
                            parameters = new HashMap();
                        }
                        ins = DataFileUtils.instance((ParameterContributorContext)new ParameterContributorContext((JasperReportsContext)XPathQueryDesigner.this.jConfig, null, null)).getDataStream(this.dataFile, parameters);
                        doc = JRXmlUtils.parse((InputStream)ins, (boolean)this.namespaceAware);
                        XPathQueryDesigner.this.documentManager.setDocument(doc);
                        XPathQueryDesigner.this.documentManager.setJasperConfiguration(XPathQueryDesigner.this.container.getjConfig());
                        IStatus iStatus = Status.OK_STATUS;
                        IOUtils.closeQuietly((InputStream)ins);
                        return iStatus;
                    }
                }
                catch (Exception e) {
                    UIUtils.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (XPathQueryDesigner.this.treeViewer != null && !XPathQueryDesigner.this.treeViewer.getTree().isDisposed()) {
                                XPathQueryDesigner.this.container.getQueryStatus().showError((Throwable)e);
                                XPathQueryDesigner.this.treeViewer.getTree().removeAll();
                                XPathQueryDesigner.this.treeViewer.setInput((Object)XMLTreeCustomStatus.ERROR_LOADING_XML);
                            }
                            XPathQueryDesigner.this.isRefreshing = false;
                        }
                    });
                    break block8;
                }
                finally {
                    IOUtils.closeQuietly(ins);
                }
                IOUtils.closeQuietly(ins);
            }
            return Status.CANCEL_STATUS;
        }
    }
}

