/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.xml;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.adapter.IDataAdapterCreator;
import com.jaspersoft.studio.data.xml.XMLDataAdapterDescriptor;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.xml.XmlDataAdapterImpl;
import net.sf.jasperreports.eclipse.util.DataFileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLCreator
implements IDataAdapterCreator {
    public DataAdapterDescriptor buildFromXML(Document docXML) {
        XmlDataAdapterImpl result = new XmlDataAdapterImpl();
        NamedNodeMap rootAttributes = docXML.getChildNodes().item(0).getAttributes();
        String connectionName = rootAttributes.getNamedItem("name").getTextContent();
        result.setName(connectionName);
        NodeList children = docXML.getChildNodes().item(0).getChildNodes();
        String localeVariant = null;
        String localeLanguage = null;
        String localeCountry = null;
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node.getNodeName().equals("connectionParameter")) {
                String paramName = node.getAttributes().getNamedItem("name").getTextContent();
                String textContent = node.getTextContent();
                if (paramName.equals("NumberPattern")) {
                    result.setNumberPattern(textContent);
                }
                if (paramName.equals("DatePattern")) {
                    result.setDatePattern(textContent);
                }
                if (paramName.equals("UseConnection")) {
                    result.setUseConnection(textContent.equals("true"));
                }
                if (paramName.equals("SelectExpression")) {
                    result.setSelectExpression(textContent);
                }
                if (paramName.equals("Filename")) {
                    result.setDataFile(DataFileUtils.getDataFile((String)textContent));
                }
                if (paramName.equals("Locale_variant")) {
                    localeVariant = textContent;
                }
                if (paramName.equals("Locale_country")) {
                    localeCountry = textContent;
                }
                if (paramName.equals("Locale_language")) {
                    localeLanguage = textContent;
                }
                if (paramName.equals("timeZone")) {
                    result.setTimeZone(TimeZone.getTimeZone(textContent));
                }
            }
            ++i;
        }
        if (localeCountry != null && localeLanguage != null) {
            Locale locale = new Locale(localeLanguage, localeCountry, localeVariant);
            result.setLocale(locale);
        }
        XMLDataAdapterDescriptor desc = new XMLDataAdapterDescriptor();
        desc.setDataAdapter((DataAdapter)result);
        return desc;
    }

    public String getID() {
        return "com.jaspersoft.ireport.designer.connection.JRXMLDataSourceConnection";
    }
}

