/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.xmla;

import com.jaspersoft.studio.data.xmla.DataSourceTreeElement;
import com.jaspersoft.studio.data.xmla.MetadataDiscover;
import java.util.Iterator;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class DataSourceElement
implements DataSourceTreeElement {
    private String dataSourceName;
    private String dataSourceDescription;
    private String URL;
    private String providerName;
    private String providerType;
    private String authenticationMode;
    private MetadataDiscover parent;

    public DataSourceElement(MetadataDiscover svm, SOAPElement rowNode) {
        this.parent = svm;
        this.dataSourceName = this.getRowValue(rowNode, "DataSourceName");
        this.dataSourceDescription = this.getRowValue(rowNode, "DataSourceDescription");
        this.URL = this.getRowValue(rowNode, "URL");
        this.providerName = this.getRowValue(rowNode, "ProviderName");
        this.providerType = this.getRowValue(rowNode, "ProviderType");
        this.authenticationMode = this.getRowValue(rowNode, "AuthenticationMode");
    }

    private String getRowValue(SOAPElement cellElement, String tagName) {
        try {
            Iterator dimensionNameNode = cellElement.getChildElements(this.parent.getSoapFactory().createName(tagName, "", "urn:schemas-microsoft-com:xml-analysis:rowset"));
            String value = null;
            if (dimensionNameNode.hasNext()) {
                SOAPElement valueElement = (SOAPElement)dimensionNameNode.next();
                value = valueElement.getValue();
                return value;
            }
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public DataSourceTreeElement[] getChildren() {
        return this.parent.getCatalogList(this.dataSourceName);
    }

    @Override
    public String toString() {
        if (this.dataSourceName == null) {
            return "not initialized";
        }
        return this.dataSourceName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getDatasourceDescription() {
        return this.dataSourceDescription;
    }

    public String getURL() {
        return this.URL;
    }

    public String getProivderName() {
        return this.providerName;
    }

    public String getProviderType() {
        return this.providerType;
    }

    public String getAuthenticationMode() {
        return this.authenticationMode;
    }

    @Override
    public String getDataSourceInfo() {
        return this.dataSourceName;
    }
}

