/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.xmla;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.ADataAdapterComposite;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.messages.Messages;
import com.jaspersoft.studio.data.xmla.AuthenticationDialog;
import com.jaspersoft.studio.data.xmla.CatalogElement;
import com.jaspersoft.studio.data.xmla.CubeElement;
import com.jaspersoft.studio.data.xmla.DataSourceTreeElement;
import com.jaspersoft.studio.data.xmla.MetadataDiscover;
import com.jaspersoft.studio.data.xmla.XmlaDataAdapterDescriptor;
import com.jaspersoft.studio.swt.widgets.WSecretText;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.text.MessageFormat;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.xmla.XmlaDataAdapter;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.util.SecretsUtil;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class XmlaDataAdapterComposite
extends ADataAdapterComposite {
    private Text xmlaUri;
    private Text textUsername;
    private WSecretText textPassword;
    private Combo cube;
    private Combo catalog;
    private Combo datasource;
    private DataSourceTreeElement[] dstes;
    private DataSourceTreeElement[] catalogs;
    private XmlaDataAdapter adapter;

    public XmlaDataAdapterComposite(Composite parent, int style, JasperReportsContext jrContext) {
        super(parent, style, jrContext);
        this.setLayout((Layout)new GridLayout(3, false));
        Label lblNewLabel = new Label((Composite)this, 0);
        lblNewLabel.setText(Messages.XmlaDataAdapterComposite_0);
        this.xmlaUri = new Text((Composite)this, 2048);
        this.xmlaUri.setLayoutData((Object)new GridData(768));
        Button bGetMetadata = new Button((Composite)this, 8);
        bGetMetadata.setText(Messages.XmlaDataAdapterComposite_1);
        new Label((Composite)this, 0).setText(Messages.XmlaDataAdapterComposite_2);
        this.datasource = new Combo((Composite)this, 2056);
        this.datasource.setItems(new String[0]);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.datasource.setLayoutData((Object)gd);
        new Label((Composite)this, 0).setText(Messages.XmlaDataAdapterComposite_3);
        this.catalog = new Combo((Composite)this, 2056);
        this.catalog.setItems(new String[0]);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.catalog.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        new Label((Composite)this, 258).setLayoutData((Object)gd);
        new Label((Composite)this, 0).setText(Messages.XmlaDataAdapterComposite_4);
        this.cube = new Combo((Composite)this, 2056);
        this.cube.setItems(new String[0]);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.cube.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        new Label((Composite)this, 258).setLayoutData((Object)gd);
        Label lblUsername = new Label((Composite)this, 0);
        lblUsername.setText(Messages.JDBCDataAdapterComposite_username);
        this.textUsername = new Text((Composite)this, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.textUsername.setLayoutData((Object)gd);
        Label lblPassword = new Label((Composite)this, 0);
        lblPassword.setText(Messages.JDBCDataAdapterComposite_password);
        this.textPassword = new WSecretText((Composite)this, 0x400800);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.textPassword.setLayoutData((Object)gd);
        bGetMetadata.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthenticationDialog dialog;
                ReturnResponse response;
                boolean loginSuccesfull;
                String url = XmlaDataAdapterComposite.this.xmlaUri.getText();
                String username = XmlaDataAdapterComposite.this.textUsername.getText();
                String password = XmlaDataAdapterComposite.this.textPassword.getText();
                boolean firstConnectionSuccessfull = false;
                if (!username.isEmpty() && !password.isEmpty() && (loginSuccesfull = (response = XmlaDataAdapterComposite.this.validateUsernamePassword(url, username, password)).isSuccessfull())) {
                    try {
                        MetadataDiscover discover = new MetadataDiscover(url, username, password);
                        XmlaDataAdapterComposite.this.handleMetaDataChanged(discover);
                        firstConnectionSuccessfull = true;
                        UIUtils.showInformation((String)Messages.XmlaDataAdapterComposite_successTitle, (String)Messages.XmlaDataAdapterComposite_successText);
                    }
                    catch (Exception exception) {}
                }
                if (!firstConnectionSuccessfull && (dialog = new AuthenticationDialog(XmlaDataAdapterComposite.this.getShell(), url, XmlaDataAdapterComposite.this.textUsername.getText(), XmlaDataAdapterComposite.this.getPassword())).open() == 0) {
                    ReturnResponse response2 = XmlaDataAdapterComposite.this.validateUsernamePassword(url, dialog.getUsername(), dialog.getPassword());
                    boolean loginSuccesfull2 = response2.isSuccessfull();
                    if (loginSuccesfull2) {
                        try {
                            MetadataDiscover discover = new MetadataDiscover(url, dialog.getUsername(), dialog.getPassword());
                            XmlaDataAdapterComposite.this.handleMetaDataChanged(discover);
                            XmlaDataAdapterComposite.this.textUsername.setText(dialog.getUsername());
                            XmlaDataAdapterComposite.this.textPassword.setText(dialog.getPassword());
                            UIUtils.showInformation((String)Messages.XmlaDataAdapterComposite_successTitle, (String)Messages.XmlaDataAdapterComposite_successText);
                        }
                        catch (Exception e1) {
                            String message = String.valueOf(Messages.XmlaDataAdapterComposite_failedText) + "\n" + MessageFormat.format(Messages.XmlaDataAdapterComposite_errorCode, e1.getMessage());
                            UIUtils.showWarning((String)Messages.XmlaDataAdapterComposite_failedTitle, (String)message);
                            JaspersoftStudioPlugin.getInstance().logError(message, (Throwable)e1);
                            e1.printStackTrace();
                        }
                    } else {
                        String message = response2.isException() ? String.valueOf(Messages.XmlaDataAdapterComposite_failedText) + "\n" + MessageFormat.format(Messages.XmlaDataAdapterComposite_errorException, response2.getException().getMessage()) : String.valueOf(Messages.XmlaDataAdapterComposite_failedText) + "\n" + MessageFormat.format(Messages.XmlaDataAdapterComposite_errorCode, response2.getReturnCode());
                        UIUtils.showWarning((String)Messages.XmlaDataAdapterComposite_failedTitle, (String)message);
                    }
                }
            }
        });
        this.datasource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XmlaDataAdapterComposite.this.handleDatasourceChanged();
            }
        });
        this.catalog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XmlaDataAdapterComposite.this.handleCatalogChanged();
            }
        });
    }

    protected void bindWidgets(DataAdapter dataAdapter) {
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.xmlaUri, (int)24), PojoObservables.observeValue((Object)dataAdapter, (String)"xmlaUrl"));
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this.datasource), PojoObservables.observeValue((Object)dataAdapter, (String)"datasource"));
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this.catalog), PojoObservables.observeValue((Object)dataAdapter, (String)"catalog"));
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this.cube), PojoObservables.observeValue((Object)dataAdapter, (String)"cube"));
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.textUsername, (int)24), PojoObservables.observeValue((Object)dataAdapter, (String)"username"));
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.textPassword, (int)24), PojoObservables.observeValue((Object)dataAdapter, (String)"password"));
    }

    public DataAdapterDescriptor getDataAdapter() {
        if (this.dataAdapterDesc == null) {
            this.dataAdapterDesc = new XmlaDataAdapterDescriptor();
        }
        XmlaDataAdapter dataAdapter = (XmlaDataAdapter)this.dataAdapterDesc.getDataAdapter();
        dataAdapter.setXmlaUrl(this.xmlaUri.getText());
        dataAdapter.setDatasource(this.datasource.getText());
        dataAdapter.setCatalog(this.catalog.getText());
        dataAdapter.setCube(this.cube.getText());
        dataAdapter.setUsername(this.textUsername.getText());
        if (!this.textPassword.isWidgetConfigured()) {
            this.textPassword.loadSecret("net.sf.jasperreports.data.adapter", this.textPassword.getText());
        } else {
            dataAdapter.setPassword(this.textPassword.getText());
        }
        return this.dataAdapterDesc;
    }

    public void setDataAdapter(DataAdapterDescriptor dataAdapterDesc) {
        this.removeDirtyListenersToContext();
        this.adapter = (XmlaDataAdapter)dataAdapterDesc.getDataAdapter();
        if (this.dstes == null) {
            this.datasource.setItems(new String[]{Misc.nvl((String)this.adapter.getDatasource())});
            this.datasource.select(0);
            this.catalog.setItems(new String[]{Misc.nvl((String)this.adapter.getCatalog())});
            this.catalog.select(0);
            this.cube.setItems(new String[]{Misc.nvl((String)this.adapter.getCube())});
            this.cube.select(0);
        } else {
            this.handleDatasourceChanged();
        }
        super.setDataAdapter(dataAdapterDesc);
        this.addDirtyListenersToContext();
    }

    private int getIndex(String[] array, String value, int notFoundValue) {
        int i = 0;
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.equals(value)) {
                return i;
            }
            ++i;
            ++n2;
        }
        return notFoundValue;
    }

    protected void handleMetaDataChanged(MetadataDiscover discover) {
        this.dstes = discover.getDatasources();
        if (this.dstes == null || this.dstes.length == 0) {
            return;
        }
        String[] dsources = new String[this.dstes.length];
        int i = 0;
        while (i < this.dstes.length) {
            dsources[i] = this.dstes[i].getDataSourceInfo();
            ++i;
        }
        int selectionIndex = 0;
        if (this.adapter != null) {
            selectionIndex = this.getIndex(dsources, this.adapter.getDatasource(), 0);
        }
        this.datasource.setItems(dsources);
        this.datasource.select(selectionIndex);
        this.handleDatasourceChanged();
    }

    protected void handleDatasourceChanged() {
        if (this.dstes == null) {
            return;
        }
        int ind = this.datasource.getSelectionIndex();
        this.catalogs = this.dstes[ind].getChildren();
        if (this.catalogs == null || this.catalogs.length == 0) {
            return;
        }
        String[] scat = new String[this.catalogs.length];
        int i = 0;
        while (i < this.catalogs.length) {
            scat[i] = ((CatalogElement)this.catalogs[i]).toString();
            ++i;
        }
        int selectionIndex = 0;
        if (this.adapter != null) {
            selectionIndex = this.getIndex(scat, this.adapter.getCatalog(), 0);
        }
        this.catalog.setItems(scat);
        this.catalog.select(selectionIndex);
        this.handleCatalogChanged();
    }

    protected void handleCatalogChanged() {
        if (this.dstes == null) {
            return;
        }
        int ind = this.catalog.getSelectionIndex();
        DataSourceTreeElement[] cubes = this.catalogs[ind].getChildren();
        if (cubes == null || cubes.length == 0) {
            return;
        }
        String[] scubes = new String[cubes.length];
        int i = 0;
        while (i < cubes.length) {
            scubes[i] = ((CubeElement)cubes[i]).toString();
            ++i;
        }
        int selectionIndex = 0;
        if (this.adapter != null) {
            selectionIndex = this.getIndex(scubes, this.adapter.getCube(), 0);
        }
        this.cube.setItems(scubes);
        this.cube.select(selectionIndex);
    }

    private String getPassword() {
        SecretsUtil sInstance = SecretsUtil.getInstance((JasperReportsContext)this.getJrContext());
        String secret = sInstance.getSecret("net.sf.jasperreports.data.adapter", this.textPassword.getText());
        return secret;
    }

    private ReturnResponse validateUsernamePassword(String url, final String username, final String password) {
        try {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password.toCharArray());
                }
            });
            URL endpoint = new URL(url);
            HttpURLConnection urlConnection = (HttpURLConnection)endpoint.openConnection();
            int code = urlConnection.getResponseCode();
            ReturnResponse response = new ReturnResponse(code == 405 || code == 500, code);
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnResponse(e);
        }
    }

    public String getHelpContextId() {
        return "com.jaspersoft.studio.doc.".concat("adapter_xmla");
    }

    public void performAdditionalUpdates() {
        if (JaspersoftStudioPlugin.shouldUseSecureStorage()) {
            this.textPassword.persistSecret();
            XmlaDataAdapter dataAdapter = (XmlaDataAdapter)this.dataAdapterDesc.getDataAdapter();
            dataAdapter.setPassword(this.textPassword.getUUIDKey());
        }
    }

    private class ReturnResponse {
        private int returnCode;
        private boolean successful;
        private Exception ex;

        public ReturnResponse(boolean successfull, int returnCode) {
            this.successful = successfull;
            this.returnCode = returnCode;
            this.ex = null;
        }

        public ReturnResponse(Exception ex) {
            this.successful = false;
            this.returnCode = -1;
            this.ex = ex;
        }

        public boolean isException() {
            return this.ex != null;
        }

        public Exception getException() {
            return this.ex;
        }

        public boolean isSuccessfull() {
            return this.successful;
        }

        public int getReturnCode() {
            return this.returnCode;
        }
    }
}

