/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ws;

import com.jaspersoft.ireport.jasperserver.ws.FileContent;
import com.jaspersoft.ireport.jasperserver.ws.JServer;
import com.jaspersoft.ireport.jasperserver.ws.ManagementService;
import com.jaspersoft.ireport.jasperserver.ws.ManagementServiceServiceLocator;
import com.jaspersoft.ireport.jasperserver.ws.RequestAttachment;
import com.jaspersoft.ireport.jasperserver.ws.ResourceConfigurationProvider;
import com.jaspersoft.ireport.jasperserver.ws.permissions.PermissionsManagement;
import com.jaspersoft.ireport.jasperserver.ws.permissions.PermissionsManagementServiceLocator;
import com.jaspersoft.ireport.jasperserver.ws.scheduler.ReportScheduler;
import com.jaspersoft.ireport.jasperserver.ws.scheduler.ReportSchedulerServiceLocator;
import com.jaspersoft.ireport.jasperserver.ws.userandroles.UserAndRoleManagement;
import com.jaspersoft.ireport.jasperserver.ws.userandroles.UserAndRoleManagementServiceLocator;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Argument;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ListItem;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.OperationResult;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.ws.xml.Marshaller;
import com.jaspersoft.jasperserver.ws.xml.Unmarshaller;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.util.SecretsUtil;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.client.Stub;
import org.apache.axis.transport.http.HTTPConstants;
import org.eclipse.osgi.util.NLS;

public class WSClient {
    public static final String AXIS_CONFIGURATION_RESOURCE = "/com/jaspersoft/ireport/jasperserver/ws/client-config.wsdd";
    private JServer server = null;
    private String webservicesUri = null;
    private ManagementService managementService = null;
    private UserAndRoleManagement userAndRoleManagementService = null;
    private PermissionsManagement permissionsManagement = null;
    private ReportScheduler reportScheduler = null;
    private Unmarshaller unmarshaller = new Unmarshaller();
    private Marshaller marshaller = new Marshaller();
    private String cachedServerVersion;
    private SecretsUtil secretsUtil;

    public WSClient(JServer server) throws Exception {
        URL url;
        this.server = server;
        try {
            url = new URL(server.getUrl());
        }
        catch (MalformedURLException e1) {
            throw new Exception(e1);
        }
        this.setWebservicesUri(url.toString());
    }

    public List<ResourceDescriptor> listDatasources() throws Exception {
        Request req = new Request();
        req.setOperationName("list");
        req.setResourceDescriptor(null);
        req.setLocale(this.getServer().getLocale());
        req.getArguments().add(new Argument("LIST_DATASOURCES", "true"));
        StringWriter xmlStringWriter = new StringWriter();
        Marshaller.marshal((Object)req, (StringWriter)xmlStringWriter);
        return this.list(xmlStringWriter.toString());
    }

    public List<ResourceDescriptor> list(ResourceDescriptor descriptor) throws Exception {
        Request req = new Request();
        req.setOperationName("list");
        req.setResourceDescriptor(descriptor);
        req.setLocale(this.getServer().getLocale());
        StringWriter xmlStringWriter = new StringWriter();
        Marshaller.marshal((Object)req, (StringWriter)xmlStringWriter);
        return this.list(xmlStringWriter.toString());
    }

    public String getVersion() throws Exception {
        if (this.cachedServerVersion != null) {
            return this.cachedServerVersion;
        }
        Request req = new Request();
        req.setOperationName("list");
        req.setResourceDescriptor(null);
        req.setLocale(this.getServer().getLocale());
        try {
            ManagementService ms = this.getManagementService();
            String reqXml = this.marshaller.marshal(req);
            String result = ms.list(reqXml);
            OperationResult or = (OperationResult)this.unmarshal(result);
            if (or.getReturnCode() != 0) {
                throw new Exception(this.composeErrorMessage(or));
            }
            this.cachedServerVersion = or.getVersion();
            return this.cachedServerVersion;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public List<ResourceDescriptor> list(String xmlRequest) throws Exception {
        try {
            String result = this.getManagementService().list(xmlRequest);
            OperationResult or = (OperationResult)this.unmarshal(result);
            if (or.getReturnCode() != 0) {
                throw new Exception(this.composeErrorMessage(or));
            }
            return or.getResourceDescriptors();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public void delete(ResourceDescriptor descriptor) throws Exception {
        this.delete(descriptor, null);
    }

    public void delete(ResourceDescriptor descriptor, String reportUnitUri) throws Exception {
        try {
            String result;
            OperationResult or;
            Request req = new Request();
            req.setOperationName("delete");
            req.setResourceDescriptor(descriptor);
            req.setLocale(this.getServer().getLocale());
            if (reportUnitUri != null && reportUnitUri.length() > 0) {
                req.getArguments().add(new Argument("MODIFY_REPORTUNIT_URI", reportUnitUri));
            }
            if ((or = (OperationResult)this.unmarshal(result = this.getManagementService().delete(this.marshaller.marshal(req)))).getReturnCode() != 0) {
                throw new Exception(this.composeErrorMessage(or));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public ResourceDescriptor get(ResourceDescriptor descriptor, File outputFile) throws Exception {
        return this.get(descriptor, outputFile, null);
    }

    private String composeErrorMessage(OperationResult or) {
        if (or.getMessage() != null) {
            return NLS.bind((String)Messages.WSClient_errorWithMessage, (Object[])new Object[]{or.getReturnCode(), or.getMessage()});
        }
        return NLS.bind((String)Messages.WSClient_errorWithoutMessage, (Object)or.getReturnCode());
    }

    public ResourceDescriptor get(ResourceDescriptor descriptor, File outputFile, List<Argument> args) throws Exception {
        ResourceDescriptor rd = null;
        InputStream is = null;
        OutputStream os = null;
        try {
            try {
                String result;
                OperationResult or;
                Request req = new Request();
                req.setOperationName("get");
                req.setResourceDescriptor(descriptor);
                req.setLocale(this.getServer().getLocale());
                if (args != null) {
                    int i = 0;
                    while (i < args.size()) {
                        Argument arg = args.get(i);
                        req.getArguments().add(arg);
                        ++i;
                    }
                }
                if (outputFile == null) {
                    req.getArguments().add(new Argument("NO_ATTACHMENT", null));
                }
                if ((or = (OperationResult)this.unmarshal(result = this.getManagementService().get(this.marshaller.marshal(req)))).getReturnCode() != 0) {
                    throw new Exception(this.composeErrorMessage(or));
                }
                Object[] resAtts = ((Stub)this.getManagementService()).getAttachments();
                if (resAtts != null && resAtts.length > 0 && outputFile != null) {
                    is = ((AttachmentPart)resAtts[0]).getDataHandler().getInputStream();
                    byte[] buffer = new byte[1024];
                    os = new FileOutputStream(outputFile);
                    int bCount = 0;
                    while ((bCount = is.read(buffer)) > 0) {
                        os.write(buffer, 0, bCount);
                    }
                } else if (outputFile != null) {
                    throw new Exception("Attachment not present!");
                }
                rd = (ResourceDescriptor)or.getResourceDescriptors().get(0);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        return rd;
    }

    public Map<String, FileContent> runReport(ResourceDescriptor descriptor, Map<String, Object> parameters, List<Argument> args) throws Exception {
        try {
            Request req = new Request();
            req.setOperationName("runReport");
            req.setLocale(this.getServer().getLocale());
            ResourceDescriptor newRUDescriptor = new ResourceDescriptor();
            newRUDescriptor.setUriString(descriptor.getUriString());
            Iterator<String> i = parameters.keySet().iterator();
            while (i.hasNext()) {
                String key = i.next();
                Object value = parameters.get(key);
                if (value instanceof Collection) {
                    Iterator cIter = ((Collection)value).iterator();
                    while (cIter.hasNext()) {
                        String item = "" + cIter.next();
                        ListItem l = new ListItem(String.valueOf(key), (Object)item);
                        l.setIsListItem(true);
                        newRUDescriptor.getParameters().add(l);
                    }
                    continue;
                }
                newRUDescriptor.getParameters().add(new ListItem(String.valueOf(key), parameters.get(key)));
            }
            req.setResourceDescriptor(newRUDescriptor);
            req.getArguments().addAll(args);
            String result = this.getManagementService().runReport(this.marshaller.marshal(req));
            OperationResult or = (OperationResult)this.unmarshal(result);
            if (or.getReturnCode() != 0) {
                throw new Exception(this.composeErrorMessage(or));
            }
            HashMap<String, FileContent> results = new HashMap<String, FileContent>();
            Object[] resAtts = ((Stub)this.getManagementService()).getAttachments();
            boolean attachFound = false;
            int i2 = 0;
            while (resAtts != null && i2 < resAtts.length) {
                attachFound = true;
                DataHandler actualDH = ((AttachmentPart)resAtts[i2]).getDataHandler();
                String name = actualDH.getName();
                String contentId = ((AttachmentPart)resAtts[i2]).getContentId();
                if (name == null) {
                    name = "attachment-" + i2;
                }
                if (contentId == null) {
                    contentId = "attachment-" + i2;
                }
                InputStream is = actualDH.getInputStream();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] data = new byte[1000];
                try {
                    int bytesRead;
                    while ((bytesRead = is.read(data)) != -1) {
                        bos.write(data, 0, bytesRead);
                    }
                    data = bos.toByteArray();
                }
                finally {
                    FileUtils.closeStream((Closeable)is);
                    FileUtils.closeStream((Closeable)bos);
                }
                String contentType = actualDH.getContentType();
                FileContent content = new FileContent();
                content.setData(data);
                content.setMimeType(contentType);
                content.setName(name);
                results.put(contentId, content);
                ++i2;
            }
            if (!attachFound) {
                throw new Exception("Attachment not present!");
            }
            return results;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public ResourceDescriptor addOrModifyResource(ResourceDescriptor descriptor, File inputFile) throws Exception {
        return this.modifyReportUnitResource(null, descriptor, inputFile);
    }

    public ResourceDescriptor putResource(ResourceDescriptor descriptor, RequestAttachment[] attachments) throws Exception {
        return this.putReportUnitResource(null, descriptor, attachments);
    }

    public JServer getServer() {
        return this.server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }

    public String getUsername() {
        return this.getServer().getUsername();
    }

    public String getPassword() {
        if (this.secretsUtil == null) {
            this.secretsUtil = SecretsUtil.getInstance((JasperReportsContext)this.getJrContext());
        }
        return this.secretsUtil.getSecret("com.jaspersoft.studio.jrserver", this.getServer().getPassword());
    }

    protected JasperReportsContext getJrContext() {
        if (JaspersoftStudioPlugin.getInstance() == null) {
            return DefaultJasperReportsContext.getInstance();
        }
        return JasperReportsConfiguration.getDefaultInstance();
    }

    public int getTimeout() {
        return Math.max(600000, this.getServer().getTimeout());
    }

    public boolean isChuncked() {
        return this.getServer().isChunked();
    }

    public ResourceDescriptor modifyReportUnitResource(String reportUnitUri, ResourceDescriptor descriptor, File inputFile) throws Exception {
        RequestAttachment[] attachments;
        if (inputFile == null) {
            attachments = new RequestAttachment[]{};
        } else {
            FileDataSource fileDataSource = new FileDataSource(inputFile);
            RequestAttachment attachment = new RequestAttachment((DataSource)fileDataSource);
            attachments = new RequestAttachment[]{attachment};
        }
        return this.putReportUnitResource(reportUnitUri, descriptor, attachments);
    }

    public ResourceDescriptor putReportUnitResource(String reportUnitUri, ResourceDescriptor descriptor, RequestAttachment[] attachments) throws Exception {
        Request req = new Request();
        req.setOperationName("put");
        req.setLocale(this.getServer().getLocale());
        if (reportUnitUri != null && reportUnitUri.length() > 0) {
            req.getArguments().add(new Argument("MODIFY_REPORTUNIT_URI", reportUnitUri));
        }
        ManagementService ms = this.getManagementService();
        if (attachments != null && attachments.length > 0) {
            descriptor.setHasData(true);
            if (this.getServer().isMime()) {
                ((Stub)ms)._setProperty("attachment_encapsulation_format", (Object)"axis.attachment.style.mime");
            } else {
                ((Stub)ms)._setProperty("attachment_encapsulation_format", (Object)"axis.attachment.style.dime");
            }
            int i = 0;
            while (i < attachments.length) {
                RequestAttachment attachment = attachments[i];
                DataHandler attachmentHandler = new DataHandler(attachment.getDataSource());
                AttachmentPart attachmentPart = new AttachmentPart(attachmentHandler);
                if (attachment.getContentID() != null) {
                    attachmentPart.setContentId(attachment.getContentID());
                }
                ((Stub)ms).addAttachment((Object)attachmentPart);
                ++i;
            }
        }
        req.setResourceDescriptor(descriptor);
        String result = ms.put(this.marshaller.marshal(req));
        OperationResult or = (OperationResult)this.unmarshal(result);
        if (or.getReturnCode() != 0) {
            throw new Exception(this.composeErrorMessage(or));
        }
        return (ResourceDescriptor)or.getResourceDescriptors().get(0);
    }

    public void move(ResourceDescriptor resource, String destinationFolderURI) throws Exception {
        try {
            Request req = new Request();
            req.setOperationName("move");
            req.setResourceDescriptor(resource);
            req.setLocale(this.getServer().getLocale());
            req.getArguments().add(new Argument("DESTINATION_URI", destinationFolderURI));
            String result = this.getManagementService().move(this.marshaller.marshal(req));
            OperationResult or = (OperationResult)this.unmarshal(result);
            if (or.getReturnCode() != 0) {
                throw new Exception(String.valueOf(or.getReturnCode()) + " - " + or.getMessage());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public ResourceDescriptor copy(ResourceDescriptor resource, String destinationFolderURI) throws Exception {
        try {
            Request req = new Request();
            req.setOperationName("copy");
            req.setResourceDescriptor(resource);
            req.setLocale(this.getServer().getLocale());
            req.getArguments().add(new Argument("DESTINATION_URI", destinationFolderURI));
            String result = this.getManagementService().copy(this.marshaller.marshal(req));
            OperationResult or = (OperationResult)this.unmarshal(result);
            if (or.getReturnCode() != 0) {
                throw new Exception(String.valueOf(or.getReturnCode()) + " - " + or.getMessage());
            }
            List resultDescriptors = or.getResourceDescriptors();
            ResourceDescriptor copyDescriptor = resultDescriptors == null || resultDescriptors.isEmpty() ? null : (ResourceDescriptor)resultDescriptors.get(0);
            return copyDescriptor;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public String getWebservicesUri() {
        return this.webservicesUri;
    }

    public void setWebservicesUri(String webservicesUri) {
        this.webservicesUri = webservicesUri;
    }

    public ManagementService getManagementService() throws Exception {
        if (this.managementService == null) {
            ManagementServiceServiceLocator rsl = new ManagementServiceServiceLocator(this.getEngineConfiguration());
            this.managementService = rsl.getrepository(new URL(this.getWebservicesUri()));
            ((Stub)this.managementService).setUsername(this.getUsername());
            ((Stub)this.managementService).setPassword(this.getPassword());
            ((Stub)this.managementService).setMaintainSession(true);
            ((Stub)this.managementService).setTimeout(this.getTimeout());
            Hashtable<String, Boolean> headers = (Hashtable<String, Boolean>)((Stub)this.managementService)._getProperty("HTTP-Request-Headers");
            if (headers == null) {
                headers = new Hashtable<String, Boolean>();
            }
            headers.put(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED, this.isChuncked() ? Boolean.TRUE : Boolean.FALSE);
            ((Stub)this.managementService)._setProperty("HTTP-Request-Headers", headers);
        }
        return this.managementService;
    }

    protected EngineConfiguration getEngineConfiguration() {
        try {
            return new ResourceConfigurationProvider(AXIS_CONFIGURATION_RESOURCE);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void setManagementService(ManagementService managementService) {
        this.managementService = managementService;
    }

    protected Object unmarshal(String xml) throws Exception {
        Object obj = null;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            obj = this.unmarshaller.unmarshal(xml);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return obj;
    }

    public UserAndRoleManagement getUserAndRoleManagementService() throws Exception {
        if (this.userAndRoleManagementService == null) {
            UserAndRoleManagementServiceLocator rsl = new UserAndRoleManagementServiceLocator(this.getEngineConfiguration());
            String uriString = this.getWebservicesUri();
            uriString = uriString.replace("/repository", "/UserAndRoleManagementService");
            this.userAndRoleManagementService = rsl.getUserAndRoleManagementServicePort(new URL(uriString));
            ((Stub)this.userAndRoleManagementService).setUsername(this.getUsername());
            ((Stub)this.userAndRoleManagementService).setPassword(this.getPassword());
            ((Stub)this.userAndRoleManagementService).setMaintainSession(true);
            ((Stub)this.userAndRoleManagementService).setTimeout(this.getTimeout());
            Hashtable<String, Boolean> headers = (Hashtable<String, Boolean>)((Stub)this.userAndRoleManagementService)._getProperty("HTTP-Request-Headers");
            if (headers == null) {
                headers = new Hashtable<String, Boolean>();
            }
            headers.put(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED, this.isChuncked() ? Boolean.TRUE : Boolean.FALSE);
            ((Stub)this.userAndRoleManagementService)._setProperty("HTTP-Request-Headers", headers);
        }
        return this.userAndRoleManagementService;
    }

    public void setUserAndRoleManagementService(UserAndRoleManagement userAndRoleManagementService) {
        this.userAndRoleManagementService = userAndRoleManagementService;
    }

    public PermissionsManagement getPermissionsManagement() throws Exception {
        if (this.permissionsManagement == null) {
            PermissionsManagementServiceLocator rsl = new PermissionsManagementServiceLocator(this.getEngineConfiguration());
            String uriString = this.getWebservicesUri();
            uriString = uriString.replace("/repository", "/PermissionsManagementService");
            this.permissionsManagement = rsl.getPermissionsManagementServicePort(new URL(uriString));
            ((Stub)this.permissionsManagement).setUsername(this.getUsername());
            ((Stub)this.permissionsManagement).setPassword(this.getPassword());
            ((Stub)this.permissionsManagement).setMaintainSession(true);
            ((Stub)this.permissionsManagement).setTimeout(this.getTimeout());
            Hashtable<String, Boolean> headers = (Hashtable<String, Boolean>)((Stub)this.permissionsManagement)._getProperty("HTTP-Request-Headers");
            if (headers == null) {
                headers = new Hashtable<String, Boolean>();
            }
            headers.put(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED, this.isChuncked() ? Boolean.TRUE : Boolean.FALSE);
            ((Stub)this.permissionsManagement)._setProperty("HTTP-Request-Headers", headers);
        }
        return this.permissionsManagement;
    }

    public void setPermissionsManagement(PermissionsManagement permissionsManagement) {
        this.permissionsManagement = permissionsManagement;
    }

    public ReportScheduler getReportScheduler() throws Exception {
        if (this.reportScheduler == null) {
            ReportSchedulerServiceLocator rsl = new ReportSchedulerServiceLocator(this.getEngineConfiguration());
            String uriString = this.getWebservicesUri();
            uriString = uriString.replace("/repository", "/ReportScheduler");
            this.reportScheduler = rsl.getReportScheduler(new URL(uriString));
            ((Stub)this.reportScheduler).setUsername(this.getUsername());
            ((Stub)this.reportScheduler).setPassword(this.getPassword());
            ((Stub)this.reportScheduler).setMaintainSession(true);
            ((Stub)this.reportScheduler).setTimeout(this.getTimeout());
            Hashtable<String, Boolean> headers = (Hashtable<String, Boolean>)((Stub)this.reportScheduler)._getProperty("HTTP-Request-Headers");
            if (headers == null) {
                headers = new Hashtable<String, Boolean>();
            }
            headers.put(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED, this.isChuncked() ? Boolean.TRUE : Boolean.FALSE);
            ((Stub)this.reportScheduler)._setProperty("HTTP-Request-Headers", headers);
        }
        return this.reportScheduler;
    }

    public void setReportScheduler(ReportScheduler reportScheduler) {
        this.reportScheduler = reportScheduler;
    }
}

