/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.jrexpressions.ui;

import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.DoubleLiteral;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.FloatLiteral;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.FullMethodName;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.IntLiteral;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.JRFieldObj;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.JRParameterObj;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.JRResourceBundleKeyObj;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.JRVariableObj;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.LongLiteral;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.StringLiteral;
import com.jaspersoft.studio.editor.jrexpressions.util.JRExpressionsModelUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;

public class JavaJRExpressionHighlightingCalculator
implements ISemanticHighlightingCalculator {
    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        if (resource == null) {
            return;
        }
        IParseResult parseResult = resource.getParseResult();
        if (parseResult == null) {
            return;
        }
        ICompositeNode root = parseResult.getRootNode();
        for (ILeafNode nextLeaf : root.getLeafNodes()) {
            EObject semanticElement = nextLeaf.getSemanticElement();
            EObject grammarElement = nextLeaf.getGrammarElement();
            if (JavaJRExpressionHighlightingCalculator.isHiddenToken(grammarElement)) continue;
            if (semanticElement instanceof StringLiteral) {
                acceptor.addPosition(nextLeaf.getOffset(), nextLeaf.getLength(), new String[]{"string"});
                continue;
            }
            if (semanticElement instanceof JRParameterObj) {
                acceptor.addPosition(nextLeaf.getOffset(), nextLeaf.getLength(), new String[]{"Parameter"});
                continue;
            }
            if (semanticElement instanceof JRVariableObj) {
                System.out.println(nextLeaf.getGrammarElement());
                acceptor.addPosition(nextLeaf.getOffset(), nextLeaf.getLength(), new String[]{"Variable"});
                continue;
            }
            if (semanticElement instanceof JRFieldObj) {
                acceptor.addPosition(nextLeaf.getOffset(), nextLeaf.getLength(), new String[]{"Field"});
                continue;
            }
            if (semanticElement instanceof JRResourceBundleKeyObj) {
                acceptor.addPosition(nextLeaf.getOffset(), nextLeaf.getLength(), new String[]{"ResourceBundle Key"});
                continue;
            }
            if (semanticElement instanceof FullMethodName) {
                if (!JRExpressionsModelUtil.isFunctionLibrary((FullMethodName)((FullMethodName)semanticElement))) continue;
                acceptor.addPosition(nextLeaf.getOffset(), nextLeaf.getLength(), new String[]{"Library function"});
                continue;
            }
            if (!JavaJRExpressionHighlightingCalculator.isNumberElement(semanticElement)) continue;
            acceptor.addPosition(nextLeaf.getOffset(), nextLeaf.getLength(), new String[]{"number"});
        }
    }

    private static final boolean isHiddenToken(EObject element) {
        if (element instanceof TerminalRule) {
            String name = ((TerminalRule)element).getName();
            return "ML_COMMENT".equals(name) || "SL_COMMENT".equals(name) || "WS".equals(name);
        }
        return false;
    }

    private static final boolean isNumberElement(EObject element) {
        return element instanceof IntLiteral || element instanceof LongLiteral || element instanceof FloatLiteral || element instanceof DoubleLiteral;
    }
}

