/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.jrexpressions.ui.contentassist;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.ExpressionContextUtils;
import com.jaspersoft.studio.editor.expression.FunctionsLibraryUtil;
import com.jaspersoft.studio.editor.jrexpressions.ui.contentassist.AbstractJavaJRExpressionProposalProvider;
import java.util.Collections;
import java.util.List;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionBean;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class JavaJRExpressionProposalProvider
extends AbstractJavaJRExpressionProposalProvider {
    @Override
    public void complete_JRFieldObj(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ExpressionContext exprContext = (ExpressionContext)((XtextSourceViewer)context.getViewer()).getData("EXPRESSION_CONTEXT");
        if (exprContext != null) {
            List allFields = ExpressionContextUtils.getAllDatasetsFields((ExpressionContext)exprContext);
            for (JRField field : allFields) {
                acceptor.accept(this.createCompletionProposal("$F{" + field.getName() + "}", "$F{" + field.getName() + "}", this.getFieldIconImg(), context));
            }
        }
    }

    @Override
    public void complete_JRVariableObj(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ExpressionContext exprContext = (ExpressionContext)((XtextSourceViewer)context.getViewer()).getData("EXPRESSION_CONTEXT");
        if (exprContext != null) {
            List allVariables = ExpressionContextUtils.getAllDatasetsVariables((ExpressionContext)exprContext);
            for (JRVariable var : allVariables) {
                acceptor.accept(this.createCompletionProposal("$V{" + var.getName() + "}", "$V{" + var.getName() + "}", this.getVariableIconImg(), context));
            }
        }
    }

    @Override
    public void complete_JRParameterObj(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ExpressionContext exprContext = (ExpressionContext)((XtextSourceViewer)context.getViewer()).getData("EXPRESSION_CONTEXT");
        if (exprContext != null) {
            List allParameters = ExpressionContextUtils.getAllDatasetsParameters((ExpressionContext)exprContext);
            for (JRParameter param : allParameters) {
                acceptor.accept(this.createCompletionProposal("$P{" + param.getName() + "}", "$P{" + param.getName() + "}", this.getParameterIconImg(), context));
            }
        }
    }

    @Override
    public void complete_JRResourceBundleKeyObj(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ExpressionContext exprContext = (ExpressionContext)((XtextSourceViewer)context.getViewer()).getData("EXPRESSION_CONTEXT");
        if (exprContext != null) {
            List rbKeys = ExpressionContextUtils.getResourceBundleKeys((ExpressionContext)exprContext);
            for (String k : rbKeys) {
                acceptor.accept(this.createCompletionProposal("$R{" + k + "}", "$R{" + k + "}", this.getResourceBundleKeyIconImg(), context));
            }
        }
    }

    @Override
    public void complete_FullMethodName(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        List allFunctions = FunctionsLibraryUtil.getAllFunctions();
        Collections.sort(allFunctions);
        for (JRExprFunctionBean funct : allFunctions) {
            acceptor.accept(this.createCompletionProposal(funct.getId(), funct.getName(), this.getMethodNameIconImg(), context));
        }
    }

    private Image getParameterIconImg() {
        return ResourceManager.getPluginImage((String)"com.jaspersoft.studio.editor.jrexpressions.ui", (String)"/resources/icons/parameters-16.png");
    }

    private Image getVariableIconImg() {
        return ResourceManager.getPluginImage((String)"com.jaspersoft.studio.editor.jrexpressions.ui", (String)"/resources/icons/variables-16.png");
    }

    private Image getFieldIconImg() {
        return ResourceManager.getPluginImage((String)"com.jaspersoft.studio.editor.jrexpressions.ui", (String)"/resources/icons/fields-16.png");
    }

    private Image getResourceBundleKeyIconImg() {
        return ResourceManager.getPluginImage((String)"com.jaspersoft.studio.editor.jrexpressions.ui", (String)"/resources/icons/resourcebundles-16-icon.png");
    }

    private Image getMethodNameIconImg() {
        return ResourceManager.getPluginImage((String)"com.jaspersoft.studio.editor.jrexpressions.ui", (String)"/resources/icons/methodName.gif");
    }
}

