/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.jrexpressions.ui.support;

import com.jaspersoft.studio.editor.expression.ExpObject;
import com.jaspersoft.studio.editor.jrexpressions.ui.messages.Messages;
import com.jaspersoft.studio.editor.jrexpressions.ui.support.ObjectCategoryItem;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionBean;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.wb.swt.ResourceManager;

public class ObjectItemStyledLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider {
    public static final StyledString.Styler PARAMETER_STYLER;
    public static final StyledString.Styler VARIABLE_STYLER;
    public static final StyledString.Styler FIELD_STYLER;
    public static final StyledString.Styler RBKEY_STYLER;
    public static final StyledString.Styler CLASSTYPE_STYLER;
    private ObjectCategoryItem.Category currentCategory;

    static {
        JFaceResources.getColorRegistry().put("PARAMETER_RED_COLOR", new RGB(190, 39, 39));
        JFaceResources.getColorRegistry().put("VARIABLE_BLUE_COLOR", new RGB(41, 41, 255));
        JFaceResources.getColorRegistry().put("FIELD_GREEN_COLOR", new RGB(39, 144, 39));
        JFaceResources.getColorRegistry().put("RBKEY_GREEN_COLOR", new RGB(102, 46, 153));
        JFaceResources.getColorRegistry().put("GRAY_CLASS_TYPE", new RGB(143, 143, 143));
        PARAMETER_STYLER = StyledString.createColorRegistryStyler((String)"PARAMETER_RED_COLOR", null);
        VARIABLE_STYLER = StyledString.createColorRegistryStyler((String)"VARIABLE_BLUE_COLOR", null);
        FIELD_STYLER = StyledString.createColorRegistryStyler((String)"FIELD_GREEN_COLOR", null);
        RBKEY_STYLER = StyledString.createColorRegistryStyler((String)"RBKEY_GREEN_COLOR", null);
        CLASSTYPE_STYLER = StyledString.createColorRegistryStyler((String)"GRAY_CLASS_TYPE", null);
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        StyledString text = new StyledString();
        if (element instanceof ExpObject) {
            ExpObject obj = (ExpObject)element;
            String name = obj.getName();
            String classType = obj.getClassType();
            if (obj.getType() == 2) {
                text.append(name);
                text.append(Messages.ObjectItemStyledLabelProvider_Parameter, PARAMETER_STYLER);
                text.append(classType.substring(classType.lastIndexOf(".") + 1), CLASSTYPE_STYLER);
            } else if (obj.getType() == 1) {
                text.append(name);
                text.append(Messages.ObjectItemStyledLabelProvider_Variable, VARIABLE_STYLER);
                text.append(classType.substring(classType.lastIndexOf(".") + 1), CLASSTYPE_STYLER);
            } else if (obj.getType() == 0) {
                text.append(name);
                text.append(Messages.ObjectItemStyledLabelProvider_Field, FIELD_STYLER);
                text.append(classType.substring(classType.lastIndexOf(".") + 1), CLASSTYPE_STYLER);
            } else if (obj.getType() == 3) {
                text.append(name);
                text.append(Messages.ObjectItemStyledLabelProvider_Key, RBKEY_STYLER);
                text.append(classType.substring(classType.lastIndexOf(".") + 1), CLASSTYPE_STYLER);
            }
        } else if (element instanceof JRExprFunctionBean) {
            final Font boldFont = ResourceManager.getBoldFont((Font)this.getViewer().getControl().getFont());
            JRExprFunctionBean funct = (JRExprFunctionBean)element;
            text.append(funct.getId(), new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.font = boldFont;
                }
            });
            text.append(Messages.ObjectItemStyledLabelProvider_Returns);
            String canonicalName = funct.getReturnType().getCanonicalName();
            text.append(canonicalName, CLASSTYPE_STYLER);
        } else if (element instanceof String) {
            if (ObjectCategoryItem.Category.RECENT_EXPRESSIONS.equals((Object)this.currentCategory) || ObjectCategoryItem.Category.USER_DEFINED_EXPRESSIONS.equals((Object)this.currentCategory)) {
                if (((String)element).length() > 80) {
                    text.append(element.toString().substring(0, Math.min(80, ((String)element).length())));
                    text.append("...");
                } else {
                    text.append(element.toString());
                }
            } else {
                final Font boldFont = ResourceManager.getBoldFont((Font)this.getViewer().getControl().getFont());
                String methodFirm = element.toString();
                int lParanIdx = methodFirm.indexOf(40);
                int rParanIdx = methodFirm.indexOf(41);
                text.append(methodFirm.substring(0, lParanIdx), new StyledString.Styler(){

                    public void applyStyles(TextStyle textStyle) {
                        textStyle.font = boldFont;
                    }
                });
                text.append(methodFirm.substring(lParanIdx, rParanIdx + 1));
                text.append(methodFirm.substring(rParanIdx + 1), CLASSTYPE_STYLER);
            }
        }
        cell.setText(text.toString());
        cell.setStyleRanges(text.getStyleRanges());
        super.update(cell);
    }

    public String getToolTipText(Object element) {
        if (element instanceof String && (ObjectCategoryItem.Category.RECENT_EXPRESSIONS.equals((Object)this.currentCategory) || ObjectCategoryItem.Category.USER_DEFINED_EXPRESSIONS.equals((Object)this.currentCategory))) {
            return (String)element;
        }
        return super.getToolTipText(element);
    }

    public void setCategory(ObjectCategoryItem.Category currentCategory) {
        this.currentCategory = currentCategory;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        String finalText = "";
        if (element instanceof ExpObject) {
            ExpObject obj = (ExpObject)element;
            finalText = obj.getName();
        } else if (element instanceof JRExprFunctionBean) {
            JRExprFunctionBean funct = (JRExprFunctionBean)element;
            finalText = funct.getId();
        } else if (element instanceof String) {
            finalText = (String)element;
        }
        return finalText;
    }
}

