/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.jrexpressions.ui.support.java;

import com.google.inject.Injector;
import com.jaspersoft.studio.data.designer.UndoRedoImpl;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.ExpressionContextUtils;
import com.jaspersoft.studio.editor.expression.ExpressionEditorComposite;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.editor.expression.ExpressionPersistentWizardDialog;
import com.jaspersoft.studio.editor.expression.ExpressionStatus;
import com.jaspersoft.studio.editor.expression.FunctionsLibraryUtil;
import com.jaspersoft.studio.editor.expression.IExpressionStatusChangeListener;
import com.jaspersoft.studio.editor.jrexpressions.functions.AdditionalStaticFunctions;
import com.jaspersoft.studio.editor.jrexpressions.ui.JRExpressionsActivator;
import com.jaspersoft.studio.editor.jrexpressions.ui.messages.Messages;
import com.jaspersoft.studio.editor.jrexpressions.ui.support.ObjectCategoryItem;
import com.jaspersoft.studio.editor.jrexpressions.ui.support.ObjectsNavigatorContentProvider;
import com.jaspersoft.studio.editor.jrexpressions.ui.support.ObjectsNavigatorLabelProvider;
import com.jaspersoft.studio.editor.jrexpressions.ui.support.StyledTextXtextAdapter2;
import com.jaspersoft.studio.editor.jrexpressions.ui.support.java.EditingAreaHelper;
import com.jaspersoft.studio.editor.jrexpressions.ui.support.java.ObjectCategoryDetailsPanel;
import com.jaspersoft.studio.preferences.ExpressionEditorPreferencePage;
import com.jaspersoft.studio.swt.widgets.ClassType;
import com.jaspersoft.studio.utils.UIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.BundleCommonUtils;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionCategoryBean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.xtext.validation.Issue;

public class JavaExpressionEditorComposite
extends ExpressionEditorComposite {
    public static final int MAIN_SASH_WEIGHT_EDITAREA = 20;
    public static final int MAIN_SASH_WEIGHT_SELECTIONAREA = 80;
    public static final String MAIN_SASH_WEIGHT_EDITAREA_KEY = "mainSashEditArea";
    public static final String MAIN_SASH_WEIGHT_SELECTIONAREA_KEY = "mainSashSelectionArea";
    private JRDesignExpression expression;
    private ExpressionContext exprContext;
    private StyledText editorArea;
    private StyledTextXtextAdapter2 xtextAdapter;
    private TreeViewer objectsNavigator;
    private Composite objectCategoryDetailsCmp;
    private StackLayout detailsPanelStackLayout;
    private List<IExpressionStatusChangeListener> statusChangeListeners;
    private ClassType valueType;
    private SashForm mainSashForm;
    private boolean hasFocus;
    private boolean dragActive;
    private static final int UPDATE_DELAY = 300;
    private UpdatePanelJob updatePanelJob;
    private EditingAreaHelper editingAreaInfo;
    private String currentWidgetText;
    private String valueClassName;
    private Map<String, ObjectCategoryDetailsPanel> detailPanels = new HashMap<String, ObjectCategoryDetailsPanel>();
    private ObjectCategoryItem builtinFunctionsItem;
    private ObjectCategoryItem parametersCategoryItem;
    private ObjectCategoryItem fieldsCategoryItem;
    private ObjectCategoryItem variablesCategoryItem;
    private List<ObjectCategoryItem> rootCategories;

    public JavaExpressionEditorComposite(Composite parent, int style) {
        super(parent, style);
        this.statusChangeListeners = new ArrayList<IExpressionStatusChangeListener>();
        GridLayout gdl = new GridLayout(1, true);
        this.setLayout((Layout)gdl);
        this.mainSashForm = new SashForm((Composite)this, 512);
        GridData gdMainSash = new GridData(4, 4, true, true);
        this.mainSashForm.setLayoutData((Object)gdMainSash);
        this.mainSashForm.addDisposeListener(e -> this.saveMainSashWeights());
        this.createEditorArea((Composite)this.mainSashForm);
        SashForm subSashForm = new SashForm((Composite)this.mainSashForm, 256);
        this.createObjectsNavigator((Composite)subSashForm);
        this.createCustomPanel((Composite)subSashForm);
        this.createBackCompatibilitySection();
        subSashForm.setWeights(new int[]{24, 75});
        this.mainSashForm.setWeights(this.getMainSashWeights());
        FunctionsLibraryUtil.reloadLibrary();
        this.updatePanelJob = new UpdatePanelJob();
        UIUtils.getDisplay().asyncExec(() -> {
            subSashForm.setWeights(new int[]{25, 75});
            this.mainSashForm.layout(true);
            this.mainSashForm.update();
        });
    }

    private int[] getMainSashWeights() {
        IDialogSettings settings;
        if (ExpressionEditorSupportUtil.shouldRememberExpEditorDialogSize() && (settings = JasperReportsPlugin.getDefault().getDialogSettings().getSection(ExpressionPersistentWizardDialog.WIZARD_ID)) != null) {
            try {
                int w1 = settings.getInt(MAIN_SASH_WEIGHT_EDITAREA_KEY);
                int w2 = settings.getInt(MAIN_SASH_WEIGHT_SELECTIONAREA_KEY);
                return new int[]{w1, w2};
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new int[]{20, 80};
    }

    private void saveMainSashWeights() {
        IDialogSettings settings = JasperReportsPlugin.getDefault().getDialogSettings().getSection(ExpressionPersistentWizardDialog.WIZARD_ID);
        if (ExpressionEditorSupportUtil.shouldRememberExpEditorDialogSize()) {
            if (settings == null) {
                settings = JasperReportsPlugin.getDefault().getDialogSettings().addNewSection(ExpressionPersistentWizardDialog.WIZARD_ID);
            }
            settings.put(MAIN_SASH_WEIGHT_EDITAREA_KEY, this.mainSashForm.getWeights()[0]);
            settings.put(MAIN_SASH_WEIGHT_SELECTIONAREA_KEY, this.mainSashForm.getWeights()[1]);
        }
    }

    private void createBackCompatibilitySection() {
        Section backCompatibilitySection = new Section((Composite)this, 4);
        GridData backCompSectionGD = new GridData(4, 4, true, false);
        backCompSectionGD.verticalIndent = 10;
        backCompatibilitySection.setLayoutData((Object)backCompSectionGD);
        backCompatibilitySection.setLayout((Layout)new FillLayout());
        backCompatibilitySection.setText(Messages.JavaExpressionEditorComposite_BackCompatibilitySection);
        Composite composite = new Composite((Composite)backCompatibilitySection, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label lbl1 = new Label(composite, 0);
        lbl1.setText(Messages.JavaExpressionEditorComposite_ValueClassMessage);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        lbl1.setLayoutData((Object)gd);
        this.valueType = new ClassType(composite, Messages.JavaExpressionEditorComposite_ClassTypeDialogTitle);
        this.valueType.addListener(e -> {
            String string = this.valueClassName = this.valueType.getClassType();
        });
        backCompatibilitySection.setClient((Control)composite);
    }

    private void createEditorArea(Composite parent) {
        Composite editorContainer = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.heightHint = 100;
        editorContainer.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        editorContainer.setLayout((Layout)layout);
        this.editorArea = new StyledText(editorContainer, 2625);
        new UndoRedoImpl(this.editorArea);
        GridData editorAreaGD = new GridData(4, 4, true, true);
        editorAreaGD.widthHint = 500;
        this.editorArea.setLayoutData((Object)editorAreaGD);
        this.editorArea.addModifyListener(e -> this.performUpdate());
        this.editorArea.addCaretListener(event -> this.performUpdate());
        this.editorArea.addPaintListener(e -> {
            if (!this.hasFocus && !this.dragActive) {
                this.editingAreaInfo.drawFakeCursor();
            }
        });
        DropTarget dropTarget = new DropTarget((Control)this.editorArea, 17);
        dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent e) {
                JavaExpressionEditorComposite.this.dragActive = true;
                if (e.detail == 16) {
                    e.detail = 1;
                }
                JavaExpressionEditorComposite.this.editorArea.redraw();
            }

            public void dragLeave(DropTargetEvent event) {
                JavaExpressionEditorComposite.this.dragActive = false;
            }

            public void drop(DropTargetEvent event) {
                JavaExpressionEditorComposite.this.editorArea.insert((String)event.data);
                JavaExpressionEditorComposite.this.dragActive = false;
            }
        });
        this.xtextAdapter = new StyledTextXtextAdapter2(this.getInjector());
        this.xtextAdapter.adapt(this.editorArea, this.exprContext);
        this.editingAreaInfo = new EditingAreaHelper(this.xtextAdapter, this.editorArea);
        this.editingAreaInfo.addCategorySelectionListener(event -> this.performCategorySelection(event.selectedCategory));
        this.editorArea.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                JavaExpressionEditorComposite.this.hasFocus = false;
                JavaExpressionEditorComposite.this.editingAreaInfo.ignoreAutoEditStrategies(true);
                JavaExpressionEditorComposite.this.editingAreaInfo.drawFakeCursor();
            }

            public void focusGained(FocusEvent e) {
                JavaExpressionEditorComposite.this.hasFocus = true;
                JavaExpressionEditorComposite.this.editingAreaInfo.ignoreAutoEditStrategies(false);
                JavaExpressionEditorComposite.this.editorArea.redraw();
            }
        });
        UIUtil.enableCopyPasteCutContextMenu((StyledText)this.editorArea);
        new MenuItem(this.editorArea.getMenu(), 2);
        final MenuItem addUserDefinedExprItem = new MenuItem(this.editorArea.getMenu(), 8);
        addUserDefinedExprItem.setText(Messages.JavaExpressionEditorComposite_AddCustomExpressionItemText);
        UIUtil.safeApplyMenuItemTooltip((MenuItem)addUserDefinedExprItem, (String)Messages.JavaExpressionEditorComposite_AddCustomExpressionItemTooltip);
        addUserDefinedExprItem.setImage(ResourceManager.getImage((ImageDescriptor)BundleCommonUtils.getImageDescriptor((String)"com.jaspersoft.studio.editor.jrexpressions.ui", (String)"/resources/icons/expression_obj.gif")));
        addUserDefinedExprItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectionText = JavaExpressionEditorComposite.this.editorArea.getSelectionText();
                if (!selectionText.isEmpty()) {
                    ExpressionEditorPreferencePage.addUserDefinedExpression((String)selectionText);
                    String tmpKey = String.valueOf(ObjectCategoryItem.Category.USER_DEFINED_EXPRESSIONS.getDisplayName()) + "_" + ObjectCategoryItem.Category.USER_DEFINED_EXPRESSIONS.getDisplayName();
                    ObjectCategoryDetailsPanel tmpControl = (ObjectCategoryDetailsPanel)((Object)JavaExpressionEditorComposite.this.detailPanels.get(tmpKey));
                    if (((JavaExpressionEditorComposite)JavaExpressionEditorComposite.this).detailsPanelStackLayout.topControl.equals((Object)tmpControl)) {
                        tmpControl.refreshPanelUI(new ObjectCategoryItem(ObjectCategoryItem.Category.USER_DEFINED_EXPRESSIONS), true);
                    } else if (tmpControl != null) {
                        tmpControl.dispose();
                        JavaExpressionEditorComposite.this.detailPanels.remove(tmpKey);
                    }
                }
            }
        });
        this.editorArea.getMenu().addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                addUserDefinedExprItem.setEnabled(!JavaExpressionEditorComposite.this.editorArea.getSelectionText().isEmpty());
            }
        });
    }

    private void createObjectsNavigator(Composite parent) {
        this.objectsNavigator = new TreeViewer(parent, 2048);
        this.objectsNavigator.setContentProvider((IContentProvider)new ObjectsNavigatorContentProvider());
        this.objectsNavigator.setLabelProvider((IBaseLabelProvider)new ObjectsNavigatorLabelProvider());
        this.objectsNavigator.addSelectionChangedListener(event -> {
            Object selItem = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (selItem instanceof ObjectCategoryItem) {
                this.updateDetailsPanel((ObjectCategoryItem)selItem);
            }
        });
    }

    private void createCustomPanel(Composite parent) {
        this.objectCategoryDetailsCmp = new Composite(parent, 0);
        this.objectCategoryDetailsCmp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.detailsPanelStackLayout = new StackLayout();
        this.objectCategoryDetailsCmp.setLayout((Layout)this.detailsPanelStackLayout);
    }

    public void setExpressionContext(ExpressionContext exprContext) {
        this.exprContext = exprContext;
        this.xtextAdapter.configureExpressionContext(this.exprContext);
        this.refreshExpressionContextUI();
    }

    public JRExpression getExpression() {
        if ("".equals(this.currentWidgetText)) {
            this.expression = null;
        } else {
            this.expression = new JRDesignExpression(this.currentWidgetText);
            this.expression.setValueClassName(this.valueClassName);
        }
        return this.expression;
    }

    public void setExpression(JRExpression expression) {
        this.expression = (JRDesignExpression)expression;
        if (this.expression == null) {
            this.editorArea.setText("");
            this.valueType.setClassType(null);
        } else {
            this.editorArea.setText(expression.getText());
            this.editorArea.selectAll();
            this.valueType.setClassType(this.expression.getValueClassName());
        }
        this.updateExpressionStatus();
    }

    private Injector getInjector() {
        JRExpressionsActivator activator = JRExpressionsActivator.getInstance();
        return activator.getInjector("com.jaspersoft.studio.editor.jrexpressions.JavaJRExpression");
    }

    private void refreshExpressionContextUI() {
        this.rootCategories = new ArrayList<ObjectCategoryItem>();
        if (this.exprContext != null) {
            List contextDatasets = this.exprContext.getDatasets();
            if (contextDatasets.size() == 1) {
                this.parametersCategoryItem = new ObjectCategoryItem(ObjectCategoryItem.Category.PARAMETERS);
                this.parametersCategoryItem.setData(ExpressionContextUtils.getAllDatasetsParameters((ExpressionContext)this.exprContext));
                this.fieldsCategoryItem = new ObjectCategoryItem(ObjectCategoryItem.Category.FIELDS);
                this.fieldsCategoryItem.setData(ExpressionContextUtils.getAllDatasetsFields((ExpressionContext)this.exprContext));
                this.variablesCategoryItem = new ObjectCategoryItem(ObjectCategoryItem.Category.VARIABLES);
                this.variablesCategoryItem.setData(ExpressionContextUtils.getAllDatasetsVariables((ExpressionContext)this.exprContext));
                if (this.exprContext.canShowParameters()) {
                    this.rootCategories.add(this.parametersCategoryItem);
                }
                if (this.exprContext.canShowFields()) {
                    this.rootCategories.add(this.fieldsCategoryItem);
                }
                if (this.exprContext.canShowVariables()) {
                    this.rootCategories.add(this.variablesCategoryItem);
                }
            } else if (contextDatasets.size() > 1) {
                ArrayList<ObjectCategoryItem> paramsDatasets = new ArrayList<ObjectCategoryItem>();
                ArrayList<ObjectCategoryItem> fieldsDatasets = new ArrayList<ObjectCategoryItem>();
                ArrayList<ObjectCategoryItem> variablesDatasets = new ArrayList<ObjectCategoryItem>();
                for (JRDesignDataset ds : contextDatasets) {
                    String dsname = ds.getName();
                    if (ds.isMainDataset()) {
                        dsname = Messages.JavaExpressionEditorComposite_MainDatasetLabel;
                    }
                    ObjectCategoryItem pItems = new ObjectCategoryItem(ObjectCategoryItem.Category.PDATASET, dsname);
                    pItems.setData(ExpressionContextUtils.getDatasetParameters((ExpressionContext)this.exprContext, (JRDesignDataset)ds));
                    paramsDatasets.add(pItems);
                    ObjectCategoryItem fItems = new ObjectCategoryItem(ObjectCategoryItem.Category.FDATASET, dsname);
                    fItems.setData(ExpressionContextUtils.getDatasetFields((ExpressionContext)this.exprContext, (JRDesignDataset)ds));
                    fieldsDatasets.add(fItems);
                    ObjectCategoryItem vItems = new ObjectCategoryItem(ObjectCategoryItem.Category.VDATASET, dsname);
                    vItems.setData(ExpressionContextUtils.getDatasetVariables((ExpressionContext)this.exprContext, (JRDesignDataset)ds));
                    variablesDatasets.add(vItems);
                }
                this.parametersCategoryItem = new ObjectCategoryItem(ObjectCategoryItem.Category.PARAMETERS);
                this.parametersCategoryItem.setData(paramsDatasets.toArray(new ObjectCategoryItem[paramsDatasets.size()]));
                this.fieldsCategoryItem = new ObjectCategoryItem(ObjectCategoryItem.Category.FIELDS);
                this.fieldsCategoryItem.setData(fieldsDatasets.toArray(new ObjectCategoryItem[fieldsDatasets.size()]));
                this.variablesCategoryItem = new ObjectCategoryItem(ObjectCategoryItem.Category.VARIABLES);
                this.variablesCategoryItem.setData(variablesDatasets.toArray(new ObjectCategoryItem[variablesDatasets.size()]));
                this.rootCategories.add(this.parametersCategoryItem);
                this.rootCategories.add(this.fieldsCategoryItem);
                this.rootCategories.add(this.variablesCategoryItem);
            }
            ObjectCategoryItem resourceKeysCategoryItem = new ObjectCategoryItem(ObjectCategoryItem.Category.RESOURCE_KEYS);
            resourceKeysCategoryItem.setData(ExpressionContextUtils.getResourceBundleKeys((ExpressionContext)this.exprContext));
            this.rootCategories.add(resourceKeysCategoryItem);
            int i = 0;
            for (JRDesignCrosstab crosstab : this.exprContext.getCrosstabs()) {
                ++i;
                String crosstabKey = crosstab.getKey();
                if (crosstabKey == null) {
                    crosstabKey = "";
                }
                ObjectCategoryItem tmpCrossTabItem = new ObjectCategoryItem(ObjectCategoryItem.Category.CROSSTAB, String.valueOf(ObjectCategoryItem.Category.CROSSTAB.getDisplayName()) + " (" + i + ") " + crosstabKey);
                tmpCrossTabItem.setData(crosstab);
                this.rootCategories.add(tmpCrossTabItem);
            }
        }
        this.builtinFunctionsItem = new ObjectCategoryItem(ObjectCategoryItem.Category.BUILT_IN_FUNCTIONS);
        ArrayList<? extends ObjectCategoryItem> functionCategories = new ArrayList<ObjectCategoryItem>();
        for (String categoryKey : FunctionsLibraryUtil.getCategories()) {
            JRExprFunctionCategoryBean category = FunctionsLibraryUtil.getCategory((String)categoryKey);
            ObjectCategoryItem objectCategoryItem = new ObjectCategoryItem(ObjectCategoryItem.Category.FUNCTION_CATEGORY, category.getName());
            objectCategoryItem.setData(categoryKey);
            functionCategories.add(objectCategoryItem);
        }
        functionCategories.addAll(this.getAdditionalStaticFunctions());
        Collections.sort(functionCategories, new Comparator<ObjectCategoryItem>(){

            @Override
            public int compare(ObjectCategoryItem arg0, ObjectCategoryItem arg1) {
                return arg0.getDisplayName().compareTo(arg1.getDisplayName());
            }
        });
        if (!functionCategories.isEmpty()) {
            this.builtinFunctionsItem.setData(functionCategories.toArray(new ObjectCategoryItem[functionCategories.size()]));
        }
        this.rootCategories.add(this.builtinFunctionsItem);
        this.rootCategories.add(new ObjectCategoryItem(ObjectCategoryItem.Category.USER_DEFINED_EXPRESSIONS));
        this.rootCategories.add(new ObjectCategoryItem(ObjectCategoryItem.Category.RECENT_EXPRESSIONS));
        this.objectsNavigator.setInput((Object)this.rootCategories.toArray(new ObjectCategoryItem[this.rootCategories.size()]));
        this.objectsNavigator.expandToLevel((Object)this.builtinFunctionsItem, 2);
        this.performCategorySelection(null);
    }

    private Collection<? extends ObjectCategoryItem> getAdditionalStaticFunctions() {
        ObjectCategoryItem i18nFunctions = new ObjectCategoryItem(ObjectCategoryItem.Category.STATIC_FUNCTION_CATEGORY, Messages.JavaExpressionEditorComposite_MessageBundlesCategory);
        i18nFunctions.setData(AdditionalStaticFunctions.getMessageBundleFuntions());
        return Arrays.asList(i18nFunctions);
    }

    public void addExpressionStatusChangeListener(IExpressionStatusChangeListener listener) {
        this.statusChangeListeners.add(listener);
    }

    public void removeExpressionStatusChangeListener(IExpressionStatusChangeListener listener) {
        this.statusChangeListeners.remove(listener);
    }

    public void notifyExpressionStatusChanged(ExpressionStatus status) {
        for (IExpressionStatusChangeListener l : this.statusChangeListeners) {
            l.statusChanged(status);
        }
    }

    private void updateDetailsPanel(ObjectCategoryItem selItem) {
        String key = String.valueOf(selItem.getCategory().getDisplayName()) + "_" + selItem.getDisplayName();
        ObjectCategoryDetailsPanel currentControl = this.detailPanels.get(key);
        if (currentControl == null) {
            currentControl = new ObjectCategoryDetailsPanel(this.objectCategoryDetailsCmp, 0);
            currentControl.setLayoutData(new GridData(4, 4, true, true));
            currentControl.setExpressionContext(this.exprContext);
            currentControl.setEditingAreaInfo(this.editingAreaInfo);
            this.detailPanels.put(key, currentControl);
        }
        Control[] children = this.objectCategoryDetailsCmp.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] != currentControl) {
                children[i].setVisible(false);
            }
            ++i;
        }
        currentControl.setVisible(true);
        currentControl.refreshPanelUI(selItem);
        this.detailsPanelStackLayout.topControl = currentControl;
        this.objectCategoryDetailsCmp.layout();
    }

    private void performCategorySelection(ObjectCategoryItem.Category category) {
        if (category == null) {
            if (!ExpressionContextUtils.getAllDatasetsFields((ExpressionContext)this.exprContext).isEmpty()) {
                this.objectsNavigator.expandToLevel((Object)this.fieldsCategoryItem, 1);
                this.objectsNavigator.setSelection((ISelection)new StructuredSelection((Object)this.fieldsCategoryItem), true);
            } else if (!ExpressionContextUtils.getAllDatasetsVariables((ExpressionContext)this.exprContext).isEmpty()) {
                this.objectsNavigator.expandToLevel((Object)this.variablesCategoryItem, 1);
                this.objectsNavigator.setSelection((ISelection)new StructuredSelection((Object)this.variablesCategoryItem), true);
            } else if (!ExpressionContextUtils.getAllDatasetsParameters((ExpressionContext)this.exprContext).isEmpty()) {
                this.objectsNavigator.expandToLevel((Object)this.parametersCategoryItem, 1);
                this.objectsNavigator.setSelection((ISelection)new StructuredSelection((Object)this.parametersCategoryItem), true);
            } else {
                this.objectsNavigator.expandToLevel((Object)this.rootCategories.get(0), 1);
                this.objectsNavigator.setSelection((ISelection)new StructuredSelection((Object)this.rootCategories.get(0)), true);
            }
            return;
        }
        TreeItem[] treeItemArray = this.objectsNavigator.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object cat = item.getData();
            if (cat instanceof ObjectCategoryItem && ((ObjectCategoryItem)cat).getCategory().equals((Object)category)) {
                this.objectsNavigator.setSelection(null);
                this.objectsNavigator.setSelection((ISelection)new StructuredSelection(cat), true);
                return;
            }
            ++n2;
        }
    }

    private void synchCurrentFunctionDetails() {
        if (this.editingAreaInfo.isUpdate()) {
            return;
        }
        String functName = this.editingAreaInfo.getCurrentLibraryFunctionName();
        if (functName != null) {
            this.objectsNavigator.setSelection((ISelection)new StructuredSelection((Object)this.builtinFunctionsItem), true);
        } else {
            Object selElement = ((IStructuredSelection)this.objectsNavigator.getSelection()).getFirstElement();
            this.objectsNavigator.setSelection((ISelection)new StructuredSelection(selElement), true);
        }
    }

    private void updateExpressionStatus() {
        if (this.editorArea.getText().equals("")) {
            ExpressionStatus exprStatus = ExpressionStatus.INFO;
            exprStatus.setShortDescription(Messages.JavaExpressionEditorComposite_NoValidationIssuesInfo);
            this.notifyExpressionStatusChanged(exprStatus);
            return;
        }
        List validationIssues = this.xtextAdapter.getXtextValidationIssues();
        if (validationIssues != null && !validationIssues.isEmpty()) {
            ExpressionStatus exprStatus = ExpressionStatus.WARNING;
            for (Issue vi : validationIssues) {
                exprStatus.getMessages().add(vi.getMessage());
            }
            exprStatus.setShortDescription(Messages.JavaExpressionEditorComposite_ExpressionInvalidError);
            this.notifyExpressionStatusChanged(exprStatus);
        } else {
            ExpressionStatus exprStatus = ExpressionStatus.INFO;
            exprStatus.setShortDescription(Messages.JavaExpressionEditorComposite_NoValidationIssuesInfo);
            this.notifyExpressionStatusChanged(exprStatus);
        }
    }

    private void performUpdate() {
        this.currentWidgetText = this.editorArea.getText();
        if (this.editorArea.isFocusControl()) {
            this.updatePanelJob.cancel();
            this.updatePanelJob.schedule(300L);
        } else {
            this.synchCurrentFunctionDetails();
            this.updateExpressionStatus();
        }
    }

    public void dispose() {
        if (this.updatePanelJob != null) {
            this.updatePanelJob.cancel();
            this.updatePanelJob = null;
        }
        super.dispose();
    }

    private class UpdatePanelJob
    extends WorkbenchJob {
        public UpdatePanelJob() {
            super(Messages.JavaExpressionEditorComposite_JobName);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!JavaExpressionEditorComposite.this.isDisposed()) {
                monitor.beginTask(Messages.JavaExpressionEditorComposite_TaskName, -1);
                JavaExpressionEditorComposite.this.synchCurrentFunctionDetails();
                JavaExpressionEditorComposite.this.updateExpressionStatus();
                monitor.done();
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
    }
}

