/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.json;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;
import org.glassfish.jersey.media.json.JsonConfiguration;
import org.glassfish.jersey.media.json.JsonConfigured;
import org.glassfish.jersey.media.json.JsonMarshaller;
import org.glassfish.jersey.media.json.JsonUnmarshaller;
import org.glassfish.jersey.media.json.internal.BaseJsonMarshaller;
import org.glassfish.jersey.media.json.internal.BaseJsonUnmarshaller;
import org.glassfish.jersey.media.json.internal.JsonJaxbMarshaller;
import org.glassfish.jersey.media.json.internal.JsonJaxbUnmarshaller;

public final class JsonJaxbContext
extends JAXBContext
implements JsonConfigured {
    @Deprecated
    public static final String NAMESPACE = "com.sun.jersey.impl.json.";
    @Deprecated
    public static final String JSON_NOTATION = "com.sun.jersey.impl.json.notation";
    @Deprecated
    public static final String JSON_ENABLED = "com.sun.jersey.impl.json.enabled";
    @Deprecated
    public static final String JSON_ROOT_UNWRAPPING = "com.sun.jersey.impl.json.root.unwrapping";
    @Deprecated
    public static final String JSON_ARRAYS = "com.sun.jersey.impl.json.arrays";
    @Deprecated
    public static final String JSON_NON_STRINGS = "com.sun.jersey.impl.json.non.strings";
    @Deprecated
    public static final String JSON_ATTRS_AS_ELEMS = "com.sun.jersey.impl.json.attrs.as.elems";
    @Deprecated
    public static final String JSON_XML2JSON_NS = "com.sun.jersey.impl.json.xml.to.json.ns";
    private static final Map<String, Object> defaultJsonProperties = new HashMap<String, Object>();
    private JsonConfiguration jsonConfiguration;
    private final JAXBContext jaxbContext;
    static final Map<String, JsonConfiguration.Notation> _notationMap;

    public JsonJaxbContext(Class ... classesToBeBound) throws JAXBException {
        this(JsonConfiguration.DEFAULT, classesToBeBound);
    }

    public JsonJaxbContext(JsonConfiguration config, Class ... classesToBeBound) throws JAXBException {
        if (config == null) {
            throw new IllegalArgumentException("JSONConfiguration MUST not be null");
        }
        this.jsonConfiguration = config;
        this.jaxbContext = config.getNotation() == JsonConfiguration.Notation.NATURAL ? JAXBContext.newInstance((Class[])classesToBeBound, Collections.singletonMap("retainReferenceToInfo", true)) : JAXBContext.newInstance((Class[])classesToBeBound);
    }

    public JsonJaxbContext(Class[] classesToBeBound, Map<String, Object> properties) throws JAXBException {
        this.jaxbContext = JAXBContext.newInstance((Class[])classesToBeBound, this.createProperties(properties));
        if (this.jsonConfiguration == null) {
            this.jsonConfiguration = JsonConfiguration.DEFAULT;
        }
    }

    public JsonJaxbContext(JsonConfiguration config, Class[] classesToBeBound, Map<String, Object> properties) throws JAXBException {
        if (config == null) {
            throw new IllegalArgumentException("JSONConfiguration MUST not be null");
        }
        this.jsonConfiguration = config;
        if (config.getNotation() == JsonConfiguration.Notation.NATURAL) {
            HashMap<String, Object> myProps = new HashMap<String, Object>(properties.size() + 1);
            myProps.putAll(properties);
            myProps.put("retainReferenceToInfo", Boolean.TRUE);
            this.jaxbContext = JAXBContext.newInstance((Class[])classesToBeBound, myProps);
        } else {
            this.jaxbContext = JAXBContext.newInstance((Class[])classesToBeBound, properties);
        }
    }

    public JsonJaxbContext(String contextPath) throws JAXBException {
        this(JsonConfiguration.DEFAULT, contextPath);
    }

    public JsonJaxbContext(JsonConfiguration config, String contextPath) throws JAXBException {
        if (config == null) {
            throw new IllegalArgumentException("JSONConfiguration MUST not be null");
        }
        this.jaxbContext = config.getNotation() == JsonConfiguration.Notation.NATURAL ? JAXBContext.newInstance((String)contextPath, (ClassLoader)Thread.currentThread().getContextClassLoader(), Collections.singletonMap("retainReferenceToInfo", true)) : JAXBContext.newInstance((String)contextPath, (ClassLoader)Thread.currentThread().getContextClassLoader());
        this.jsonConfiguration = config;
    }

    public JsonJaxbContext(String contextPath, ClassLoader classLoader) throws JAXBException {
        this.jaxbContext = JAXBContext.newInstance((String)contextPath, (ClassLoader)classLoader);
        this.jsonConfiguration = JsonConfiguration.DEFAULT;
    }

    public JsonJaxbContext(String contextPath, ClassLoader classLoader, Map<String, Object> properties) throws JAXBException {
        this.jaxbContext = JAXBContext.newInstance((String)contextPath, (ClassLoader)classLoader, this.createProperties(properties));
        if (this.jsonConfiguration == null) {
            this.jsonConfiguration = JsonConfiguration.DEFAULT;
        }
    }

    public JsonJaxbContext(JsonConfiguration config, String contextPath, ClassLoader classLoader, Map<String, Object> properties) throws JAXBException {
        if (config == null) {
            throw new IllegalArgumentException("JSONConfiguration MUST not be null");
        }
        if (config.getNotation() == JsonConfiguration.Notation.NATURAL) {
            HashMap<String, Object> myProps = new HashMap<String, Object>(properties.size() + 1);
            myProps.putAll(properties);
            myProps.put("retainReferenceToInfo", Boolean.TRUE);
            this.jaxbContext = JAXBContext.newInstance((String)contextPath, (ClassLoader)classLoader, myProps);
        } else {
            this.jaxbContext = JAXBContext.newInstance((String)contextPath, (ClassLoader)classLoader, properties);
        }
        this.jsonConfiguration = config;
    }

    public static JsonMarshaller getJSONMarshaller(Marshaller marshaller) {
        if (marshaller instanceof JsonMarshaller) {
            return (JsonMarshaller)marshaller;
        }
        return new BaseJsonMarshaller(marshaller, JsonConfiguration.DEFAULT);
    }

    public static JsonUnmarshaller getJSONUnmarshaller(Unmarshaller unmarshaller) {
        if (unmarshaller instanceof JsonUnmarshaller) {
            return (JsonUnmarshaller)unmarshaller;
        }
        return new BaseJsonUnmarshaller(unmarshaller, JsonConfiguration.DEFAULT);
    }

    @Override
    public JsonConfiguration getJSONConfiguration() {
        return this.jsonConfiguration;
    }

    public JsonUnmarshaller createJSONUnmarshaller() throws JAXBException {
        return new JsonJaxbUnmarshaller(this, this.getJSONConfiguration());
    }

    public JsonMarshaller createJSONMarshaller() throws JAXBException {
        return new JsonJaxbMarshaller(this, this.getJSONConfiguration());
    }

    public Unmarshaller createUnmarshaller() throws JAXBException {
        return new JsonJaxbUnmarshaller(this.jaxbContext, this.getJSONConfiguration());
    }

    public Marshaller createMarshaller() throws JAXBException {
        return new JsonJaxbMarshaller(this.jaxbContext, this.getJSONConfiguration());
    }

    public Validator createValidator() throws JAXBException {
        return this.jaxbContext.createValidator();
    }

    private Map<String, Object> createProperties(Map<String, Object> properties) {
        HashMap<String, Object> workProperties = new HashMap<String, Object>();
        workProperties.putAll(defaultJsonProperties);
        workProperties.putAll(properties);
        if (JSONNotation.NATURAL == workProperties.get(JSON_NOTATION)) {
            workProperties.put("retainReferenceToInfo", Boolean.TRUE);
        }
        this.processProperties(workProperties);
        return workProperties;
    }

    private final void processProperties(Map<String, Object> properties) {
        HashSet<String> jsonKeys = new HashSet<String>();
        for (String k : Collections.unmodifiableSet(properties.keySet())) {
            if (!k.startsWith(NAMESPACE)) continue;
            jsonKeys.add(k);
        }
        if (!jsonKeys.isEmpty() && this.jsonConfiguration == null) {
            Object nO;
            JsonConfiguration.Notation pNotation = JsonConfiguration.Notation.MAPPED;
            if (properties.containsKey(JSON_NOTATION) && ((nO = properties.get(JSON_NOTATION)) instanceof JSONNotation || nO instanceof String)) {
                pNotation = _notationMap.get(nO.toString());
            }
            this.jsonConfiguration = this.getConfiguration(pNotation, properties);
        }
        for (String k : jsonKeys) {
            properties.remove(k);
        }
    }

    private JsonConfiguration getConfiguration(JsonConfiguration.Notation pNotation, Map<String, Object> properties) {
        String[] a = new String[]{};
        switch (pNotation) {
            case BADGERFISH: {
                return JsonConfiguration.badgerFish().build();
            }
            case MAPPED_JETTISON: {
                JsonConfiguration.MappedJettisonBuilder mappedJettisonBuilder = JsonConfiguration.mappedJettison();
                if (properties.containsKey(JSON_XML2JSON_NS)) {
                    mappedJettisonBuilder.xml2JsonNs((Map)properties.get(JSON_XML2JSON_NS));
                }
                return mappedJettisonBuilder.build();
            }
            case NATURAL: {
                return JsonConfiguration.natural().build();
            }
        }
        JsonConfiguration.MappedBuilder mappedBuilder = JsonConfiguration.mapped();
        if (properties.containsKey(JSON_ARRAYS)) {
            mappedBuilder.arrays(((Collection)properties.get(JSON_ARRAYS)).toArray(a));
        }
        if (properties.containsKey(JSON_ATTRS_AS_ELEMS)) {
            mappedBuilder.attributeAsElement(((Collection)properties.get(JSON_ATTRS_AS_ELEMS)).toArray(a));
        }
        if (properties.containsKey(JSON_NON_STRINGS)) {
            mappedBuilder.nonStrings(((Collection)properties.get(JSON_NON_STRINGS)).toArray(a));
        }
        if (properties.containsKey(JSON_ROOT_UNWRAPPING)) {
            mappedBuilder.rootUnwrapping((Boolean)properties.get(JSON_ROOT_UNWRAPPING));
        }
        return mappedBuilder.build();
    }

    static {
        defaultJsonProperties.put(JSON_NOTATION, (Object)JSONNotation.MAPPED);
        defaultJsonProperties.put(JSON_ROOT_UNWRAPPING, Boolean.TRUE);
        _notationMap = new HashMap<String, JsonConfiguration.Notation>(){
            {
                this.put(JSONNotation.BADGERFISH.toString(), JsonConfiguration.Notation.BADGERFISH);
                this.put(JSONNotation.MAPPED.toString(), JsonConfiguration.Notation.MAPPED);
                this.put(JSONNotation.MAPPED_JETTISON.toString(), JsonConfiguration.Notation.MAPPED_JETTISON);
                this.put(JSONNotation.NATURAL.toString(), JsonConfiguration.Notation.NATURAL);
            }
        };
    }

    @Deprecated
    public static enum JSONNotation {
        MAPPED,
        MAPPED_JETTISON,
        BADGERFISH,
        NATURAL;

    }
}

