/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.json.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.stream.XMLStreamWriter;
import org.glassfish.jersey.media.json.JsonConfiguration;
import org.glassfish.jersey.media.json.JsonConfigured;
import org.glassfish.jersey.media.json.JsonMarshaller;
import org.glassfish.jersey.media.json.internal.Stax2JsonFactory;

public class BaseJsonMarshaller
implements JsonMarshaller,
JsonConfigured {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    protected final Marshaller jaxbMarshaller;
    protected JsonConfiguration jsonConfig;

    public BaseJsonMarshaller(JAXBContext jaxbContext, JsonConfiguration jsonConfig) throws JAXBException {
        this(jaxbContext.createMarshaller(), jsonConfig);
    }

    public BaseJsonMarshaller(Marshaller jaxbMarshaller, JsonConfiguration jsonConfig) {
        this.jsonConfig = jsonConfig;
        this.jaxbMarshaller = jaxbMarshaller;
    }

    @Override
    public JsonConfiguration getJSONConfiguration() {
        return this.jsonConfig;
    }

    @Override
    public void marshallToJSON(Object o, OutputStream outputStream) throws JAXBException {
        if (outputStream == null) {
            throw new IllegalArgumentException("The output stream is null");
        }
        this.marshallToJSON(o, new OutputStreamWriter(outputStream, UTF8));
    }

    @Override
    public void marshallToJSON(Object o, Writer writer) throws JAXBException {
        if (o == null) {
            throw new IllegalArgumentException("The JAXB element is null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("The writer is null");
        }
        this.jaxbMarshaller.marshal(o, this.getXMLStreamWrtier(writer));
    }

    private XMLStreamWriter getXMLStreamWrtier(Writer writer) throws JAXBException {
        try {
            return Stax2JsonFactory.createWriter(writer, this.jsonConfig);
        }
        catch (IOException ex) {
            throw new JAXBException((Throwable)ex);
        }
    }

    @Override
    public void setProperty(String key, Object value) throws PropertyException {
    }
}

