/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.json.internal;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.jersey.media.json.JsonConfiguration;
import org.glassfish.jersey.media.json.JsonConfigured;
import org.glassfish.jersey.media.json.JsonUnmarshaller;
import org.glassfish.jersey.media.json.internal.JsonHelper;
import org.glassfish.jersey.media.json.internal.Stax2JsonFactory;

public class BaseJsonUnmarshaller
implements JsonUnmarshaller,
JsonConfigured {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    protected final Unmarshaller jaxbUnmarshaller;
    protected final JsonConfiguration jsonConfig;

    public BaseJsonUnmarshaller(JAXBContext jaxbContext, JsonConfiguration jsonConfig) throws JAXBException {
        this(jaxbContext.createUnmarshaller(), jsonConfig);
    }

    public BaseJsonUnmarshaller(Unmarshaller jaxbUnmarshaller, JsonConfiguration jsonConfig) {
        this.jaxbUnmarshaller = jaxbUnmarshaller;
        this.jsonConfig = jsonConfig;
    }

    @Override
    public JsonConfiguration getJSONConfiguration() {
        return this.jsonConfig;
    }

    @Override
    public <T> T unmarshalFromJSON(InputStream inputStream, Class<T> expectedType) throws JAXBException {
        return this.unmarshalFromJSON(new InputStreamReader(inputStream, UTF8), expectedType);
    }

    @Override
    public <T> T unmarshalFromJSON(Reader reader, Class<T> expectedType) throws JAXBException {
        if (this.jsonConfig.isRootUnwrapping() || !expectedType.isAnnotationPresent(XmlRootElement.class)) {
            return (T)this.unmarshalJAXBElementFromJSON(reader, expectedType).getValue();
        }
        return (T)this.jaxbUnmarshaller.unmarshal(this.createXmlStreamReader(reader, expectedType));
    }

    @Override
    public <T> JAXBElement<T> unmarshalJAXBElementFromJSON(InputStream inputStream, Class<T> declaredType) throws JAXBException {
        return this.unmarshalJAXBElementFromJSON(new InputStreamReader(inputStream, UTF8), declaredType);
    }

    @Override
    public <T> JAXBElement<T> unmarshalJAXBElementFromJSON(Reader reader, Class<T> declaredType) throws JAXBException {
        return this.jaxbUnmarshaller.unmarshal(this.createXmlStreamReader(reader, declaredType), declaredType);
    }

    private XMLStreamReader createXmlStreamReader(Reader reader, Class expectedType) throws JAXBException {
        try {
            return Stax2JsonFactory.createReader(reader, this.jsonConfig, this.jsonConfig.isRootUnwrapping() ? JsonHelper.getRootElementName(expectedType) : null);
        }
        catch (XMLStreamException ex) {
            throw new UnmarshalException("Error creating JSON-based XMLStreamReader", (Throwable)ex);
        }
    }
}

