/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.efc_report_plugin.db;

import java.awt.HeadlessException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.eclipse.core.runtime.IPath;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public final class SaveOnDatabase {
    private Connection connection;
    private ResultSet resultSet;
    private PreparedStatement statement;
    private IEditorPart topComponent;
    private IPath fileObject;
    private String fileNameKey;
    private Blob blob;
    private int connectionCounter = 0;
    private int type;
    private boolean isReportFile;
    private boolean isImageFile;
    List<IConnectionProfile> dbConnections = new ArrayList<IConnectionProfile>();

    public void save() {
        this.topComponent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        this.upload();
    }

    private Connection getJavaConnectionForProfile(IConnectionProfile profile) {
        IManagedConnection managedConnection = profile.getManagedConnection("java.sql.Connection");
        if (managedConnection != null) {
            return (Connection)managedConnection.getConnection().getRawConnection();
        }
        return null;
    }

    private Connection getConnection() throws SQLException, ClassNotFoundException {
        if (this.dbConnections.size() == 1) {
            if (this.connection == null) {
                this.connection = this.getJavaConnectionForProfile(this.dbConnections.get(0));
            }
            return this.connection;
        }
        return null;
    }

    private void upload() {
        IConnectionProfile[] connections;
        IConnectionProfile[] iConnectionProfileArray = connections = ProfileManager.getInstance().getProfiles();
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile profile = iConnectionProfileArray[n2];
            if (profile.getConnectionState() == 1) {
                this.dbConnections.add(profile);
                ++this.connectionCounter;
            }
            ++n2;
        }
        for (IConnectionProfile conProfile : this.dbConnections) {
            Connection con = this.getJavaConnectionForProfile(conProfile);
            try {
                con.getMetaData().getDatabaseProductName();
            }
            catch (NullPointerException nullPointerException) {
                --this.connectionCounter;
                this.dbConnections.remove(conProfile);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        try {
            if (this.dbConnections.size() > 1) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Fehler", (String)("Zu viele Datenbank-Verbindungen (" + this.connectionCounter + ")"));
            } else if (this.getConnection() == null) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Fehler", (String)"Keine Verbindung zur Datenbank");
            } else if (this.jasperFileExists()) {
                if (this.topComponent.isDirty()) {
                    this.topComponent.doSave(null);
                }
                try {
                    this.statement = this.getConnection().prepareStatement("SELECT PRNRPTID FROM EFC_SYSPRNRPTXMLCODE WHERE PRNRPTID=?");
                    this.statement.setString(1, this.fileNameKey);
                    this.resultSet = this.statement.executeQuery();
                    this.isReportFile = true;
                    if (this.resultSet.next()) {
                        boolean returnValue = this.createDialog("Vorhandener Report wird \u00fcberschrieben.\nSchl\u00fcssel: \n" + this.fileNameKey, "Report \u00fcberschreiben");
                        if (returnValue) {
                            this.updateEfcSysPrnRptXmlCode();
                            this.updateOrCreateEfcSysPrnRpt("Report angelegt");
                        } else {
                            this.cancelAction();
                        }
                    } else {
                        boolean returnValue = this.createDialog("Generierter Schl\u00fcssel: \n" + this.fileNameKey, "Neuer Schl\u00fcssel");
                        if (returnValue) {
                            this.createEfcSysPrnRptXmlCode();
                            this.updateOrCreateEfcSysPrnRpt("Report angelegt");
                        } else {
                            this.cancelAction();
                        }
                    }
                    this.statement.close();
                    this.resultSet.close();
                    this.isReportFile = false;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)ex.getClass().getSimpleName(), (String)ex.getMessage());
                }
            } else if (this.imageFileExists()) {
                try {
                    this.statement = this.getConnection().prepareStatement("SELECT PRNRPTID FROM EFC_SYSPRNRPTXMLCODE WHERE PRNRPTID=?");
                    this.statement.setString(1, this.fileNameKey);
                    this.resultSet = this.statement.executeQuery();
                    this.isImageFile = true;
                    if (this.resultSet.next()) {
                        boolean returnValue = this.createDialog("Vorhandenes Bild wird \u00fcberschrieben.\nSchl\u00fcssel: \n" + this.fileNameKey, "Report \u00fcberschreiben");
                        if (returnValue) {
                            this.updateEfcSysPrnRptXmlCode();
                            this.updateOrCreateEfcSysPrnRpt("Bild gespeichert");
                        } else {
                            this.cancelAction();
                        }
                    } else {
                        boolean returnValue = this.createDialog("Generierter Schl\u00fcssel: \n" + this.fileNameKey, "Neuer Schl\u00fcssel");
                        if (returnValue) {
                            this.createEfcSysPrnRptXmlCode();
                            this.updateOrCreateEfcSysPrnRpt("Bild gespeichert");
                        } else {
                            this.cancelAction();
                        }
                    }
                    this.statement.close();
                    this.resultSet.close();
                    this.isImageFile = false;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)ex.getClass().getSimpleName(), (String)ex.getMessage());
                }
            } else {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Fehler", (String)"Kein Report oder untert\u00fctztes Bildformat ge\u00f6ffnet oder \nFenster nicht aktiv.");
            }
        }
        catch (HeadlessException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private boolean createDialog(String message, String title) {
        return MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
    }

    private void updateOrCreateEfcSysPrnRpt(String messageText) {
        if (this.efcSysPrnRptKeyExists()) {
            this.updateEfcSysPrnRpt();
        } else {
            this.createEfcSysPrnRpt();
        }
        MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, (String)messageText);
    }

    private void cancelAction() {
        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Vorgang abgebrochen", (String)"Vorgang abgebrochen");
    }

    private boolean jasperFileExists() {
        if (this.topComponent != null) {
            IEditorInput input = this.topComponent.getEditorInput();
            if (input == null) {
                return false;
            }
            this.fileObject = ((FileEditorInput)input).getPath();
            if (this.fileObject == null) {
                return false;
            }
            this.fileNameKey = this.getFileName(input);
            if (this.fileObject.getFileExtension().equals("jrxml")) {
                this.type = 0;
                return true;
            }
            if (this.fileObject.getFileExtension().equals("jrtx")) {
                this.type = 20;
                return true;
            }
        }
        return false;
    }

    private String getFileName(IEditorInput input) {
        String nameWithExtension = ((FileEditorInput)input).getName();
        int index = nameWithExtension.indexOf(".");
        return nameWithExtension.substring(0, index).toUpperCase();
    }

    private boolean imageFileExists() {
        if (this.topComponent != null) {
            IEditorInput input = this.topComponent.getEditorInput();
            if (input == null) {
                return false;
            }
            this.fileObject = ((FileEditorInput)input).getPath();
            if (this.fileObject == null) {
                return false;
            }
            this.fileNameKey = this.getFileName(input);
            if (this.fileObject.getFileExtension().equalsIgnoreCase("png") || this.fileObject.getFileExtension().equalsIgnoreCase("jpg") || this.fileObject.getFileExtension().equalsIgnoreCase("jpeg") || this.fileObject.getFileExtension().equalsIgnoreCase("gif") || this.fileObject.getFileExtension().equalsIgnoreCase("bmp")) {
                this.type = 30;
                return true;
            }
        }
        return false;
    }

    private void updateEfcSysPrnRptXmlCode() {
        try {
            this.deleteAndCreateBlob();
            this.statement = this.connection.prepareStatement("UPDATE EFC_SYSPRNRPTXMLCODE SET BINCODE=? WHERE PRNRPTID=?");
            this.statement.setBlob(1, this.blob);
            this.statement.setString(2, this.fileNameKey);
            this.statement.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private void createEfcSysPrnRptXmlCode() {
        try {
            this.deleteAndCreateBlob();
            this.statement = this.connection.prepareStatement("INSERT INTO EFC_SYSPRNRPTXMLCODE (PRNRPTID,BINCODE)VALUES(?,?)");
            this.statement.setString(1, this.fileNameKey);
            this.statement.setBlob(2, this.blob);
            this.statement.execute();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private void deleteAndCreateBlob() {
        this.deleteExistingBlob();
        this.createNewBlob();
    }

    private void createNewBlob() {
        try {
            this.blob = this.connection.createBlob();
            File file = this.fileObject.toFile();
            if (this.isReportFile) {
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] data = new byte[(int)file.length()];
                fileInputStream.read(data);
                fileInputStream.close();
                this.blob.setBytes(1L, data);
            } else if (this.isImageFile) {
                BufferedImage image = ImageIO.read(file);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)image, this.fileObject.getFileExtension(), byteArrayOutputStream);
                this.blob.setBytes(1L, byteArrayOutputStream.toByteArray());
                byteArrayOutputStream.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void deleteExistingBlob() {
        try {
            this.statement = this.connection.prepareStatement("DELETE FROM EFC_SYSPRNRPTBINCODE WHERE PRNRPTID=?");
            this.statement.setString(1, this.fileNameKey);
            this.statement.execute();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private void createEfcSysPrnRpt() {
        try {
            InputDialog inputDialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Kurztext eingeben", "Kurztext eingeben", null, null);
            inputDialog.open();
            String sText = inputDialog.getValue();
            this.statement = this.connection.prepareStatement("INSERT INTO EFC_SYSPRNRPT (PRNRPTID,STEXT,LTEXT,ISEFCSTANDARD,PRNRPTTYPE,CREATEDBY,CREATEDAT,EDITEDBY,EDITEDAT,ISDELETED)VALUES(?,?,?,?,?,?,?,?,?,?)");
            this.statement.setString(1, this.fileNameKey);
            this.statement.setString(2, sText);
            this.statement.setString(3, "");
            this.statement.setInt(4, 0);
            this.statement.setInt(5, this.type);
            this.statement.setString(6, "EFCReport");
            this.statement.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
            this.statement.setString(8, "EFCReport");
            this.statement.setTimestamp(9, new Timestamp(System.currentTimeMillis()));
            this.statement.setInt(10, 0);
            this.statement.execute();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private void updateEfcSysPrnRpt() {
        try {
            this.statement = this.connection.prepareStatement("UPDATE EFC_SYSPRNRPT SET EDITEDBY=?,EDITEDAT=? WHERE PRNRPTID=?");
            this.statement.setString(1, "EFCReport");
            this.statement.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            this.statement.setString(3, this.fileNameKey);
            this.statement.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private boolean efcSysPrnRptKeyExists() {
        try {
            this.statement = this.connection.prepareStatement("SELECT PRNRPTID FROM EFC_SYSPRNRPT WHERE PRNRPTID=?");
            this.statement.setString(1, this.fileNameKey);
            this.resultSet = this.statement.executeQuery();
            return this.resultSet.next();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

