/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.efc_report_plugin.efcql;

import com.jaspersoft.studio.data.fields.IFieldsProvider;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import de.effectivecompany.base.report.query.BeanQuery;
import de.effectivecompany.base.report.query.Query;
import de.effectivecompany.base.report.query.QueryReader;
import de.effectivecompany.base.report.query.ServiceQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.design.JRDesignField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EfcFieldsProvider
implements IFieldsProvider {
    private static Logger logger = LoggerFactory.getLogger(EfcFieldsProvider.class);
    private static final String INVALID_FIELD = "! INVALID ! ";

    public List<JRDesignField> getFields(DataAdapterService con, JasperReportsConfiguration jConfig, JRDataset dataset) throws JRException, UnsupportedOperationException {
        String queryString = dataset.getQuery().getText();
        QueryReader reader = new QueryReader(queryString);
        BeanQuery query = null;
        logger.debug("query: {}", (Object)queryString);
        if (reader.isBeanQuery()) {
            query = new BeanQuery(reader.getFinalQuery(), reader.isWithHistory(), reader.getNamespaces(), con);
        } else {
            StringBuilder finalQuery = new StringBuilder();
            ArrayList<Class> paramClasses = new ArrayList<Class>(5);
            JRQueryChunk[] jRQueryChunkArray = dataset.getQuery().getChunks();
            int n = jRQueryChunkArray.length;
            int n2 = 0;
            while (n2 < n) {
                JRQueryChunk queryChunk = jRQueryChunkArray[n2];
                switch (queryChunk.getType()) {
                    case 4: {
                        break;
                    }
                    case 2: {
                        Class paramClass = null;
                        JRParameter[] params = dataset.getParameters();
                        int i = 0;
                        while (i < params.length) {
                            if (params[i].getName().equals(queryChunk.getText())) {
                                paramClass = params[i].getValueClass();
                                break;
                            }
                            ++i;
                        }
                        paramClasses.add(paramClass);
                        finalQuery.append("?");
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 1: {
                        finalQuery.append(queryChunk.getText());
                    }
                }
                ++n2;
            }
            Pattern pattern = Pattern.compile("([a-z]+)\\.([a-z]+)\\.([a-z0-9]+)\\((.*)\\).*", 2);
            Matcher matcher = pattern.matcher(finalQuery.toString());
            if (!matcher.matches()) {
                throw new JRException("invalid service expression");
            }
            String module = matcher.group(1);
            String service = matcher.group(2);
            String method = matcher.group(3);
            query = new ServiceQuery(module, service, method, paramClasses.toArray(new Class[0]), reader.isWithHistory(), reader.getNamespaces(), con);
        }
        return this.generateFields(dataset, (Query)query, con);
    }

    private List<JRDesignField> generateFields(JRDataset dataset, Query query, DataAdapterService con) throws JRException {
        JRField[] reportFields = dataset.getFields();
        JRField[] queryFields = query.getFields();
        LinkedHashSet<ReportField> tmpFields = new LinkedHashSet<ReportField>();
        int i = 0;
        while (i < queryFields.length) {
            tmpFields.add(new ReportField(queryFields[i]));
            ++i;
        }
        ArrayList<ReportField> preparedReportFields = new ArrayList<ReportField>();
        int i2 = 0;
        while (i2 < reportFields.length) {
            ReportField nextField;
            JRField jRField = reportFields[i2];
            if (!jRField.getDescription().startsWith("* ")) {
                jRField.setDescription("* " + jRField.getDescription());
            }
            if (!tmpFields.contains(nextField = new ReportField(jRField)) && !jRField.getDescription().contains(INVALID_FIELD)) {
                jRField.setDescription(INVALID_FIELD + jRField.getDescription());
            }
            preparedReportFields.add(nextField);
            ++i2;
        }
        Collections.sort(preparedReportFields);
        tmpFields.clear();
        tmpFields.addAll(preparedReportFields);
        int i3 = 0;
        while (i3 < queryFields.length) {
            tmpFields.add(new ReportField(queryFields[i3]));
            ++i3;
        }
        ArrayList<JRDesignField> resultFields = new ArrayList<JRDesignField>();
        for (ReportField reportField : tmpFields) {
            resultFields.add((JRDesignField)reportField.getField());
        }
        return resultFields;
    }

    public boolean supportsGetFieldsOperation(JasperReportsConfiguration jConfig, JRDataset jDataset) {
        return true;
    }

    class ReportField
    implements Comparable<ReportField> {
        private JRField field;
        private String name;

        public ReportField(JRField field) {
            this.field = field;
            this.name = field.getName();
        }

        public JRField getField() {
            return this.field;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReportField other = (ReportField)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        @Override
        public int compareTo(ReportField other) {
            return this.name.compareTo(other.name);
        }
    }
}

