/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.efc_report_plugin.efcql.querydesigner;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.designer.QueryDesigner;
import de.effectivecompany.efc_report_plugin.efcql.EfcDataAdapterDescriptor;
import de.effectivecompany.efc_report_plugin.efcql.adapter.EfcDataAdapter;
import de.effectivecompany.efc_report_plugin.efcql.querydesigner.BOTreeNode;
import de.effectivecompany.efc_report_plugin.efcql.querydesigner.EfcQueryDesignerDialog;
import de.effectivecompany.efc_report_plugin.efcql.querydesigner.QueryTreeModel;
import de.effectivecompany.efc_report_plugin.efcql.querydesigner.SvTreeNode;
import de.effectivecompany.efc_report_plugin.efcql.querydesigner.TreeNode;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class EfcqlQueryDesigner
extends QueryDesigner {
    private Composite composite;
    private JRDesignDataset newDataset;
    private JasperDesign jDesign;

    public Control getControl() {
        return super.getControl();
    }

    public Control createControl(Composite parent) {
        IEditorPart actEditor = JaspersoftStudioPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        super.createControl(parent);
        if (actEditor != null) {
            this.composite = new Composite(parent, 0);
            this.composite.setLayoutData((Object)new GridData(1808));
            FillLayout layout = new FillLayout(256);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.spacing = 0;
            this.composite.setLayout((Layout)layout);
            this.control.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent arg0) {
                    QueryTreeModel model = null;
                    try {
                        Object[] result;
                        model = new QueryTreeModel(EfcqlQueryDesigner.this.getClassLoader());
                        EfcQueryDesignerDialog dialog = new EfcQueryDesignerDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new EfcQueryLabelProvider(), EfcqlQueryDesigner.this.createTreeContentProvider());
                        dialog.setInput(model.getRoot());
                        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
                            try {
                                JRDesignQuery jdq = new JRDesignQuery();
                                jdq.setLanguage("efcql");
                                jdq.setText(EfcqlQueryDesigner.this.getQueryBuilderQuery((TreeNode)result[0], model));
                                EfcqlQueryDesigner.this.newDataset.setQuery(jdq);
                                EfcqlQueryDesigner.this.setQuery(EfcqlQueryDesigner.this.jDesign, (JRDataset)EfcqlQueryDesigner.this.newDataset, EfcqlQueryDesigner.this.jConfig);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Fehler", (String)"Fehler beim Erstellen der Query");
                            }
                        }
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Fehler", (String)"Ben\u00f6tigte Classpath Eintr\u00e4ge fehlen im ausgw\u00e4hlten EFCQL Data Adapter");
                    }
                    catch (JRException e) {
                        e.printStackTrace();
                    }
                }

                public void mouseDown(MouseEvent arg0) {
                }

                public void mouseUp(MouseEvent arg0) {
                }
            });
            return this.composite;
        }
        return super.createControl(parent);
    }

    public String getQueryBuilderQuery(TreeNode selected, QueryTreeModel model) throws Exception {
        if (selected instanceof BOTreeNode) {
            BOTreeNode boNode = (BOTreeNode)selected;
            Object info = boNode.info;
            return "&" + model.getBoEntryModule(info) + "." + model.getBoEntryClassName(info);
        }
        if (selected instanceof SvTreeNode) {
            SvTreeNode svNode = (SvTreeNode)selected;
            Object info = svNode.info;
            String param = "";
            int i = 0;
            while (i < model.getServiceEntryParams(info).length) {
                param = String.valueOf(param) + (!"".equals(param) ? ", " : "") + "$P{EFC_PARAM" + (i + 1) + "}";
                ++i;
            }
            return String.valueOf(model.getServiceEntryModule(info)) + "." + model.getServiceEntryService(info) + "." + model.getServiceEntryMethod(info) + "(" + param + ")";
        }
        return "";
    }

    private ITreeContentProvider createTreeContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return ((TreeNode)parentElement).getChildren();
            }

            public Object getParent(Object element) {
                return ((TreeNode)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return ((TreeNode)element).hasChildren();
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    protected ClassLoader getClassLoader() throws JRException {
        EfcDataAdapter efcDa;
        block13: {
            efcDa = null;
            Object dlg = this.composite.getShell().getData();
            dlg.getClass().getDeclaredFields();
            try {
                Field dataQueryField = dlg.getClass().getDeclaredField("dataquery");
                dataQueryField.setAccessible(true);
                Object datasetDlg = dataQueryField.get(dlg);
                Field newDatasetField = datasetDlg.getClass().getSuperclass().getDeclaredField("newdataset");
                newDatasetField.setAccessible(true);
                this.newDataset = (JRDesignDataset)newDatasetField.get(datasetDlg);
                Field jDesignField = datasetDlg.getClass().getSuperclass().getDeclaredField("jDesign");
                jDesignField.setAccessible(true);
                this.jDesign = (JasperDesign)jDesignField.get(datasetDlg);
                Field comboBoxField = datasetDlg.getClass().getSuperclass().getDeclaredField("dscombo");
                comboBoxField.setAccessible(true);
                Object dsCombo = comboBoxField.get(datasetDlg);
                Method getSelectedMethod = dsCombo.getClass().getDeclaredMethod("getSelected", new Class[0]);
                if (getSelectedMethod.invoke(dsCombo, new Object[0]) instanceof EfcDataAdapterDescriptor) {
                    EfcDataAdapterDescriptor efcDataAdapterDescriptor = (EfcDataAdapterDescriptor)((Object)getSelectedMethod.invoke(dsCombo, new Object[0]));
                    if (efcDataAdapterDescriptor != null) {
                        efcDa = (EfcDataAdapter)efcDataAdapterDescriptor.getDataAdapter();
                        break block13;
                    }
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Fehler", (String)"Kein EFCQL Data Adapter ausgew\u00e4hlt");
                    throw new JRException("Kein EFCQL Data Adapter ausgew\u00e4hlt");
                }
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Fehler", (String)"Kein EFCQL Data Adapter ausgew\u00e4hlt");
                throw new JRException("Kein EFCQL Data Adapter ausgew\u00e4hlt");
            }
            catch (SecurityException e) {
                e.printStackTrace();
                throw new JRException(e.getMessage());
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                throw new JRException(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new JRException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new JRException(e.getMessage());
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new JRException(e.getMessage());
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                throw new JRException(e.getMessage());
            }
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        if (efcDa != null) {
            for (String path : efcDa.getClasspath()) {
                File file = JRResourcesUtil.resolveFile(null, (String)path);
                if (file == null || !file.exists()) continue;
                try {
                    urls.add(file.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]));
    }

    public class EfcQueryLabelProvider
    extends ColumnLabelProvider {
        public String getToolTipText(Object element) {
            if (element instanceof TreeNode) {
                TreeNode treeNode = (TreeNode)element;
                if (!treeNode.desc.isEmpty()) {
                    return treeNode.desc;
                }
            }
            return null;
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 5);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 0;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 5000;
        }
    }
}

