/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.efc_report_plugin.efcql.querydesigner;

import de.effectivecompany.efc_report_plugin.efcql.querydesigner.BOTreeNode;
import de.effectivecompany.efc_report_plugin.efcql.querydesigner.SvTreeNode;
import de.effectivecompany.efc_report_plugin.efcql.querydesigner.TreeNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.sf.jasperreports.engine.JRException;

public class QueryTreeModel
implements TreeModel {
    private TreeNode rootNode = new TreeNode("", 0);
    private SvTreeNode serviceListNode;
    private BOTreeNode boListNode;
    private TreeNode usableObjects = new TreeNode("Usable Objects", 0);

    public QueryTreeModel(ClassLoader classLoader) throws JRException, ClassNotFoundException {
        TreeNode moduleNode;
        this.serviceListNode = new SvTreeNode("Services", 1, "Service calls");
        this.boListNode = new BOTreeNode("Business Objects", 1, "Usable business objects");
        this.rootNode.childs.add(this.usableObjects);
        this.usableObjects.childs.add(this.serviceListNode);
        this.usableObjects.childs.add(this.boListNode);
        Object treeInfo = this.getTreeInfo(classLoader);
        Object[] objectArray = this.getBoEntries(treeInfo);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object boEntry = objectArray[n2];
            moduleNode = null;
            BOTreeNode objectNode = null;
            TreeNode[] treeNodeArray = this.boListNode.getChildren();
            int n3 = treeNodeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeNode boNode = treeNodeArray[n4];
                if (boNode.name.equals(this.getBoEntryModule(boEntry))) {
                    moduleNode = (BOTreeNode)boNode;
                }
                ++n4;
            }
            if (moduleNode == null) {
                moduleNode = new BOTreeNode(this.getBoEntryModule(boEntry), 1);
                this.boListNode.childs.add(moduleNode);
            }
            for (TreeNode boNode : moduleNode.childs) {
                if (!boNode.name.equals(this.getBoEntryClassName(boEntry))) continue;
                objectNode = (BOTreeNode)boNode;
            }
            if (objectNode == null) {
                objectNode = new BOTreeNode(this.getBoEntryClassName(boEntry), 2, boEntry, this.getBoEntryDesc(boEntry));
                moduleNode.childs.add(objectNode);
            }
            ++n2;
        }
        objectArray = this.getServiceEntries(treeInfo);
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object serviceEntry = objectArray[n2];
            moduleNode = null;
            SvTreeNode serviceNode = null;
            SvTreeNode methodNode = null;
            for (TreeNode svNode : this.serviceListNode.childs) {
                if (!svNode.name.equals(this.getServiceEntryModule(serviceEntry))) continue;
                moduleNode = (SvTreeNode)svNode;
            }
            if (moduleNode == null) {
                moduleNode = new SvTreeNode(this.getServiceEntryModule(serviceEntry), 1);
                this.serviceListNode.childs.add(moduleNode);
            }
            for (TreeNode svNode : ((SvTreeNode)moduleNode).childs) {
                if (!svNode.name.equals(this.getServiceEntryService(serviceEntry))) continue;
                serviceNode = (SvTreeNode)svNode;
            }
            if (serviceNode == null) {
                serviceNode = new SvTreeNode(this.getServiceEntryService(serviceEntry), 2);
                ((SvTreeNode)moduleNode).childs.add(serviceNode);
            }
            for (TreeNode svNode : serviceNode.childs) {
                if (!svNode.name.equals(String.valueOf(this.getServiceEntryMethod(serviceEntry)) + "(" + Arrays.toString(this.getServiceEntryParams(serviceEntry)) + ")")) continue;
                methodNode = (SvTreeNode)svNode;
            }
            if (methodNode == null) {
                methodNode = new SvTreeNode(String.valueOf(this.getServiceEntryMethod(serviceEntry)) + "(" + Arrays.toString(this.getServiceEntryParams(serviceEntry)) + ")", 3, serviceEntry, this.getServiceEntryDesc(serviceEntry));
                serviceNode.childs.add(methodNode);
            }
            ++n2;
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }

    @Override
    public Object getRoot() {
        return this.rootNode;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof BOTreeNode) {
            return ((BOTreeNode)node).level == 2;
        }
        return ((TreeNode)node).level == 3;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == null) {
            return null;
        }
        return ((TreeNode)parent).childs.get(index);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null) {
            return 0;
        }
        return ((TreeNode)parent).childs.indexOf(child);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == null) {
            return 0;
        }
        return ((TreeNode)parent).childs.size();
    }

    public Object getInfoForLeaf(TreeNode leaf) {
        return leaf.info;
    }

    public String getDescForLeaf(TreeNode leaf) {
        return leaf.desc;
    }

    public String getBoEntryModule(Object boEntry) throws JRException {
        String module;
        Class[] partypes = new Class[]{};
        Object[] args = new Object[]{};
        try {
            module = (String)boEntry.getClass().getMethod("getModule", partypes).invoke(boEntry, args);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        return module;
    }

    public String getBoEntryClassName(Object boEntry) throws JRException {
        String className;
        Class[] partypes = new Class[]{};
        Object[] args = new Object[]{};
        try {
            className = (String)boEntry.getClass().getMethod("getClassname", partypes).invoke(boEntry, args);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        return className;
    }

    public String getBoEntryDesc(Object boEntry) throws JRException {
        String desc;
        Class[] partypes = new Class[]{};
        Object[] args = new Object[]{};
        try {
            desc = (String)boEntry.getClass().getMethod("getDesc", partypes).invoke(boEntry, args);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        return desc;
    }

    public String getServiceEntryModule(Object serviceEntry) throws JRException {
        String module;
        Class[] partypes = new Class[]{};
        Object[] args = new Object[]{};
        try {
            module = (String)serviceEntry.getClass().getMethod("getModule", partypes).invoke(serviceEntry, args);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        return module;
    }

    public String getServiceEntryService(Object serviceEntry) throws JRException {
        String service;
        Class[] partypes = new Class[]{};
        Object[] args = new Object[]{};
        try {
            service = (String)serviceEntry.getClass().getMethod("getService", partypes).invoke(serviceEntry, args);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        return service;
    }

    public String getServiceEntryMethod(Object serviceEntry) throws JRException {
        String method;
        Class[] partypes = new Class[]{};
        Object[] args = new Object[]{};
        try {
            method = (String)serviceEntry.getClass().getMethod("getMethod", partypes).invoke(serviceEntry, args);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        return method;
    }

    public String[] getServiceEntryParams(Object serviceEntry) throws JRException {
        String[] params;
        Class[] partypes = new Class[]{};
        Object[] args = new Object[]{};
        try {
            params = (String[])serviceEntry.getClass().getMethod("getParams", partypes).invoke(serviceEntry, args);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        return params;
    }

    public String getServiceEntryDesc(Object serviceEntry) throws JRException {
        String desc;
        Class[] partypes = new Class[]{};
        Object[] args = new Object[]{};
        try {
            desc = (String)serviceEntry.getClass().getMethod("getDesc", partypes).invoke(serviceEntry, args);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        return desc;
    }

    private Object getTreeInfo(ClassLoader classLoader) throws JRException, ClassNotFoundException {
        try {
            Class<?> treeInfoClass = Class.forName("de.effectivecompany.report.TreeInfo", true, classLoader);
            Method method = treeInfoClass.getMethod("getInstance", new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
    }

    private Object[] getBoEntries(Object treeInfo) throws JRException {
        Class[] partypes = new Class[]{};
        Object[] args = new Object[]{};
        try {
            return (Object[])treeInfo.getClass().getMethod("getBoEntries", partypes).invoke(treeInfo, args);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
    }

    private Object[] getServiceEntries(Object treeInfo) throws JRException {
        Class[] partypes = new Class[]{};
        Object[] args = new Object[]{};
        try {
            return (Object[])treeInfo.getClass().getMethod("getServiceEntries", partypes).invoke(treeInfo, args);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
    }
}

