/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.svgimporter;

import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignImage;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.commands.Command;

public final class CreateResourceCommand
extends Command {
    private File tempResource;
    private JRDesignImage targetJRElement;
    private JasperReportsConfiguration jConfig;
    private IFile destFile = null;

    public CreateResourceCommand(File tempResource, JRDesignImage targetJRElement, JasperReportsConfiguration jConfig) {
        this.tempResource = tempResource;
        this.targetJRElement = targetJRElement;
        this.jConfig = jConfig;
    }

    public void execute() {
        block6: {
            IFile mfile = (IFile)this.jConfig.get("ifile");
            IContainer parent = mfile.getParent();
            int counter = 1;
            String filename = this.tempResource.getName();
            this.destFile = parent.getFile((IPath)new Path(filename));
            String extension = FilenameUtils.getExtension((String)filename);
            while (this.destFile.exists()) {
                filename = "imported_image_" + counter + "." + extension;
                parent.getFile((IPath)new Path(filename));
                ++counter;
            }
            this.targetJRElement.setExpression((JRExpression)new JRDesignExpression("\"" + this.destFile.getName() + "\""));
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(this.tempResource);
                    this.destFile.create((InputStream)fileInputStream, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    FileUtils.closeStream((Closeable)fileInputStream);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(fileInputStream);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)fileInputStream);
        }
    }

    public void undo() {
        if (this.destFile != null) {
            try {
                this.destFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

