/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.mongodb.adapter;

import com.jaspersoft.mongodb.adapter.MongoDbDataAdapter;
import com.jaspersoft.mongodb.connection.MongoDbConnection;
import java.util.Map;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.util.SecretsUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MongoDbDataAdapterService
extends AbstractDataAdapterService {
    private static final Log log = LogFactory.getLog(MongoDbDataAdapterService.class);
    private MongoDbConnection connection;
    private MongoDbDataAdapter dataAdapter;

    public MongoDbDataAdapterService(JasperReportsContext jasperReportsContext, MongoDbDataAdapter dataAdapter) {
        super(jasperReportsContext, (DataAdapter)dataAdapter);
        this.dataAdapter = dataAdapter;
    }

    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        if (this.connection != null) {
            this.dispose();
        }
        if (this.dataAdapter != null) {
            try {
                this.createConnection();
                parameters.put("REPORT_CONNECTION", this.connection);
            }
            catch (Exception e) {
                throw new JRException((Throwable)e);
            }
        }
    }

    private void createConnection() throws JRException {
        String password = this.dataAdapter.getPassword();
        SecretsUtil secretService = SecretsUtil.getInstance((JasperReportsContext)this.getJasperReportsContext());
        if (secretService != null) {
            password = secretService.getSecret("net.sf.jasperreports.data.adapter", password);
        }
        this.connection = new MongoDbConnection(this.dataAdapter.getMongoURI(), this.dataAdapter.getUsername(), password);
    }

    public void dispose() {
        block3: {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Error while closing the connection.", (Throwable)e);
            }
        }
    }

    public void test() throws JRException {
        try {
            if (this.connection == null) {
                this.createConnection();
            }
            this.connection.test();
        }
        finally {
            this.dispose();
        }
    }
}

