/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.mongodb.connection;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoDatabase;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoDbConnection
implements Connection {
    private static final String URL_PREFIX = "mongodb://";
    private MongoClient client;
    private MongoClientURI mongoURIObject;
    private final String mongoURI;
    private final String username;
    private final String password;
    private static final Log logger = LogFactory.getLog(MongoDbConnection.class);

    public MongoDbConnection(String mongoURI, String username, String password) throws JRException {
        try {
            this.mongoURI = mongoURI;
            this.username = username;
            this.password = password;
            this.mongoURIObject = new MongoClientURI(this.mergeAuthInfoIntoURI(mongoURI, username, password));
            this.client = new MongoClient(this.mongoURIObject);
            this.test();
        }
        catch (Exception e) {
            String msg = "Error creating MongoDBConnection; Caused by: " + e.getMessage();
            logger.error((Object)msg, (Throwable)e);
            throw new JRException(msg, (Throwable)e);
        }
    }

    private String mergeAuthInfoIntoURI(String mongoURI, String username, String password) {
        boolean authInfoPresent;
        boolean bl = authInfoPresent = mongoURI.indexOf(64) > 0;
        if (!authInfoPresent && StringUtils.isNotBlank((String)username)) {
            try {
                StringBuilder mongoURIWithAuthInfo = new StringBuilder(URL_PREFIX).append(URLEncoder.encode(username, "UTF-8"));
                if (StringUtils.isNotBlank((String)password)) {
                    mongoURIWithAuthInfo.append(':').append(URLEncoder.encode(password, "UTF-8"));
                }
                return mongoURIWithAuthInfo.append('@').append(mongoURI.substring(URL_PREFIX.length())).toString();
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return mongoURI;
    }

    public MongoDatabase getMongoDatabase() {
        if (this.client == null) {
            logger.error((Object)"No client");
            return null;
        }
        if (this.mongoURIObject == null) {
            logger.error((Object)"No mongoURIObject");
            return null;
        }
        return this.client.getDatabase(this.mongoURIObject.getDatabase());
    }

    public String getMongoURI() {
        return this.mongoURI;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        this.mongoURIObject = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.client == null;
    }

    public MongoClientURI getMongoURIObject() {
        return new MongoClientURI(this.mongoURIObject.getURI());
    }

    public MongoClient getClient() {
        return this.client;
    }

    public String test() throws JRException {
        if (this.mongoURIObject == null) {
            throw new JRException("Invalid mongo URL");
        }
        MongoDatabase mongoDatabase = this.getMongoDatabase();
        if (mongoDatabase == null) {
            throw new JRException("No mongo database");
        }
        try {
            if (this.mongoURIObject.getCredentials() == null) {
                mongoDatabase.listCollectionNames();
            }
            return "Connection test successful.\nMongo server version: " + mongoDatabase.runCommand((Bson)new Document("buildInfo", (Object)1)).getString((Object)"version");
        }
        catch (Exception e) {
            String msg = "Cannot test MongoDB connection; Caused by: " + e.getMessage();
            logger.error((Object)msg, (Throwable)e);
            throw new JRException(msg, (Throwable)e);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return null;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return null;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return false;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return null;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            return this.test() != null;
        }
        catch (JRException e) {
            throw new SQLException("Validation failed; Caused by: " + e.getMessage(), e);
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }
}

