/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.mongodb.connection;

import com.jaspersoft.mongodb.connection.MongoDbConnection;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.PoolableObjectFactory;

public class MongoDbConnectionFactory
implements PoolableObjectFactory<MongoDbConnection> {
    private static final Log logger = LogFactory.getLog(MongoDbConnectionFactory.class);
    private String mongoURI;
    private String username;
    private String password;

    public void activateObject(MongoDbConnection connection) throws Exception {
    }

    public void destroyObject(MongoDbConnection connection) throws Exception {
        logger.info((Object)"Factory destroy object");
        if (connection != null) {
            connection.close();
        }
    }

    public MongoDbConnection makeObject() throws Exception {
        logger.info((Object)"Factory make object");
        return new MongoDbConnection(this.mongoURI, this.username, this.password);
    }

    public void passivateObject(MongoDbConnection connection) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Passivate is not implemented");
        }
    }

    public boolean validateObject(MongoDbConnection connection) {
        logger.info((Object)"Factory validate object");
        if (connection != null) {
            try {
                boolean mongoURIValid = this.mongoURI != null && this.mongoURI.equals(connection.getMongoURI());
                boolean usernameValid = this.username == null || this.username.equals(connection.getUsername());
                boolean passwordValid = this.password == null || this.password.equals(connection.getPassword());
                return mongoURIValid && usernameValid && passwordValid && connection.test() != null;
            }
            catch (JRException e) {
                logger.error((Object)("Cannot validate object; Caused by: " + e.getMessage()), (Throwable)e);
            }
        }
        return false;
    }

    public void setMongoURI(String mongoURI) {
        this.mongoURI = mongoURI;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

