/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.mongodb.query;

import com.jaspersoft.mongodb.connection.MongoDbConnection;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CollationAlternate;
import com.mongodb.client.model.CollationCaseFirst;
import com.mongodb.client.model.CollationMaxVariable;
import com.mongodb.client.model.CollationStrength;
import com.mongodb.client.model.MapReduceAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoDbQueryWrapper {
    private static final Log logger = LogFactory.getLog(MongoDbQueryWrapper.class);
    public static final String FIND_QUERY_KEY = "findQuery";
    public static final String FIND_QUERY_REGEXP_KEY = "findQueryRegEx";
    public static final String FIND_FIELDS_KEY = "findFields";
    public static final String SORT_KEY = "sort";
    public static final String LIMIT_KEY = "limit";
    public static final String COLLECTION_NAME_KEY = "collectionName";
    public static final String ROWS_TO_PROCESS_KEY = "rowsToProcess";
    public static final String MAP_REDUCE_KEY = "mapReduce";
    public static final String MAP_KEY = "map";
    public static final String MAPQUERY_KEY = "query";
    public static final String REDUCE_KEY = "reduce";
    public static final String OUT_KEY = "out";
    private static final String OUT_DB_KEY = "db";
    private static final String FINALIZE_KEY = "finalize";
    private static final String RUN_COMMAND_KEY = "runCommand";
    private static final String RUN_AGGREGATE_KEY = "aggregate";
    private static final String RUN_AGGREGATE_PIPELINE_KEY = "pipeline";
    private static final String RESULT_KEY = "result";
    private static final String RUN_COMMAND_MAPREDUCE = "results";
    private static final String RUN_COMMAND_DISTINCT = "values";
    private static final String RUN_COMMAND_COUNT = "n";
    private static final String RUN_COMMAND_GROUP = "retval";
    private static final String RUN_COMMAND_CURSOR = "cursor";
    private static final String BATCH_SIZE_KEY = "batchSize";
    private static final String COLLATION_KEY = "collation";
    private static final String MAXTIME_KEY = "maxTime";
    public MongoCursor iterator;
    public BasicDBObject queryObject;
    public int rowsToProcess = 5;
    private MongoDbConnection connection;
    private Map<String, Object> parameters;
    public List<?> commandResults;

    public MongoDbQueryWrapper(String queryString, MongoDbConnection connection, Map<String, Object> parameters) throws JRException {
        this.connection = connection;
        this.parameters = parameters;
        this.processQuery(queryString);
    }

    public void processQuery(String queryString) throws JRException {
        Integer value;
        logger.info((Object)"Processing mongoDB query");
        if (queryString != null && queryString.isEmpty()) {
            throw new JRException("Query is empty");
        }
        if (queryString.startsWith("\"")) {
            queryString = queryString.substring(1, queryString.length());
        }
        if (queryString.endsWith("\"")) {
            queryString = queryString.substring(0, queryString.length() - 1);
        }
        BasicDBObject parseResult = BasicDBObject.parse((String)queryString);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Query: " + queryString));
        }
        if (!(parseResult instanceof BasicDBObject)) {
            throw new JRException("Unsupported type: " + parseResult.getClass().getName());
        }
        this.queryObject = parseResult;
        this.fixQueryObject(this.queryObject, this.parameters);
        if (this.queryObject.containsField(RUN_COMMAND_KEY)) {
            BasicDBObject command = (BasicDBObject)this.queryObject.removeField(RUN_COMMAND_KEY);
            if (command.containsField(RUN_AGGREGATE_KEY)) {
                this.runAggregate(command.removeField(RUN_AGGREGATE_PIPELINE_KEY), command.getString(RUN_AGGREGATE_KEY));
                logger.warn((Object)"runCommand aggregations are deprecated ! use API Driven query for aggregation in future");
            } else {
                this.runCommand(this.queryObject.removeField(RUN_COMMAND_KEY));
            }
        } else {
            this.createIterator();
        }
        if (this.queryObject.containsField(ROWS_TO_PROCESS_KEY) && (value = this.processInteger(this.queryObject.get(ROWS_TO_PROCESS_KEY))) != null) {
            this.rowsToProcess = value;
        }
        if (this.rowsToProcess == 0) {
            this.rowsToProcess = Integer.MAX_VALUE;
        }
    }

    private Object fixQueryObject(BasicDBObject queryObjectToFix, Map<String, Object> reportParameters) {
        String key;
        Set keySet = queryObjectToFix.keySet();
        if (keySet.size() == 1 && reportParameters.containsKey(key = (String)keySet.iterator().next()) && queryObjectToFix.get(key) == null) {
            return reportParameters.get(key);
        }
        for (String key2 : queryObjectToFix.keySet()) {
            Object value = queryObjectToFix.get(key2);
            if (!(value instanceof BasicDBObject)) continue;
            queryObjectToFix.put((Object)key2, this.fixQueryObject((BasicDBObject)value, reportParameters));
        }
        return queryObjectToFix;
    }

    private Object getOutputCommand(CommandResult commandResult) {
        Object resultObject = null;
        if (commandResult.get(RESULT_KEY) != null) {
            resultObject = commandResult.get(RESULT_KEY);
        } else if (commandResult.get(RUN_COMMAND_MAPREDUCE) != null) {
            resultObject = commandResult.get(RUN_COMMAND_MAPREDUCE);
        } else if (commandResult.get(RUN_COMMAND_DISTINCT) != null) {
            resultObject = commandResult.get(RUN_COMMAND_DISTINCT);
        } else if (commandResult.get(RUN_COMMAND_GROUP) != null) {
            resultObject = commandResult.get(RUN_COMMAND_GROUP);
        } else if (commandResult.get(RUN_COMMAND_COUNT) != null) {
            resultObject = commandResult.get(RUN_COMMAND_COUNT);
        } else if (commandResult.get(RUN_COMMAND_CURSOR) != null) {
            resultObject = commandResult.get(RUN_COMMAND_CURSOR);
        }
        return resultObject;
    }

    private List<?> convertObjectToList(Object resultObject) {
        List listObjects = null;
        if (resultObject instanceof Integer) {
            listObjects = (List)BasicDBObject.parse((String)("[{'total':'" + resultObject.toString() + "'}]"));
        } else if (resultObject instanceof String) {
            listObjects = (List)BasicDBObject.parse((String)("[{'total':'" + resultObject.toString() + "'}]"));
        } else if (resultObject instanceof BasicDBList) {
            BasicDBList arrayObject = (BasicDBList)resultObject;
            boolean isTuple = true;
            for (int i = 0; i < arrayObject.size(); ++i) {
                if (!(arrayObject.get(i) instanceof BasicDBObject)) continue;
                isTuple = false;
                break;
            }
            if (!isTuple) {
                listObjects = (List)resultObject;
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("[");
                for (int i = 0; i < arrayObject.size(); ++i) {
                    if (i != 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("{'id':'" + i + "', 'value':'" + arrayObject.get(i) + "'}");
                }
                stringBuilder.append("]");
                listObjects = (List)BasicDBObject.parse((String)stringBuilder.toString());
            }
        }
        return listObjects;
    }

    private void runAggregate(Object commandValue, String collectionName) throws JRException {
        if (!(commandValue instanceof BasicDBList)) {
            throw new JRException("Command must be a valid BSON object");
        }
        ArrayList commandObject = new ArrayList(((BasicDBList)commandValue).size());
        ((BasicDBList)commandValue).forEach(command -> commandObject.add((Bson)command));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Command object: " + commandObject));
        }
        this.iterator = collectionName != null && !collectionName.isEmpty() ? this.connection.getMongoDatabase().getCollection(collectionName).aggregate(commandObject, BasicDBObject.class).iterator() : this.connection.getMongoDatabase().aggregate(commandObject, BasicDBObject.class).iterator();
    }

    private void runCommand(Object commandValue) throws JRException {
        Object resultObject;
        CommandResult commandResult;
        if (!(commandValue instanceof BasicDBObject)) {
            throw new JRException("Command must be a valid BSON object");
        }
        BasicDBObject commandObject = (BasicDBObject)commandValue;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Command object: " + commandObject));
        }
        if (!(commandResult = (CommandResult)this.connection.getMongoDatabase().runCommand((Bson)commandObject, CommandResult.class)).ok()) {
            throw new JRException(commandResult.getErrorMessage());
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)commandResult.toJson());
        }
        if ((resultObject = this.getOutputCommand(commandResult)) == null) {
            throw new JRException("No results");
        }
        if (logger.isInfoEnabled()) {
            logger.info(resultObject);
        }
        this.commandResults = this.convertObjectToList(resultObject);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Result List: " + resultObject));
        }
    }

    private void createIterator() throws JRException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)this.queryObject.toString());
        }
        if (!this.queryObject.containsField(COLLECTION_NAME_KEY)) {
            throw new JRException("\"collectionName\" must be part of the query object");
        }
        BasicDBObject findQueryObject = (BasicDBObject)this.queryObject.get(FIND_QUERY_KEY);
        if (findQueryObject == null) {
            findQueryObject = new BasicDBObject();
        }
        if (this.queryObject.containsField(FIND_QUERY_REGEXP_KEY)) {
            BasicDBObject regExpObject = (BasicDBObject)this.queryObject.get(FIND_QUERY_REGEXP_KEY);
            for (String key : regExpObject.keySet()) {
                String value = (String)regExpObject.get(key);
                if (!value.startsWith("/")) {
                    throw new JRException("Regular expressions must start with: /");
                }
                value = value.substring(1, value.length());
                if (!value.contains("/")) {
                    throw new JRException("No ending symbol found: /");
                }
                int index = value.lastIndexOf("/");
                String flags = null;
                if (index == value.length() - 1) {
                    value = value.substring(0, index);
                } else {
                    flags = value.substring(index + 1, value.length());
                    value = value.substring(0, index);
                }
                findQueryObject.put((Object)key, (Object)Pattern.compile((flags != null ? "(?" + flags + ")" : "") + value));
            }
        }
        MongoCollection collection = this.connection.getMongoDatabase().getCollection((String)this.queryObject.removeField(COLLECTION_NAME_KEY));
        Integer limitValue = 0;
        Integer batchSize = 0;
        Long maxTime = 0L;
        Collation collation = null;
        if (this.queryObject.containsField(LIMIT_KEY)) {
            limitValue = this.processInteger(this.queryObject.getInt(LIMIT_KEY, 0));
        }
        if (this.queryObject.containsField(BATCH_SIZE_KEY)) {
            batchSize = this.processInteger(this.queryObject.getInt(BATCH_SIZE_KEY, 0));
        }
        if (this.queryObject.containsField(MAXTIME_KEY)) {
            maxTime = this.queryObject.getLong(MAXTIME_KEY, 0L);
        }
        if (this.queryObject.containsField(COLLATION_KEY)) {
            if (this.queryObject.get(COLLATION_KEY) == null) {
                throw new JRException("Collation document error: no document !");
            }
            Document col = Document.parse((String)this.queryObject.getString(COLLATION_KEY));
            if (col.getString((Object)"locale") == null) {
                throw new JRException("Collation document require locale to be present.");
            }
            collation = Collation.builder().locale(col.getString((Object)"locale")).collationStrength(CollationStrength.fromInt((int)col.getInteger((Object)"strength", 3))).caseLevel(Boolean.valueOf(col.getBoolean((Object)"caseLevel", false))).collationCaseFirst(CollationCaseFirst.fromString((String)((String)col.get((Object)"caseFirst", (Object)"off")))).numericOrdering(Boolean.valueOf(col.getBoolean((Object)"numericOrdering", false))).collationAlternate(CollationAlternate.fromString((String)((String)col.get((Object)"alternate", (Object)"non-ignorable")))).collationMaxVariable(CollationMaxVariable.fromString((String)((String)col.get((Object)"maxVariable", (Object)"punct")))).backwards(Boolean.valueOf(col.getBoolean((Object)"backwards", false))).normalization(Boolean.valueOf(col.getBoolean((Object)"normalization", false))).build();
        }
        if (this.queryObject.containsField(MAP_REDUCE_KEY)) {
            Object value = this.queryObject.removeField(MAP_REDUCE_KEY);
            if (!(value instanceof BasicDBObject)) {
                logger.error((Object)"MapReduce value must be a valid JSON object");
            } else {
                Object outObject;
                BasicDBObject mapReduceObject = (BasicDBObject)value;
                String map = this.validateProperty(mapReduceObject, MAP_KEY);
                String reduce = this.validateProperty(mapReduceObject, REDUCE_KEY);
                Object queryParameter = mapReduceObject.get(MAPQUERY_KEY);
                if (logger.isInfoEnabled()) {
                    logger.info(queryParameter);
                }
                BasicDBObject queryValue = null;
                if (queryParameter != null) {
                    queryValue = BasicDBObject.parse((String)String.valueOf(queryParameter));
                }
                if ((outObject = mapReduceObject.get(OUT_KEY)) == null) {
                    // empty if block
                }
                String collectionName = null;
                Object outDb = null;
                MapReduceAction outputType = null;
                boolean hasOutputType = false;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Out object: " + outObject + ". Type: " + outObject.getClass().getName()));
                }
                if (outObject instanceof String) {
                    collectionName = String.valueOf(outObject);
                } else if (outObject instanceof BasicDBObject) {
                    BasicDBObject outDbObject = (BasicDBObject)outObject;
                    outDb = outDbObject.removeField(OUT_DB_KEY);
                    Iterator keysIterator = outDbObject.keySet().iterator();
                    String type = null;
                    if (!keysIterator.hasNext()) {
                        throw new JRException("\"out\" object cannot be empty");
                    }
                    type = (String)keysIterator.next();
                    collectionName = String.valueOf(outDbObject.get(type));
                    type = type.toUpperCase();
                    outputType = MapReduceAction.valueOf((String)type);
                    if (outputType == null) {
                        throw new JRException("Unknow output type: " + type);
                    }
                    hasOutputType = true;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)outDbObject.toString());
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("outobject: " + outDbObject));
                        logger.debug((Object)("collectionName: " + collectionName));
                        logger.debug((Object)("outputType: " + outputType));
                    }
                } else {
                    throw new JRException("Unsupported type for \"out\": " + outObject.getClass().getName());
                }
                MapReduceIterable mapReduceIterable = collection.mapReduce(map, reduce, BasicDBObject.class).action(hasOutputType ? outputType : MapReduceAction.REPLACE).databaseName(outDb != null ? String.valueOf(outDb) : this.connection.getMongoDatabase().getName()).collectionName(collectionName).finalizeFunction((String)mapReduceObject.removeField(FINALIZE_KEY)).sharded(false).filter((Bson)queryValue).batchSize(batchSize.intValue()).limit(limitValue.intValue()).sort((Bson)this.queryObject.get(SORT_KEY)).maxTime(maxTime.longValue(), TimeUnit.MILLISECONDS).collation(collation);
                this.iterator = mapReduceIterable.iterator();
            }
        } else if (this.queryObject.containsField(RUN_AGGREGATE_KEY)) {
            Object commandValue = this.queryObject.get(RUN_AGGREGATE_KEY);
            ArrayList commandObject = new ArrayList(((BasicDBList)commandValue).size());
            ((BasicDBList)commandValue).forEach(command -> commandObject.add((Bson)command));
            AggregateIterable aggregateIterable = collection.aggregate(commandObject, BasicDBObject.class).batchSize(batchSize.intValue()).maxTime(maxTime.longValue(), TimeUnit.MILLISECONDS).collation(collation);
            this.iterator = aggregateIterable.iterator();
        } else {
            FindIterable findIterable = collection.find((Bson)findQueryObject, BasicDBObject.class).projection((Bson)this.queryObject.get(FIND_FIELDS_KEY)).limit(limitValue.intValue()).collation(collation).batchSize(batchSize.intValue()).maxTime(maxTime.longValue(), TimeUnit.MILLISECONDS).sort((Bson)this.queryObject.get(SORT_KEY));
            this.iterator = findIterable.iterator();
        }
    }

    private Integer processInteger(Object value) {
        try {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            return Integer.parseInt((String)value);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public String validateProperty(BasicDBObject object, String name) throws JRException {
        Object value = object.get(name);
        if (value == null) {
            throw new JRException(name + " can't be null");
        }
        return String.valueOf(value);
    }
}

