/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.customvisualization;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.preferences.util.PreferencesUtils;
import java.io.IOException;
import java.util.Properties;
import net.sf.jasperreports.eclipse.AbstractJRUIPlugin;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.osgi.framework.BundleContext;

public class CustomVisualizationActivator
extends AbstractJRUIPlugin {
    public static final String PLUGIN_ID = "com.jaspersoft.studio.components.customvisualization";
    public static final String JAVA_PATH_PROPERTY = "com.jaspersoft.studio.components.customvisualization.javapath";
    public static final String SCRIPTS_PATH = "net.sf.jasperreports.web.resource.pattern.customvisualization.scripts";
    private static CustomVisualizationActivator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static CustomVisualizationActivator getDefault() {
        return plugin;
    }

    public String getPluginID() {
        return PLUGIN_ID;
    }

    protected void postStartOperations() {
        try {
            this.initCustomVisualizationComponentProperties();
        }
        catch (IOException e) {
            this.logError(e);
        }
        try {
            Properties props = FileUtils.load((String)JaspersoftStudioPlugin.getInstance().getPreferenceStore().getString("net.sf.jasperreports.JRPROPERTIES"));
            String phantomJSPath = props.getProperty("com.jaspersoft.jasperreports.components.customvisualization.phantomjs.executable.path");
            if (phantomJSPath == null || phantomJSPath.isEmpty()) {
                props.put("com.jaspersoft.jasperreports.components.customvisualization.phantomjs.executable.path", "phantomjs");
                JaspersoftStudioPlugin.getInstance().getPreferenceStore().setValue("net.sf.jasperreports.JRPROPERTIES", FileUtils.getPropertyAsString((Properties)props));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logError(ex);
        }
    }

    private void initCustomVisualizationComponentProperties() throws IOException {
        String pathToRequireJs = this.getFileLocation("resources/scripts/require-2.1.6.src.js");
        while (pathToRequireJs.startsWith("/")) {
            pathToRequireJs = pathToRequireJs.substring(1);
        }
        pathToRequireJs = "file:/" + pathToRequireJs;
        PreferencesUtils.storeJasperReportsProperty((String)SCRIPTS_PATH, (String)"com/jaspersoft/jasperreports/customvisualization/resources/require/.*");
    }
}

