/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.customvisualization.creation.wizard;

import com.jaspersoft.studio.components.customvisualization.creation.ModuleDefinition;
import com.jaspersoft.studio.components.customvisualization.creation.ModuleManager;
import com.jaspersoft.studio.components.customvisualization.messages.Messages;
import com.jaspersoft.studio.wizards.JSSWizardPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CustomVisualizationComponentComboPage
extends JSSWizardPage {
    private Combo combo;
    private StyledText licenseLabel;
    private Text projectName;
    private ModifyListener nameModified = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            CustomVisualizationComponentComboPage.this.getContainer().updateButtons();
        }
    };

    protected CustomVisualizationComponentComboPage() {
        super("moduleSelector");
        this.setTitle("Modules Selection");
        this.setDescription("Select the modules and the folder name for your Custom Visualization prject");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Composite nameSection = new Composite(container, 0);
        GridData nameData = new GridData(768);
        nameData.horizontalSpan = 2;
        nameSection.setLayout((Layout)new GridLayout(2, false));
        nameSection.setLayoutData((Object)nameData);
        Label nameLabel = new Label(nameSection, 0);
        nameLabel.setText("Component Name");
        this.projectName = new Text(nameSection, 2048);
        this.projectName.setLayoutData((Object)new GridData(768));
        this.projectName.addModifyListener(this.nameModified);
        Composite comboContainer = new Composite(container, 0);
        comboContainer.setLayout((Layout)new GridLayout(2, false));
        comboContainer.setLayoutData((Object)new GridData(1040));
        new Label(comboContainer, 0).setText("Used library:");
        this.combo = new Combo(comboContainer, 8);
        GridData comboData = new GridData();
        comboData.widthHint = 200;
        this.combo.setLayoutData((Object)comboData);
        ArrayList<String> comboItems = new ArrayList<String>();
        List<ModuleDefinition> items = ModuleManager.getModules();
        comboItems.add("");
        this.combo.setData(items);
        for (ModuleDefinition def : items) {
            comboItems.add(def.getModuleVisualName());
        }
        this.combo.setItems(comboItems.toArray(new String[comboItems.size()]));
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectedIndex = CustomVisualizationComponentComboPage.this.combo.getSelectionIndex();
                if (selectedIndex > 0) {
                    ModuleDefinition module = ModuleManager.getModules().get(selectedIndex - 1);
                    CustomVisualizationComponentComboPage.this.licenseLabel.setText(ModuleManager.getLicenseFile(module));
                } else {
                    CustomVisualizationComponentComboPage.this.licenseLabel.setText("");
                }
            }
        });
        Group licenseGroup = new Group(container, 0);
        licenseGroup.setText("License");
        licenseGroup.setLayout((Layout)new GridLayout(1, false));
        licenseGroup.setLayoutData((Object)new GridData(1808));
        this.licenseLabel = new StyledText((Composite)licenseGroup, 576);
        this.licenseLabel.setBackground(container.getBackground());
        this.licenseLabel.setEditable(false);
        GridData licenseData = new GridData(1808);
        licenseData.widthHint = 50;
        this.licenseLabel.setLayoutData((Object)licenseData);
        this.setControl((Control)container);
    }

    protected String getContextName() {
        return null;
    }

    public ModuleDefinition getSelectedModule() {
        if (this.combo.getSelectionIndex() > 0) {
            List<ModuleDefinition> items = ModuleManager.getModules();
            return items.get(this.combo.getSelectionIndex() - 1);
        }
        return null;
    }

    public String getProjectName() {
        return this.projectName.getText();
    }

    public boolean isPageComplete() {
        if (this.combo.getSelectionIndex() == 0) {
            this.setErrorMessage(Messages.CustomVisualizationComponentTablePage_noLibraryError);
            return false;
        }
        if (this.projectName.getText().trim().isEmpty()) {
            this.setErrorMessage(Messages.CustomVisualizationComponentTablePage_errorEmpty);
            return false;
        }
        if (this.projectName.getText().contains(" ")) {
            this.setErrorMessage(Messages.CustomVisualizationComponentTablePage_noSpacesError);
            return false;
        }
        Path pathContainer = new Path(this.projectName.getText());
        if (!pathContainer.isValidPath(this.projectName.getText())) {
            this.setErrorMessage(Messages.CustomVisualizationComponentTablePage_errorInvalidGeneric);
            return false;
        }
        if (pathContainer.segmentCount() < 1) {
            this.setErrorMessage(Messages.CustomVisualizationComponentTablePage_errorEmpty);
            return false;
        }
        if (this.projectExists(pathContainer.segment(0))) {
            this.setErrorMessage(Messages.CustomVisualizationComponentTablePage_errorProjectExist);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected boolean projectExists(String projectName) {
        Path containerNamePath;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)(containerNamePath = new Path("/" + projectName)));
        if (resource == null) {
            return false;
        }
        return resource.exists();
    }
}

