/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.customvisualization.creation.wizard;

import com.jaspersoft.studio.components.customvisualization.creation.ModuleDefinition;
import com.jaspersoft.studio.components.customvisualization.creation.ModuleManager;
import com.jaspersoft.studio.components.customvisualization.messages.Messages;
import com.jaspersoft.studio.wizards.JSSWizardPage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class CustomVisualizationComponentLicensePage
extends JSSWizardPage {
    private SelectionAdapter comboSelected = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            CustomVisualizationComponentLicensePage.this.comboSelectionChange();
        }
    };
    private StyledText licenseLabel;
    private Combo libraryName;
    private ModuleDefinition currentModule = null;
    private HashSet<ModuleDefinition> downloadingLicenses = new HashSet();
    private HashMap<String, ModuleDefinition> usedModules = new HashMap();
    private boolean licensesAccepted = false;

    public CustomVisualizationComponentLicensePage() {
        super("licensePage");
        this.setTitle(Messages.CustomVisualizationComponentLicensePage_pageTitle);
        this.setDescription(Messages.CustomVisualizationComponentLicensePage_pageDescription);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.libraryName = new Combo(container, 8);
        this.libraryName.setLayoutData((Object)new GridData(768));
        this.libraryName.addSelectionListener((SelectionListener)this.comboSelected);
        Group licenseGroup = new Group(container, 0);
        licenseGroup.setText(Messages.CustomVisualizationComponentTablePage_licenseGroup);
        licenseGroup.setLayout((Layout)new GridLayout(1, false));
        licenseGroup.setLayoutData((Object)new GridData(1808));
        this.licenseLabel = new StyledText((Composite)licenseGroup, 576);
        this.licenseLabel.setBackground(container.getBackground());
        this.licenseLabel.setEditable(false);
        GridData licenseData = new GridData(1808);
        licenseData.widthHint = 200;
        this.licenseLabel.setLayoutData((Object)licenseData);
        final Button licenseButton = new Button(container, 32);
        licenseButton.setLayoutData((Object)new GridData(768));
        licenseButton.setText(Messages.CustomVisualizationComponentLicensePage_acceptLicensesButton);
        licenseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomVisualizationComponentLicensePage.this.licensesAccepted = licenseButton.getSelection();
                CustomVisualizationComponentLicensePage.this.getContainer().updateButtons();
            }
        });
        this.setControl((Control)container);
    }

    protected String getContextName() {
        return null;
    }

    public void setVisible(boolean visible) {
        ModuleDefinition selectedModule;
        super.setVisible(visible);
        if (visible && (selectedModule = (ModuleDefinition)this.getSettings().get("selectedModule")) != null && selectedModule != this.currentModule) {
            this.currentModule = selectedModule;
            this.fetchLicense(selectedModule);
            ArrayList<String> comboItems = new ArrayList<String>();
            this.usedModules.clear();
            this.findComboItems(selectedModule, comboItems);
            this.libraryName.setItems(comboItems.toArray(new String[comboItems.size()]));
            this.libraryName.select(0);
            this.comboSelectionChange();
        }
    }

    private void fetchLicense(ModuleDefinition module) {
        if (!ModuleManager.isLicenseLocal(module)) {
            LicenseDownloader downloader = new LicenseDownloader(module);
            this.downloadingLicenses.add(module);
            new Thread(downloader).start();
            for (ModuleDefinition dep : module.getRequiredLibraries()) {
                this.fetchLicense(dep);
            }
        }
    }

    private void findComboItems(ModuleDefinition module, List<String> result) {
        result.add(module.getLibraryFilename());
        this.usedModules.put(module.getLibraryFilename(), module);
        for (ModuleDefinition dep : module.getRequiredLibraries()) {
            this.findComboItems(dep, result);
        }
    }

    private void refreshLicenseText(final ModuleDefinition module, final String licenseText) {
        UIUtils.getDisplay().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap hashMap = CustomVisualizationComponentLicensePage.this.usedModules;
                synchronized (hashMap) {
                    if (CustomVisualizationComponentLicensePage.this.licenseLabel != null && !CustomVisualizationComponentLicensePage.this.licenseLabel.isDisposed() && CustomVisualizationComponentLicensePage.this.libraryName.getText().equals(module.getLibraryFilename())) {
                        CustomVisualizationComponentLicensePage.this.licenseLabel.setText(licenseText);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void comboSelectionChange() {
        ModuleDefinition selectedModule = this.usedModules.get(this.libraryName.getText());
        HashMap<String, ModuleDefinition> hashMap = this.usedModules;
        synchronized (hashMap) {
            if (selectedModule != null && this.licenseLabel != null && !this.licenseLabel.isDisposed()) {
                if (this.downloadingLicenses.contains(selectedModule) || ModuleManager.isLicenseLocal(selectedModule)) {
                    this.licenseLabel.setText(Messages.CustomVisualizationComponentLicensePage_downloadLabel);
                    if (!this.downloadingLicenses.contains(selectedModule)) {
                        LicenseDownloader downloader = new LicenseDownloader(selectedModule);
                        this.downloadingLicenses.add(selectedModule);
                        new Thread(downloader).start();
                    }
                } else {
                    this.licenseLabel.setText(ModuleManager.getLicenseFile(selectedModule));
                }
            }
        }
    }

    public boolean isPageComplete() {
        return this.licensesAccepted;
    }

    private class LicenseDownloader
    implements Runnable {
        private ModuleDefinition handledModule;

        public LicenseDownloader(ModuleDefinition handledModule) {
            this.handledModule = handledModule;
        }

        @Override
        public void run() {
            String license = ModuleManager.getLicenseFile(this.handledModule);
            CustomVisualizationComponentLicensePage.this.downloadingLicenses.remove(this.handledModule);
            CustomVisualizationComponentLicensePage.this.refreshLicenseText(this.handledModule, license);
        }
    }
}

