/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.customvisualization.creation.wizard;

import com.jaspersoft.studio.components.customvisualization.creation.ModuleDefinition;
import com.jaspersoft.studio.components.customvisualization.creation.ModuleManager;
import com.jaspersoft.studio.components.customvisualization.messages.Messages;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.wizards.JSSWizardPage;
import java.io.File;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class CustomVisualizationComponentListPage
extends JSSWizardPage {
    private TableViewer viewer;
    private Table list;
    private Text projectName;
    private ModuleLabelProvider labelProvider = new ModuleLabelProvider();
    private ModifyListener nameModified = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            CustomVisualizationComponentListPage.this.getContainer().updateButtons();
        }
    };
    private String module;
    private boolean createUI = false;
    private String uiLabel;
    private String uiDescription;
    private String uiIconPath;
    private Text tmodule;

    public CustomVisualizationComponentListPage() {
        super("moduleSelector");
        this.setTitle(Messages.CustomVisualizationComponentTablePage_pageTitle);
        this.setDescription(Messages.CustomVisualizationComponentTablePage_pageDescription);
    }

    public String getModule() {
        return this.module;
    }

    public boolean isCreateUI() {
        return this.createUI;
    }

    public String getUiLabel() {
        return this.uiLabel;
    }

    public String getUiDescription() {
        return this.uiDescription;
    }

    public String getUiIconPath() {
        return this.uiIconPath;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(container, 0);
        nameLabel.setText(Messages.CustomVisualizationComponentTablePage_projectName);
        this.projectName = new Text(container, 2048);
        this.projectName.setLayoutData((Object)new GridData(768));
        this.projectName.addModifyListener(this.nameModified);
        Label lbl = new Label(container, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        lbl.setLayoutData((Object)gd);
        lbl = new Label(container, 0);
        lbl.setText(Messages.CustomVisualizationComponentListPage_0);
        this.tmodule = new Text(container, 2048);
        this.tmodule.setLayoutData((Object)new GridData(768));
        this.tmodule.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CustomVisualizationComponentListPage.this.module = CustomVisualizationComponentListPage.this.tmodule.getText();
                CustomVisualizationComponentListPage.this.getContainer().updateButtons();
            }
        });
        lbl = new Label(container, 0);
        lbl.setText(Messages.CustomVisualizationComponentListPage_1);
        gd = new GridData();
        gd.horizontalSpan = 2;
        lbl.setLayoutData((Object)gd);
        this.viewer = new TableViewer(container, 2048);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.list = this.viewer.getTable();
        GridData tableData = new GridData(1808);
        tableData.widthHint = 250;
        tableData.horizontalSpan = 2;
        this.list.setLayoutData((Object)tableData);
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, 250, false));
        this.list.setLayout((Layout)tlayout);
        this.list.setHeaderVisible(false);
        TableColumn[] column = new TableColumn[]{new TableColumn(this.list, 0)};
        column[0].setText(Messages.CustomVisualizationComponentTablePage_nameCol);
        int i = 0;
        int n = column.length;
        while (i < n) {
            column[i].pack();
            ++i;
        }
        this.attachCellEditors();
        List<ModuleDefinition> modules = ModuleManager.getModules();
        this.viewer.setInput(modules);
        if (!modules.isEmpty()) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)modules.get(0)), true);
        }
        UIUtil.createSeparator((Composite)container, (int)2);
        final Button bUI = new Button(container, 32);
        bUI.setText(Messages.CustomVisualizationComponentListPage_2);
        gd = new GridData();
        gd.horizontalSpan = 2;
        bUI.setLayoutData((Object)gd);
        bUI.setSelection(this.createUI);
        final Composite cmp = new Composite(container, 0);
        cmp.setLayout((Layout)new GridLayout(3, false));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        cmp.setLayoutData((Object)gd);
        lbl = new Label(cmp, 0);
        lbl.setText(Messages.CustomVisualizationComponentListPage_3);
        final Text tLabel = new Text(cmp, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        tLabel.setLayoutData((Object)gd);
        tLabel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CustomVisualizationComponentListPage.this.uiLabel = tLabel.getText();
                CustomVisualizationComponentListPage.this.getContainer().updateButtons();
            }
        });
        lbl = new Label(cmp, 0);
        lbl.setText(Messages.CustomVisualizationComponentListPage_4);
        final Text tdesc = new Text(cmp, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        tdesc.setLayoutData((Object)gd);
        tdesc.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CustomVisualizationComponentListPage.this.uiDescription = tdesc.getText();
                CustomVisualizationComponentListPage.this.getContainer().updateButtons();
            }
        });
        lbl = new Label(cmp, 0);
        lbl.setText(Messages.CustomVisualizationComponentListPage_5);
        final Text ticon = new Text(cmp, 2048);
        ticon.setLayoutData((Object)new GridData(768));
        ticon.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CustomVisualizationComponentListPage.this.uiIconPath = ticon.getText();
                CustomVisualizationComponentListPage.this.getContainer().updateButtons();
            }
        });
        Button btnBrowse = new Button(cmp, 8);
        btnBrowse.setText("...");
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                FileDialog fd = new FileDialog(UIUtils.getShell());
                fd.setFileName(ticon.getText());
                fd.setFilterPath(root.getLocation().toOSString());
                fd.setFilterExtensions(new String[]{"png", "jpeg", "JPG", "*.*"});
                String selection = fd.open();
                if (selection != null) {
                    ticon.setText(selection);
                }
            }
        });
        this.enableCustomUI(bUI, cmp);
        bUI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomVisualizationComponentListPage.this.enableCustomUI(bUI, cmp);
                CustomVisualizationComponentListPage.this.getContainer().updateButtons();
            }
        });
        this.setControl((Control)container);
    }

    private void attachCellEditors() {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModuleDefinition selectedElement = CustomVisualizationComponentListPage.this.getSelectedModule();
                if (selectedElement != null) {
                    CustomVisualizationComponentListPage.this.getSettings().put("selectedModule", selectedElement);
                    CustomVisualizationComponentListPage.this.tmodule.setText(selectedElement.getModuleName());
                } else {
                    CustomVisualizationComponentListPage.this.getSettings().remove("selectedModule");
                }
                CustomVisualizationComponentListPage.this.getContainer().updateButtons();
            }
        });
    }

    protected String getContextName() {
        return null;
    }

    public ModuleDefinition getSelectedModule() {
        StructuredSelection ss;
        ISelection selection = this.viewer.getSelection();
        if (selection != null && selection instanceof StructuredSelection && !(ss = (StructuredSelection)selection).isEmpty()) {
            return (ModuleDefinition)ss.getFirstElement();
        }
        return null;
    }

    public String getProjectName() {
        return this.projectName.getText();
    }

    public boolean isPageComplete() {
        if (this.projectName.getText().trim().isEmpty()) {
            this.setErrorMessage(Messages.CustomVisualizationComponentTablePage_errorEmpty);
            return false;
        }
        if (this.projectName.getText().contains(" ")) {
            this.setErrorMessage(Messages.CustomVisualizationComponentTablePage_noSpacesError);
            return false;
        }
        Path pathContainer = new Path(this.projectName.getText());
        if (!pathContainer.isValidPath(this.projectName.getText())) {
            this.setErrorMessage(Messages.CustomVisualizationComponentTablePage_errorInvalidGeneric);
            return false;
        }
        if (pathContainer.segmentCount() < 1) {
            this.setErrorMessage(Messages.CustomVisualizationComponentTablePage_errorEmpty);
            return false;
        }
        if (this.projectExists(pathContainer.segment(0))) {
            this.setErrorMessage(Messages.CustomVisualizationComponentTablePage_errorProjectExist);
            return false;
        }
        if (Misc.isNullOrEmpty((String)this.module)) {
            this.setErrorMessage(Messages.CustomVisualizationComponentListPage_10);
            return false;
        }
        if (!CustomVisualizationComponentListPage.isValidJavaIdentifier(this.module)) {
            this.setErrorMessage(Messages.CustomVisualizationComponentListPage_11);
            return false;
        }
        if (this.createUI) {
            if (Misc.isNullOrEmpty((String)this.uiLabel)) {
                this.setErrorMessage(Messages.CustomVisualizationComponentListPage_12);
                return false;
            }
            if (Misc.isNullOrEmpty((String)this.uiDescription)) {
                this.setErrorMessage(Messages.CustomVisualizationComponentListPage_13);
                return false;
            }
            if (!Misc.isNullOrEmpty((String)this.uiIconPath) && !new File(this.uiIconPath).exists()) {
                this.setErrorMessage(Messages.CustomVisualizationComponentListPage_14);
                return false;
            }
        }
        if (this.getSelectedModule() == null) {
            this.setErrorMessage(Messages.CustomVisualizationComponentTablePage_noLibraryError);
            return false;
        }
        this.setMessage(this.getDescription());
        this.setErrorMessage(null);
        if (this.createUI && Misc.isNullOrEmpty((String)this.uiIconPath)) {
            this.setMessage(Messages.CustomVisualizationComponentListPage_15, 2);
        }
        return true;
    }

    public static boolean isValidJavaIdentifier(String s) {
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < s.length()) {
            if (!Character.isJavaIdentifierPart(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean projectExists(String projectName) {
        Path containerNamePath;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)(containerNamePath = new Path("/" + projectName)));
        if (resource == null) {
            return false;
        }
        return resource.exists();
    }

    public boolean canFlipToNextPage() {
        boolean hasLibrary = this.hasLibraryPage();
        if (!hasLibrary) {
            return false;
        }
        return super.canFlipToNextPage();
    }

    protected boolean hasLibraryPage() {
        ModuleDefinition selected = this.getSelectedModule();
        if (selected != null) {
            boolean hasLibrary = selected.getLibraryFilename() != null;
            for (ModuleDefinition dependency : selected.getRequiredLibraries()) {
                if (hasLibrary) break;
                boolean bl = hasLibrary = dependency.getLibraryFilename() != null;
            }
            return hasLibrary;
        }
        return true;
    }

    protected void enableCustomUI(Button bUI, Composite cmp) {
        this.createUI = bUI.getSelection();
        Control[] controlArray = cmp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Label) {
                if (this.createUI) {
                    c.setForeground(UIUtils.getDisplay().getSystemColor(30));
                } else {
                    c.setForeground(UIUtils.getDisplay().getSystemColor(33));
                }
            }
            c.setEnabled(this.createUI);
            ++n2;
        }
    }

    private class ModuleLabelProvider
    extends LabelProvider {
        private ModuleLabelProvider() {
        }

        public String getText(Object element) {
            return ((ModuleDefinition)element).getModuleVisualName();
        }
    }
}

