/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.customvisualization.properties;

import com.jaspersoft.studio.components.customvisualization.properties.ItemPropertiesUtil;
import com.jaspersoft.studio.components.customvisualization.ui.framework.CVCWidgetsDescriptor;
import com.jaspersoft.studio.components.customvisualization.ui.framework.DatasetPropertyDescriptor;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.itemproperty.desc.ADescriptor;
import com.jaspersoft.studio.property.itemproperty.desc.AItemDataListPropertyDescriptor;
import com.jaspersoft.studio.property.itemproperty.dialog.AItemDialog;
import com.jaspersoft.studio.property.itemproperty.dialog.ItemDataDialog;
import com.jaspersoft.studio.property.itemproperty.label.ItemLabelProvider;
import com.jaspersoft.studio.property.itemproperty.sp.ItemDataListContentProvider;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.StandardItem;
import net.sf.jasperreports.components.items.StandardItemData;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SPCVCItemDataList
extends ASPropertyWidget<AItemDataListPropertyDescriptor>
implements IExpressionContextSetter {
    private ExpressionContext expContext;
    protected TreeViewer dsTViewer;
    private Button btnAddNewDataset;
    private Button btnModifyDataset;
    private Button btnRemoveDataset;
    private Composite dsParent;
    protected List<ItemData> itemDatas;
    private Button btnUpDataset;
    private Button btnDownDataset;
    protected APropertyNode pnode;
    private CVCWidgetsDescriptor cd;
    private Composite datasetsCmp;
    ItemLabelProvider itemDataLabelProvider;
    private ItemPropertiesUtil putil;

    public SPCVCItemDataList(Composite parent, AbstractSection section, AItemDataListPropertyDescriptor pDescriptor) {
        super(parent, section, (IPropertyDescriptor)pDescriptor);
        this.putil = new ItemPropertiesUtil((AItemDataListPropertyDescriptor)this.pDescriptor, this.section){

            @Override
            public int getSelectedItemDataIndex() {
                StructuredSelection sel = null;
                sel = (StructuredSelection)SPCVCItemDataList.this.dsTViewer.getSelection();
                Object obj = sel.getFirstElement();
                if (obj instanceof ItemData) {
                    return this.itemDatas.indexOf(obj);
                }
                if (obj instanceof Item) {
                    Item item = (Item)obj;
                    for (ItemData id : this.itemDatas) {
                        List items = id.getItems();
                        if (Misc.isNullOrEmpty((Collection)items)) continue;
                        for (Item it : items) {
                            if (it != item) continue;
                            return this.itemDatas.indexOf(id);
                        }
                    }
                }
                if (!Misc.isNullOrEmpty((Collection)this.itemDatas)) {
                    return 0;
                }
                return -1;
            }

            @Override
            protected void setElementSelection(ItemData itemData, Item item) {
                SPCVCItemDataList.this.setElementSelection(itemData, item);
            }
        };
    }

    private ADescriptor getDescriptor() {
        return ((AItemDataListPropertyDescriptor)this.pDescriptor).getDescriptor();
    }

    protected void createComponent(Composite parent) {
        this.dsParent = this.section.getWidgetFactory().createComposite(parent);
        this.dsParent.setLayout((Layout)new GridLayout(2, false));
        this.createDatasetsTab(this.dsParent);
    }

    protected ViewerComparator getElementViewerComparator() {
        return null;
    }

    private void handleEditElement(TreeViewer tviewer) {
        StructuredSelection sel = (StructuredSelection)tviewer.getSelection();
        Object obj = sel.getFirstElement();
        if (sel == null || obj == null) {
            return;
        }
        if (obj instanceof StandardItem) {
            List clones = JRCloneUtils.cloneList(this.itemDatas);
            StandardItemData itemData = (StandardItemData)this.getStandardItemData(false, tviewer, this.itemDatas);
            StandardItemData itemDataClone = (StandardItemData)this.getStandardItemData(false, tviewer, clones);
            int ind = itemData.getItems().indexOf((StandardItem)obj);
            if (ind >= 0) {
                StandardItem item = (StandardItem)itemDataClone.getItems().get(ind);
                this.showItemDialog(clones, itemDataClone, item);
            }
        } else if (obj instanceof StandardItemData) {
            List clones = JRCloneUtils.cloneList(this.itemDatas);
            StandardItemData itemData = (StandardItemData)this.getStandardItemData(false, tviewer, this.itemDatas);
            StandardItemData itemDataClone = (StandardItemData)this.getStandardItemData(false, tviewer, clones);
            ItemDataDialog dialog = new ItemDataDialog(UIUtils.getShell(), this.itemDataLabelProvider.getText4ItemData((ItemData)itemData), "", clones, itemDataClone, this.section.getJasperReportsContext(), this.getDescriptor(), this.expContext, this.pnode){

                protected AItemDialog createItemDialog() {
                    return SPCVCItemDataList.this.createItemDialog();
                }
            };
            if (dialog.open() == 0) {
                this.section.changeProperty(((AItemDataListPropertyDescriptor)this.pDescriptor).getId(), new ArrayList(clones));
            }
        }
    }

    private void handleDeleteElement(TreeViewer tviewer) {
        List clones = JRCloneUtils.cloneList(this.itemDatas);
        StructuredSelection sel = (StructuredSelection)tviewer.getSelection();
        for (Object obj : sel.toList()) {
            if (sel == null || obj == null) continue;
            if (obj instanceof StandardItem) {
                StandardItem item = (StandardItem)obj;
                StandardItemData itemData = (StandardItemData)this.getStandardItemData(false, tviewer, this.itemDatas);
                if (itemData == null) continue;
                StandardItemData itemDataClone = (StandardItemData)this.getStandardItemData(false, tviewer, clones);
                int ind = itemData.getItems().indexOf(item);
                if (ind < 0 || itemData.getItems().isEmpty()) continue;
                itemDataClone.removeItem((Item)itemDataClone.getItems().get(ind));
                continue;
            }
            if (!(obj instanceof StandardItemData)) continue;
            StandardItemData itemData = (StandardItemData)obj;
            StandardItemData itemDataClone = (StandardItemData)this.getStandardItemData(false, tviewer, clones);
            int ind = this.itemDatas.indexOf(itemData);
            if (ind < 0) continue;
            clones.remove(itemDataClone);
        }
        this.section.changeProperty(((AItemDataListPropertyDescriptor)this.pDescriptor).getId(), new ArrayList(clones));
    }

    protected void handleNewElement(TreeViewer tviewer) {
        List clones = JRCloneUtils.cloneList(this.itemDatas);
        StandardItemData itemData = new StandardItemData();
        clones.add(itemData);
        ItemDataDialog dialog = new ItemDataDialog(UIUtils.getShell(), this.itemDataLabelProvider.getText4ItemData((ItemData)itemData), "", clones, itemData, this.section.getJasperReportsContext(), this.getDescriptor(), this.expContext, this.pnode){

            protected AItemDialog createItemDialog() {
                return SPCVCItemDataList.this.createItemDialog();
            }
        };
        if (dialog.open() == 0) {
            this.section.changeProperty(((AItemDataListPropertyDescriptor)this.pDescriptor).getId(), new ArrayList(clones));
        }
    }

    protected void showItemDialog(List<ItemData> citemsData, StandardItemData itemData, StandardItem item) {
        this.putil.showItemDialog(citemsData, itemData, item, this.expContext);
    }

    protected AItemDialog createItemDialog() {
        return this.putil.createItemDialog();
    }

    private ItemData getStandardItemData(boolean createNew, TreeViewer tviewer, List<ItemData> clones) {
        IStructuredSelection sel = (IStructuredSelection)this.dsTViewer.getSelection();
        Object fe = sel.getFirstElement();
        if (fe != null) {
            if (fe instanceof StandardItemData) {
                return clones.get(this.itemDatas.indexOf((StandardItemData)fe));
            }
            if (fe instanceof StandardItem) {
                for (ItemData sid : this.itemDatas) {
                    for (Item it : sid.getItems()) {
                        if (it != fe) continue;
                        return clones.get(this.itemDatas.indexOf(sid));
                    }
                }
            }
        } else if (!Misc.isNullOrEmpty(this.itemDatas)) {
            return (StandardItemData)clones.get(0);
        }
        return createNew ? new StandardItemData() : null;
    }

    private void setElementSelection(final ItemData itemData, final Item item) {
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SPCVCItemDataList.this.dsTViewer.expandToLevel((Object)itemData, 1);
                if (item != null) {
                    SPCVCItemDataList.this.dsTViewer.setSelection((ISelection)new StructuredSelection((Object)item), true);
                } else {
                    SPCVCItemDataList.this.dsTViewer.setSelection((ISelection)new StructuredSelection((Object)itemData), true);
                }
            }
        });
    }

    private void createDatasetsTab(Composite parent) {
        this.datasetsCmp = this.section.getWidgetFactory().createComposite(parent);
        this.datasetsCmp.setLayout((Layout)new GridLayout(2, false));
        this.datasetsCmp.setLayoutData((Object)new GridData(1808));
        this.dsTViewer = new TreeViewer(this.datasetsCmp, 2818);
        Tree tree = this.dsTViewer.getTree();
        GridData gd = new GridData(1808);
        gd.verticalSpan = 5;
        tree.setLayoutData((Object)gd);
        this.createDsLabelProvider();
        this.dsTViewer.setContentProvider((IContentProvider)new ItemDataListContentProvider(true){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof ItemData) {
                    return new Object[0];
                }
                return super.getChildren(parentElement);
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.dsTViewer, (int)2);
        this.dsTViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SPCVCItemDataList.this.enableDefaultDatasetsButtons();
            }
        });
        this.dsTViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SPCVCItemDataList.this.handleEditElement(SPCVCItemDataList.this.dsTViewer);
            }
        });
        this.btnAddNewDataset = this.section.getWidgetFactory().createButton(this.datasetsCmp, Messages.SPItemdDataList_0, 0);
        this.btnAddNewDataset.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnAddNewDataset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPCVCItemDataList.this.handleNewElement(SPCVCItemDataList.this.dsTViewer);
            }
        });
        this.btnModifyDataset = this.section.getWidgetFactory().createButton(this.datasetsCmp, Messages.SPItemDataList_1, 0);
        this.btnModifyDataset.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnModifyDataset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPCVCItemDataList.this.handleEditElement(SPCVCItemDataList.this.dsTViewer);
            }
        });
        this.btnRemoveDataset = this.section.getWidgetFactory().createButton(this.datasetsCmp, Messages.SPItemDataList_2, 0);
        this.btnRemoveDataset.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnRemoveDataset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPCVCItemDataList.this.handleDeleteElement(SPCVCItemDataList.this.dsTViewer);
            }
        });
        this.btnUpDataset = this.section.getWidgetFactory().createButton(this.datasetsCmp, Messages.SPItemDataList_0, 0);
        this.btnUpDataset.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnUpDataset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPCVCItemDataList.this.handleUpElement(SPCVCItemDataList.this.dsTViewer);
            }
        });
        this.btnDownDataset = this.section.getWidgetFactory().createButton(this.datasetsCmp, Messages.SPItemDataList_4, 0);
        this.btnDownDataset.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnDownDataset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPCVCItemDataList.this.handleDownElement(SPCVCItemDataList.this.dsTViewer);
            }
        });
        this.enableDefaultDatasetsButtons();
    }

    protected void createDsLabelProvider() {
        this.itemDataLabelProvider = new ItemLabelProvider(this.getDescriptor()){

            public Image getImage(Object element) {
                return null;
            }

            public String getText4ItemData(ItemData element) {
                if (SPCVCItemDataList.this.cd != null && !Misc.isNullOrEmpty(SPCVCItemDataList.this.cd.getDatasets())) {
                    int indx = SPCVCItemDataList.this.itemDatas.indexOf(element);
                    int c = 0;
                    for (DatasetPropertyDescriptor cdd : SPCVCItemDataList.this.cd.getDatasets()) {
                        int card = cdd.getCardinality();
                        if (card > 0) {
                            c += card;
                        } else if (card <= 0) {
                            if (!cdd.getSections().isEmpty()) {
                                return SPCVCItemDataList.this.cd.getLocalizedString(cdd.getSections().get(Math.max(0, Math.min(indx - c, cdd.getSections().size() - 1))).getName());
                            }
                            return SPCVCItemDataList.this.cd.getLocalizedString(cdd.getLabel());
                        }
                        if (c <= indx) continue;
                        if (!cdd.getSections().isEmpty()) {
                            return SPCVCItemDataList.this.cd.getLocalizedString(cdd.getSections().get(Math.max(0, Math.min(indx - c, cdd.getSections().size() - 1))).getName());
                        }
                        return SPCVCItemDataList.this.cd.getLocalizedString(cdd.getLabel());
                    }
                }
                return "Item Data " + (SPCVCItemDataList.this.itemDatas.indexOf(element) + 1);
            }
        };
        this.dsTViewer.setLabelProvider((IBaseLabelProvider)this.itemDataLabelProvider);
    }

    private void handleUpElement(TreeViewer tviewer) {
        this.moveItem(true);
    }

    private void handleDownElement(TreeViewer tviewer) {
        this.moveItem(false);
    }

    protected JRPropertyChangeSupport getComponentEventSupport(JRDesignComponentElement jrElement) {
        Component c = jrElement.getComponent();
        if (c instanceof JRChangeEventsSupport) {
            return ((JRChangeEventsSupport)c).getEventSupport();
        }
        return null;
    }

    private void moveItem(boolean up) {
        StructuredSelection selection = (StructuredSelection)this.dsTViewer.getSelection();
        if (selection == null) {
            return;
        }
        Object sel = selection.getFirstElement();
        if (sel instanceof Item) {
            Item item = (Item)sel;
            JRPropertyChangeSupport es = this.getComponentEventSupport((JRDesignComponentElement)this.pnode.getValue());
            for (ItemData id : this.itemDatas) {
                int size;
                List items = id.getItems();
                if (Misc.isNullOrEmpty((Collection)items) || (size = items.size()) <= 1) continue;
                int i = 0;
                while (i < size) {
                    if (items.get(i) == item) {
                        int ind = items.indexOf(item);
                        int newind = up ? Math.max(0, ind - 1) : Math.min(items.size() - 1, ind + 1);
                        Item tmp = (Item)items.get(newind);
                        items.set(newind, item);
                        items.set(ind, tmp);
                        if (es != null) {
                            es.fireIndexedPropertyChange((String)((AItemDataListPropertyDescriptor)this.pDescriptor).getId(), newind, (Object)tmp, (Object)item);
                        }
                        this.dsTViewer.refresh(true);
                        this.btnUpDataset.setEnabled(newind > 0);
                        this.btnDownDataset.setEnabled(newind < size - 1);
                        this.setElementSelection(id, item);
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    public void setData(APropertyNode pnode, Object value) {
        Object expContextAdapter;
        this.pnode = pnode;
        this.itemDatas = (List)value;
        this.putil.setPnode(pnode);
        this.putil.setItemDatas(this.itemDatas);
        this.cd = this.putil.getComponentDescriptor();
        if (this.cd != null && Misc.isNullOrEmpty(this.cd.getDatasets()) && !this.datasetsCmp.isDisposed()) {
            this.datasetsCmp.dispose();
            this.dsParent.layout(true);
        }
        if (this.cd != null && !Misc.isNullOrEmpty(this.cd.getDatasets()) && this.datasetsCmp.isDisposed()) {
            this.createDatasetsTab(this.dsParent);
            this.dsParent.layout(true);
        }
        if (this.cd == null && this.datasetsCmp.isDisposed()) {
            this.createDatasetsTab(this.dsParent);
            this.dsParent.layout(true);
        }
        if (this.datasetsCmp.isDisposed()) {
            return;
        }
        this.dsTViewer.setInput(this.itemDatas);
        this.getDescriptor().setItemDatas(this.itemDatas, pnode);
        JRDesignElement designEl = null;
        if (pnode.getValue() instanceof JRDesignElement) {
            designEl = (JRDesignElement)pnode.getValue();
        }
        if ((expContextAdapter = pnode.getAdapter(ExpressionContext.class)) != null) {
            this.setExpressionContext((ExpressionContext)expContextAdapter);
        } else {
            this.setExpressionContext(ModelUtils.getElementExpressionContext((JRDesignElement)designEl, (ANode)pnode));
        }
        this.dsTViewer.expandAll();
        this.dsTViewer.refresh(true);
        if (this.dsTViewer.getSelection().isEmpty() && !this.itemDatas.isEmpty()) {
            this.dsTViewer.setSelection((ISelection)new StructuredSelection((Object)this.itemDatas.get(0)));
        }
        this.enableDefaultDatasetsButtons();
    }

    private void enableDefaultDatasetsButtons() {
        this.btnAddNewDataset.setEnabled(true);
        StructuredSelection selection = (StructuredSelection)this.dsTViewer.getSelection();
        this.btnModifyDataset.setEnabled(!selection.isEmpty());
        this.btnRemoveDataset.setEnabled(!selection.isEmpty());
        this.btnUpDataset.setEnabled(!selection.isEmpty());
        this.btnDownDataset.setEnabled(!selection.isEmpty());
        if (this.cd != null) {
            int qte = 0;
            for (DatasetPropertyDescriptor cdd : this.cd.getDatasets()) {
                if (cdd.getCardinality() < 0) {
                    qte = -1;
                    break;
                }
                qte += cdd.getCardinality();
            }
            if (qte >= 0) {
                this.btnAddNewDataset.setEnabled(this.itemDatas.size() < qte);
            }
        }
        for (Object sel : selection.toList()) {
            List<DatasetPropertyDescriptor> ds;
            if (sel instanceof Item) {
                Item item = (Item)sel;
                for (ItemData id : this.itemDatas) {
                    int size;
                    List items = id.getItems();
                    if (Misc.isNullOrEmpty((Collection)items) || (size = items.size()) <= 1) continue;
                    int i = 0;
                    while (i < size) {
                        if (items.get(i) == item) {
                            this.btnUpDataset.setEnabled(i > 0);
                            this.btnDownDataset.setEnabled(i < size - 1);
                            return;
                        }
                        ++i;
                    }
                }
                continue;
            }
            if (!(sel instanceof ItemData)) continue;
            int indx = this.itemDatas.indexOf((ItemData)sel);
            if (this.cd == null || (ds = this.cd.getDatasets()).size() <= 0) continue;
            int c = 0;
            if (this.btnAddNewDataset.isEnabled()) {
                int i = 0;
                while (i < ds.size()) {
                    DatasetPropertyDescriptor cdd = ds.get(i);
                    int card = cdd.getCardinality();
                    if (card > 0) {
                        c += card;
                    }
                    if (i >= indx && (card <= 0 || c <= indx + 1)) break;
                    ++i;
                }
            }
            if (!this.btnRemoveDataset.isEnabled() || ds.isEmpty()) continue;
            DatasetPropertyDescriptor cdd = ds.get(ds.size() - 1);
            this.btnRemoveDataset.setEnabled(cdd.getCardinality() <= 0 || c < this.itemDatas.size());
        }
        if (this.cd != null) {
            this.btnUpDataset.setEnabled(false);
            this.btnDownDataset.setEnabled(false);
        }
    }

    public Control getControl() {
        return this.dsParent;
    }

    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }
}

