/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.customvisualization.properties;

import com.jaspersoft.studio.components.customvisualization.messages.Messages;
import com.jaspersoft.studio.components.customvisualization.model.CVItemDataDescriptor;
import com.jaspersoft.studio.components.customvisualization.properties.CVItemDataDialog;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.swt.widgets.NumberedLabelProvider;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.List;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SPCVItemDataList
extends ASPropertyWidget<CVItemDataDescriptor> {
    private TableViewer itemDataTV;
    private Button btnAddItemData;
    private Button btnModifyItemData;
    private Button btnRemoveItemData;
    private Group itemDataGrp;
    private List<ItemData> itemDataElements;
    private NumberedLabelProvider lblProv;

    public SPCVItemDataList(Composite parent, AbstractSection section, CVItemDataDescriptor pDescriptor) {
        super(parent, section, (IPropertyDescriptor)pDescriptor);
    }

    protected void createComponent(Composite parent) {
        this.itemDataGrp = new Group(parent, 0);
        this.itemDataGrp.setLayout((Layout)new GridLayout(2, false));
        this.itemDataGrp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.itemDataTV = this.createItemDataTable(this.itemDataGrp);
        this.itemDataTV.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SPCVItemDataList.this.modifyItemDataBtnPressed();
            }
        });
        this.btnAddItemData = new Button((Composite)this.itemDataGrp, 8);
        this.btnAddItemData.setText(Messages.SPCVItemDataList_Add);
        this.btnAddItemData.setLayoutData((Object)new GridData(4, 128, false, false));
        this.btnAddItemData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPCVItemDataList.this.addNewItemDataBtnPressed();
            }
        });
        this.btnModifyItemData = new Button((Composite)this.itemDataGrp, 8);
        this.btnModifyItemData.setText(Messages.SPCVItemDataList_Edit);
        this.btnModifyItemData.setLayoutData((Object)new GridData(4, 128, false, false));
        this.btnModifyItemData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPCVItemDataList.this.modifyItemDataBtnPressed();
            }
        });
        this.btnRemoveItemData = new Button((Composite)this.itemDataGrp, 8);
        this.btnRemoveItemData.setText(Messages.SPCVItemDataList_Remove);
        this.btnRemoveItemData.setLayoutData((Object)new GridData(4, 128, false, false));
        this.btnRemoveItemData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPCVItemDataList.this.removeItemDataBtnPressed();
            }
        });
    }

    private TableViewer createItemDataTable(Group parent) {
        TableViewer itemDataTV = new TableViewer((Composite)parent, 2564);
        itemDataTV.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.lblProv = new NumberedLabelProvider(Messages.SPCVItemDataList_LblProviderPrefix);
        itemDataTV.setLabelProvider((IBaseLabelProvider)this.lblProv);
        itemDataTV.setContentProvider((IContentProvider)new ArrayContentProvider());
        return itemDataTV;
    }

    private void addNewItemDataBtnPressed() {
        CVItemDataDialog dialog = new CVItemDataDialog(UIUtils.getShell(), null, this.section.getElement().getJasperConfiguration());
        dialog.setDefaultExpressionContext(this.getExpressionContext());
        if (dialog.open() == 0) {
            ItemData CVItemData = dialog.getCVItemData();
            this.itemDataElements.add(CVItemData);
            this.section.changeProperty((Object)"itemData", this.itemDataElements);
        }
    }

    private void modifyItemDataBtnPressed() {
        ItemData i = this.getCurrentSelectedItemData();
        if (i != null) {
            ItemData clonedItemData = (ItemData)i.clone();
            CVItemDataDialog dialog = new CVItemDataDialog(UIUtils.getShell(), clonedItemData, this.section.getElement().getJasperConfiguration());
            dialog.setDefaultExpressionContext(this.getExpressionContext());
            if (dialog.open() == 0) {
                ItemData CVItemData = dialog.getCVItemData();
                int indexOf = this.itemDataElements.indexOf(i);
                this.itemDataElements.remove(indexOf);
                this.itemDataElements.add(indexOf, CVItemData);
                this.section.changeProperty((Object)"itemData", this.itemDataElements);
            }
        }
    }

    private void removeItemDataBtnPressed() {
        ItemData i = this.getCurrentSelectedItemData();
        if (i != null) {
            this.itemDataElements.remove(i);
            this.section.changeProperty((Object)"itemData", this.itemDataElements);
        }
    }

    private ItemData getCurrentSelectedItemData() {
        Object selEl = ((IStructuredSelection)this.itemDataTV.getSelection()).getFirstElement();
        if (selEl instanceof ItemData) {
            return (ItemData)selEl;
        }
        return null;
    }

    public void setData(APropertyNode pnode, Object value) {
        this.itemDataElements = (List)value;
        this.itemDataTV.setInput(this.itemDataElements);
        this.lblProv.resetIndex();
    }

    public Control getControl() {
        return this.itemDataGrp;
    }

    private ExpressionContext getExpressionContext() {
        return ModelUtils.getElementExpressionContext(null, (ANode)this.section.getElement());
    }
}

