/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.customvisualization.ui;

import com.jaspersoft.studio.components.customvisualization.CustomVisualizationActivator;
import com.jaspersoft.studio.components.customvisualization.messages.Messages;
import com.jaspersoft.studio.components.customvisualization.model.MCustomVisualization;
import com.jaspersoft.studio.components.customvisualization.ui.ComponentDescriptor;
import com.jaspersoft.studio.components.customvisualization.ui.framework.CVCWidgetsDescriptor;
import com.jaspersoft.studio.components.customvisualization.ui.framework.CVCWidgetsDescriptorResolver;
import com.jaspersoft.studio.model.util.ItemPropertyUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.eclipse.IDisposeListener;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.util.ResourceBundleMessageProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;

public class UIManager {
    private static Map<String, CVCWidgetsDescriptor> cachePlugin;
    private static Map<JasperReportsConfiguration, Map<String, CVCWidgetsDescriptor>> cache;
    private static Map<CVCWidgetsDescriptor, Image> imageCache;
    private static Map<CVCWidgetsDescriptor, String> parentsPath;
    private static IResourceChangeListener listener;
    private static final CVCWidgetsDescriptorResolver RESOLVER;
    private static Map<CVCWidgetsDescriptor, ResourceBundleMessageProvider> rbMap;

    static {
        cache = new HashMap<JasperReportsConfiguration, Map<String, CVCWidgetsDescriptor>>();
        imageCache = new HashMap<CVCWidgetsDescriptor, Image>();
        parentsPath = new HashMap<CVCWidgetsDescriptor, String>();
        listener = new ResourceChangeReporter();
        RESOLVER = new CVCWidgetsDescriptorResolver();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(listener, 7);
        rbMap = new HashMap<CVCWidgetsDescriptor, ResourceBundleMessageProvider>();
    }

    public static CVCWidgetsDescriptor getComponentDescriptor(MCustomVisualization model) {
        String module;
        ItemProperty p;
        List props = model.getComponent().getItemProperties();
        if (props != null && (p = ItemPropertyUtil.getProperty((List)props, (String)"module")) != null && !Misc.isNullOrEmpty((String)(module = ItemPropertyUtil.getItemPropertyString((StandardItemProperty)((StandardItemProperty)p), null)))) {
            return UIManager.getDescriptor(model.getJasperConfiguration(), module);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static void copyFile(CVCWidgetsDescriptor cd, JasperReportsConfiguration jConf, String path) {
        if (Misc.isNullOrEmpty((String)path)) {
            return;
        }
        f = (IFile)jConf.get("ifile");
        if (f == null) {
            return;
        }
        destFolder = f.getParent();
        is = null;
        try {
            dest = new File(destFolder.getLocation().toOSString(), path);
            UIManager.getDescriptor(jConf, cd.getModule());
            uri = UIManager.parentsPath.get((Object)cd);
            if (uri == null) ** GOTO lbl19
            url = new URL(String.valueOf(uri) + path);
            if (url.sameFile(dest.toURI().toURL())) {
                return;
            }
            try {
                is = url.openStream();
lbl19:
                // 2 sources

                if (is != null) {
                    org.apache.commons.io.FileUtils.copyInputStreamToFile(is, (File)dest);
                    destFolder.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        finally {
            FileUtils.closeStream(is);
        }
    }

    public static Image getThumbnail(CVCWidgetsDescriptor cd) {
        Image img;
        block7: {
            img = imageCache.get((Object)cd);
            if (img == null && !Misc.isNullOrEmpty((String)cd.getThumbnail())) {
                try {
                    InputStream is;
                    String uri = parentsPath.get((Object)cd);
                    if (uri == null || (is = new URL(String.valueOf(uri) + cd.getThumbnail()).openStream()) == null) break block7;
                    try {
                        img = new Image(null, is);
                        imageCache.put(cd, img);
                    }
                    finally {
                        FileUtils.closeStream((Closeable)is);
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return img;
    }

    public static String getProperty(CVCWidgetsDescriptor cd, String key) {
        String uri = parentsPath.get((Object)cd);
        if (uri != null) {
            try {
                ResourceBundleMessageProvider rbmp = rbMap.get((Object)cd);
                if (rbmp == null && !rbMap.containsKey((Object)cd)) {
                    URLClassLoader cl = new URLClassLoader(new URL[]{new URI(uri).toURL()});
                    rbmp = new ResourceBundleMessageProvider(cd.getModule(), (ClassLoader)cl);
                    rbMap.put(cd, rbmp);
                }
                try {
                    key = rbmp.getMessage(key, Locale.getDefault());
                }
                catch (MissingResourceException missingResourceException) {}
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return key;
    }

    public static List<CVCWidgetsDescriptor> getModules(JasperReportsConfiguration jConfig) {
        ArrayList<CVCWidgetsDescriptor> res = new ArrayList<CVCWidgetsDescriptor>();
        if (cachePlugin == null) {
            UIManager.initCachePlugin();
        }
        res.addAll(cachePlugin.values());
        Map<String, CVCWidgetsDescriptor> modules = UIManager.initCacheJConfig(jConfig);
        res.addAll(modules.values());
        return res;
    }

    public static CVCWidgetsDescriptor getDescriptor(JasperReportsConfiguration jConfig, String module) {
        CVCWidgetsDescriptor d;
        if (cachePlugin == null) {
            UIManager.initCachePlugin();
        }
        if ((d = cachePlugin.get(module)) != null) {
            return d;
        }
        Map<String, CVCWidgetsDescriptor> modules = cache.get(jConfig);
        if (modules == null) {
            modules = UIManager.initCacheJConfig(jConfig);
        }
        return modules.get(module);
    }

    protected static CustomVisualizationActivator initCachePlugin() {
        if (cachePlugin == null) {
            cachePlugin = new HashMap<String, CVCWidgetsDescriptor>();
        }
        CustomVisualizationActivator activator = CustomVisualizationActivator.getDefault();
        Enumeration en = activator.getBundle().findEntries("components", "*.json", true);
        while (en != null && en.hasMoreElements()) {
            URL url = (URL)en.nextElement();
            try {
                CVCWidgetsDescriptor cd = RESOLVER.resolveURL(url);
                if (cd == null) continue;
                cachePlugin.put(cd.getModule(), cd);
                String purl = url.toURI().toASCIIString();
                int indx = purl.lastIndexOf("/");
                if (indx == -1) continue;
                purl = purl.substring(0, indx + 1);
                parentsPath.put(cd, purl);
            }
            catch (Exception ex) {
                activator.log((IStatus)new Status(4, "com.jaspersoft.studio.components.customvisualization", MessageFormat.format(Messages.UIManager_2, url), (Throwable)ex));
            }
        }
        return activator;
    }

    protected static Map<String, CVCWidgetsDescriptor> initCacheJConfig(final JasperReportsConfiguration jConf) {
        Map<String, CVCWidgetsDescriptor> modules = cache.get(jConf);
        if (modules == null) {
            modules = new HashMap<String, CVCWidgetsDescriptor>();
            cache.put(jConf, modules);
            jConf.getPrefStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("com.jaspersoft.studio.cvc.resource.paths")) {
                        for (CVCWidgetsDescriptor cd : ((Map)cache.get(jConf)).values()) {
                            imageCache.remove((Object)cd);
                            parentsPath.remove((Object)cd);
                        }
                        cache.remove(jConf);
                        UIManager.initCacheJConfig(jConf);
                    }
                }
            });
            jConf.getPropertyChangeSupport().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(java.beans.PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("preferences") && evt.getNewValue() instanceof java.beans.PropertyChangeEvent && (evt = (java.beans.PropertyChangeEvent)evt.getNewValue()).getPropertyName().equals("com.jaspersoft.studio.cvc.resource.paths")) {
                        for (CVCWidgetsDescriptor cd : ((Map)cache.get(jConf)).values()) {
                            imageCache.remove((Object)cd);
                            parentsPath.remove((Object)cd);
                        }
                        cache.remove(jConf);
                        UIManager.initCacheJConfig(jConf);
                    }
                }
            });
            jConf.addDisposeListener(new IDisposeListener(){

                public void dispose() {
                    Map map = (Map)cache.get(jConf);
                    if (map != null) {
                        for (CVCWidgetsDescriptor cd : map.values()) {
                            Image img = (Image)imageCache.get((Object)cd);
                            if (img != null) {
                                img.dispose();
                            }
                            imageCache.remove((Object)cd);
                            parentsPath.remove((Object)cd);
                        }
                    }
                    cache.remove(jConf);
                }
            });
            String paths = jConf.getPrefStore().getString("com.jaspersoft.studio.cvc.resource.paths");
            StringTokenizer st = new StringTokenizer(paths, String.valueOf(File.pathSeparator) + "\n\r");
            LinkedHashSet<String> pathsList = new LinkedHashSet<String>();
            while (st.hasMoreTokens()) {
                pathsList.add(st.nextToken());
            }
            for (String dir : pathsList) {
                File[] files = new File(dir).listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.getName().endsWith(".json");
                    }
                });
                if (files == null) continue;
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    URL url = null;
                    try {
                        url = f.toURI().toURL();
                        CVCWidgetsDescriptor cd = RESOLVER.resolveURL(url);
                        if (cd != null) {
                            modules.put(cd.getModule(), cd);
                            parentsPath.put(cd, f.getParentFile().toURI().toASCIIString());
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                    }
                    catch (Exception ex) {
                        CustomVisualizationActivator.getDefault().log((IStatus)new Status(4, "com.jaspersoft.studio.components.customvisualization", MessageFormat.format(Messages.UIManager_2, url), (Throwable)ex));
                    }
                    ++n2;
                }
            }
        }
        return modules;
    }

    public static boolean isInPlugin(ComponentDescriptor cd) {
        return cachePlugin.values().contains(cd);
    }

    public static class ResourceChangeReporter
    implements IResourceChangeListener {
        private boolean checkInPaths(IResourceDelta rd) {
            if (rd.getFullPath() != null && rd.getResource() != null && rd.getResource().getRawLocationURI() != null) {
                String rpath = rd.getResource().getRawLocationURI().toASCIIString();
                for (String path : parentsPath.values()) {
                    if (path.startsWith("bundle") || rpath.startsWith(path)) continue;
                    return false;
                }
                imageCache.clear();
                parentsPath.clear();
                rbMap.clear();
                cache.clear();
                if (cachePlugin != null) {
                    cachePlugin.clear();
                }
                UIManager.initCachePlugin();
            }
            return true;
        }

        private void checkResource(IResourceDelta[] children) {
            IResourceDelta[] iResourceDeltaArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta rd = iResourceDeltaArray[n2];
                if (!Misc.isNullOrEmpty((Object[])rd.getAffectedChildren())) {
                    this.checkResource(rd.getAffectedChildren());
                } else if (this.checkInPaths(rd)) {
                    return;
                }
                ++n2;
            }
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                this.checkResource(delta.getAffectedChildren());
            }
        }
    }
}

