/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.customvisualization.ui.framework;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jaspersoft.studio.components.customvisualization.ui.ComponentDatasetDescriptor;
import com.jaspersoft.studio.components.customvisualization.ui.ComponentDescriptor;
import com.jaspersoft.studio.components.customvisualization.ui.ComponentPropertyDescriptor;
import com.jaspersoft.studio.components.customvisualization.ui.ComponentSectionDescriptor;
import com.jaspersoft.studio.components.customvisualization.ui.framework.CVCWidgetsDescriptor;
import com.jaspersoft.studio.components.customvisualization.ui.framework.DatasetPropertyDescriptor;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.manager.IWidgetsDescriptorResolver;
import com.jaspersoft.studio.widgets.framework.model.SectionPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;

public class CVCWidgetsDescriptorResolver
implements IWidgetsDescriptorResolver {
    public WidgetsDescriptor loadDescriptor(JasperReportsConfiguration jConfig, String URL2) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new URL(URL2).openStream(), "UTF-8"));
            mapper.configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
            ComponentDescriptor loadedValue = (ComponentDescriptor)mapper.readValue((Reader)in, ComponentDescriptor.class);
            return this.convertValue(loadedValue);
        }
        catch (JsonParseException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (JsonMappingException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (IOException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (Throwable e) {
            UIUtils.showError((Throwable)e);
        }
        return null;
    }

    public CVCWidgetsDescriptor resolveURL(URL URL2) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(URL2.openStream(), "UTF-8"));
            mapper.configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
            ComponentDescriptor loadedValue = (ComponentDescriptor)mapper.readValue((Reader)in, ComponentDescriptor.class);
            return this.convertValue(loadedValue);
        }
        catch (JsonParseException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (JsonMappingException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (IOException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (Throwable e) {
            UIUtils.showError((Throwable)e);
        }
        return null;
    }

    public CVCWidgetsDescriptor convertValue(ComponentDescriptor oldValue) {
        CVCWidgetsDescriptor result = new CVCWidgetsDescriptor();
        result.setLabel(oldValue.getLabel());
        result.setModule(oldValue.getModule());
        result.setDescription(oldValue.getDescription());
        result.setThumbnail(oldValue.getThumbnail());
        if (oldValue.getSections() != null) {
            for (ComponentSectionDescriptor oldSection : oldValue.getSections()) {
                SectionPropertyDescriptor section = this.convertSection(oldSection);
                result.getSections().add(section);
            }
        }
        if (oldValue.getDatasets() != null) {
            for (ComponentDatasetDescriptor oldDataset : oldValue.getDatasets()) {
                DatasetPropertyDescriptor dataset = new DatasetPropertyDescriptor();
                dataset.setCardinality(oldDataset.getCardinality());
                dataset.setLabel(oldDataset.getLabel());
                for (ComponentSectionDescriptor oldSection : oldDataset.getSections()) {
                    SectionPropertyDescriptor section = this.convertSection(oldSection);
                    dataset.getSections().add(section);
                }
                result.getDatasets().add(dataset);
            }
        }
        return result;
    }

    private SectionPropertyDescriptor convertSection(ComponentSectionDescriptor oldSection) {
        SectionPropertyDescriptor section = new SectionPropertyDescriptor();
        section.setName(oldSection.getName());
        section.setExpandable(oldSection.isExpandable());
        for (ComponentPropertyDescriptor oldWidget : oldSection.getProperties()) {
            WidgetPropertyDescriptor widget = this.convertWidget(oldWidget);
            section.getProperties().add(widget);
        }
        return section;
    }

    private WidgetPropertyDescriptor convertWidget(ComponentPropertyDescriptor oldWidget) {
        WidgetPropertyDescriptor widget = new WidgetPropertyDescriptor();
        widget.setDefaultValue(oldWidget.getDefaultValue());
        widget.setLabel(oldWidget.getLabel());
        widget.setDescription(oldWidget.getDescription());
        widget.setMandatory(oldWidget.isMandatory());
        widget.setMax(oldWidget.getMax());
        widget.setMin(oldWidget.getMin());
        widget.setName(oldWidget.getName());
        widget.setReadOnly(oldWidget.isReadOnly());
        widget.setType(this.getType(oldWidget));
        widget.setComboOptions(this.getOptions(oldWidget));
        widget.setFallbackValue(null);
        return widget;
    }

    protected String getType(ComponentPropertyDescriptor oldWidget) {
        if ("color".equals(oldWidget.getType()) && oldWidget.isTransparent()) {
            return "transparent_color";
        }
        return oldWidget.getType();
    }

    protected String[][] getOptions(ComponentPropertyDescriptor oldWidget) {
        String[] oldOptions = oldWidget.getOptions();
        if (oldOptions != null) {
            String[][] result = new String[oldOptions.length][2];
            int i = 0;
            while (i < oldOptions.length) {
                result[i][0] = oldOptions[i];
                result[i][1] = oldOptions[i];
                ++i;
            }
            return result;
        }
        return oldWidget.getOptions2();
    }

    public String getKey(JasperReportsConfiguration jConfig, String URL2) {
        return URL2;
    }

    public boolean unloadOnConfigurationDispose() {
        return false;
    }
}

