/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.map.ui;

import com.jaspersoft.studio.widgets.map.MapActivator;
import com.jaspersoft.studio.widgets.map.browserfunctions.GMapEnabledFunction;
import com.jaspersoft.studio.widgets.map.core.LatLng;
import com.jaspersoft.studio.widgets.map.core.MapType;
import com.jaspersoft.studio.widgets.map.core.Marker;
import com.jaspersoft.studio.widgets.map.messages.Messages;
import com.jaspersoft.studio.widgets.map.support.BaseJavaMapSupport;
import com.jaspersoft.studio.widgets.map.support.GMapUtils;
import com.jaspersoft.studio.widgets.map.support.JavaMapSupport;
import com.jaspersoft.studio.widgets.map.ui.MapTile;
import com.jaspersoft.studio.widgets.map.ui.MapUIUtils;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BasicInfoMapDialog
extends PersistentLocationDialog {
    protected LatLng mapCenter;
    protected int zoomLevel;
    protected MapType mapType;
    protected MapTile map;
    protected String address;
    protected Text addressBar;
    private String title;

    public BasicInfoMapDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title == null ? "" : this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.createContent(container);
        return container;
    }

    protected void createContent(Composite parent) {
        this.createMap(parent);
    }

    protected void createMap(Composite container) {
        Composite mainCmp = new Composite(container, 0);
        GridLayout cmpGL = new GridLayout(3, false);
        cmpGL.verticalSpacing = 10;
        mainCmp.setLayout((Layout)cmpGL);
        mainCmp.setLayoutData((Object)new GridData(4, 4, true, true));
        Label addressLbl = new Label(mainCmp, 0);
        addressLbl.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        addressLbl.setText(Messages.BasicInfoMapDialog_AddressLookup);
        this.addressBar = new Text(mainCmp, 2048);
        this.addressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addressBar.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    e.detail = 0;
                    BasicInfoMapDialog.this.locateAddress(BasicInfoMapDialog.this.addressBar.getText());
                }
            }
        });
        this.addressBar.setText(this.address == null ? "" : this.address);
        CLabel findBtn = new CLabel(mainCmp, 0);
        findBtn.setImage(MapActivator.getDefault().getImageRegistry().get("FIND_BTN"));
        findBtn.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                BasicInfoMapDialog.this.locateAddress(BasicInfoMapDialog.this.addressBar.getText());
            }
        });
        findBtn.setCursor(UIUtils.getDisplay().getSystemCursor(21));
        if (Util.isLinux()) {
            Composite warningCmp = MapUIUtils.createLinuxWarningText(mainCmp);
            warningCmp.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        }
        this.map = new MapTile(mainCmp, 2048);
        this.map.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        this.configureMapTile();
        this.map.activateMapTile();
    }

    protected void configureMapTile() {
        this.map.configureJavaSupport(new BaseJavaMapSupport(this.map.getMapControl()){

            @Override
            public void setZoomLevel(int newZoomLevel) {
                BasicInfoMapDialog.this.setZoomLevel(newZoomLevel);
            }

            @Override
            public void setMapCenter(LatLng position) {
                BasicInfoMapDialog.this.setMapCenter(position);
            }

            @Override
            public void setMapType(MapType mapType) {
                BasicInfoMapDialog.this.setMapType(mapType);
            }
        });
        this.map.getFunctions().add(new InitialConfigurationFunction(this.map.getMapControl(), "javaCall_InitialConfiguration", this.map.getJavaMapSupport()));
    }

    protected Object initConfigurationFunction(Object[] arguments) {
        return null;
    }

    private void locateAddress(String addressText) {
        LatLng coords = GMapUtils.getAddressCoordinates(addressText);
        if (coords != null) {
            this.centerMap(coords);
            this.address = addressText;
        } else {
            MessageDialog.openError((Shell)UIUtils.getShell(), (String)Messages.BasicInfoMapDialog_LocationErrorTitle, (String)Messages.BasicInfoMapDialog_LocationErrorMsg);
        }
    }

    private void centerMap(LatLng coords) {
        this.setMapCenter(coords);
        this.map.getJavascriptMapSupport().evaluateJavascript("myMap.panTo(new google.maps.LatLng(" + coords.getLat() + "," + coords.getLng() + "));");
        this.addCenterMarker(coords);
    }

    protected void addCenterMarker(LatLng coords) {
        this.map.getJavascriptMapSupport().clearMarkers();
        this.map.getJavascriptMapSupport().addNewMarker(new Marker(coords));
        this.map.getJavascriptMapSupport().evaluateJavascript("myMap.mapMarkers[0].setDraggable(false);");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(800, 600);
    }

    protected boolean isResizable() {
        return true;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
        if (this.addressBar != null) {
            this.addressBar.setText(address);
        }
    }

    public LatLng getMapCenter() {
        return this.mapCenter;
    }

    public void setMapCenter(LatLng mapCenter) {
        this.mapCenter = mapCenter;
        this.updateTitle();
    }

    public MapType getMapType() {
        return this.mapType;
    }

    public void setMapType(MapType mapType) {
        this.mapType = mapType;
        this.updateTitle();
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
        this.updateTitle();
    }

    private void updateTitle() {
        if (this.mapCenter != null && this.zoomLevel != 0 && this.mapType != null) {
            this.title = NLS.bind((String)Messages.BasicInfoMapDialog_Title, (Object[])new Object[]{String.format("%.6f", this.mapCenter.getLat()), String.format("%.6f", this.mapCenter.getLng()), String.valueOf(this.zoomLevel), this.mapType});
            Shell shell = this.getShell();
            if (shell != null) {
                shell.setText(this.title);
            }
        }
    }

    class InitialConfigurationFunction
    extends GMapEnabledFunction {
        public InitialConfigurationFunction(Browser browser, String name, JavaMapSupport mapSupport) {
            super(browser, name, mapSupport);
        }

        public Object function(Object[] arguments) {
            BasicInfoMapDialog.this.initConfigurationFunction(arguments);
            BasicInfoMapDialog.this.map.getJavascriptMapSupport().setZoomLevel(BasicInfoMapDialog.this.getZoomLevel());
            BasicInfoMapDialog.this.map.getJavascriptMapSupport().setMapType(BasicInfoMapDialog.this.mapType != null ? BasicInfoMapDialog.this.mapType : MapType.ROADMAP);
            if (BasicInfoMapDialog.this.mapCenter == null || BasicInfoMapDialog.this.mapCenter.getLat() == null || BasicInfoMapDialog.this.mapCenter.getLat() == null) {
                LatLng coords;
                if (BasicInfoMapDialog.this.address != null && !BasicInfoMapDialog.this.address.isEmpty() && (coords = GMapUtils.getAddressCoordinates(BasicInfoMapDialog.this.address)) != null) {
                    BasicInfoMapDialog.this.centerMap(coords);
                }
            } else {
                BasicInfoMapDialog.this.centerMap(BasicInfoMapDialog.this.mapCenter);
            }
            return null;
        }
    }
}

