/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.map.ui;

import com.jaspersoft.studio.utils.NumberValidator;
import com.jaspersoft.studio.widgets.map.MapActivator;
import com.jaspersoft.studio.widgets.map.browserfunctions.GMapEnabledFunction;
import com.jaspersoft.studio.widgets.map.core.LatLng;
import com.jaspersoft.studio.widgets.map.core.MapType;
import com.jaspersoft.studio.widgets.map.support.BaseJavaMapSupport;
import com.jaspersoft.studio.widgets.map.support.GMapUtils;
import com.jaspersoft.studio.widgets.map.support.JavaMapSupport;
import com.jaspersoft.studio.widgets.map.ui.MapTile;
import com.jaspersoft.studio.widgets.map.ui.MapUIUtils;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GMapsCenterPanel {
    protected MapTile map;
    protected LatLng mapCenter = new LatLng(45.439722, 12.331944);
    protected int zoomLevel = 12;
    protected MapType mapType = MapType.ROADMAP;
    protected String address;
    protected Text addressBar;
    private boolean centering = false;
    protected boolean initMarkers = false;
    protected Text tlon;
    protected Text tlat;
    protected boolean refreshing = false;
    private boolean initialised = false;

    public GMapsCenterPanel(Composite parent, int style) {
        this.createContent(parent, style);
    }

    protected void createContent(Composite parent, int style) {
        this.createTop(parent);
        if (Util.isLinux()) {
            Composite warningCmp = MapUIUtils.createLinuxWarningText(parent);
            warningCmp.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        }
        this.createMap(parent);
        UIUtils.getDisplay().asyncExec(() -> this.map.activateMapTile());
    }

    protected void createMap(Composite parent) {
        this.map = new MapTile(parent, 0, MapActivator.getFileLocation("mapfiles/gmaps_library/map2.html"));
        this.map.configureJavaSupport(new DetailsPanelMapSupport(this.map.getMapControl()));
        this.map.getFunctions().add(new InitialConfigurationFunction(this.map.getMapControl(), "javaCall_InitialConfiguration", this.map.getJavaMapSupport()));
        if (parent.getLayout() instanceof GridLayout) {
            this.map.setLayoutData(new GridData(1808));
        }
    }

    protected void createTop(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(7, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginRight = -5;
        cmp.setLayout((Layout)layout);
        if (parent.getLayout() instanceof GridLayout) {
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            cmp.setLayoutData((Object)gd);
        }
        final Text tadr = new Text(cmp, 2688);
        tadr.setMessage("Address");
        GridData gd = new GridData(768);
        tadr.setLayoutData((Object)gd);
        tadr.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                GMapsCenterPanel.this.doAddressChanged(tadr);
            }
        });
        tadr.addTraverseListener(e -> {
            if (e.detail == 4 || e.keyCode == 13) {
                this.doAddressChanged(tadr);
                e.doit = false;
            }
        });
        tadr.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String txt = tadr.getText();
                if (!Misc.isNullOrEmpty((String)txt) && !txt.equals(GMapsCenterPanel.this.address)) {
                    GMapsCenterPanel.this.doAddressChanged(tadr);
                }
            }
        });
        Label lbl = new Label(cmp, 0);
        lbl.setText("Latitude");
        this.tlat = new Text(cmp, 2048);
        gd = new GridData();
        gd.widthHint = 100;
        this.tlat.setLayoutData((Object)gd);
        this.tlat.addVerifyListener((VerifyListener)new NumberValidator((Number)new Float("-85"), (Number)new Float("85"), Float.class));
        this.tlat.addTraverseListener(e -> {
            if (e.detail == 4 || e.keyCode == 13) {
                this.doLatChange(tadr);
                e.doit = false;
            }
        });
        this.tlat.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String txt = GMapsCenterPanel.this.tlat.getText();
                if (!Misc.isNullOrEmpty((String)txt) && GMapsCenterPanel.this.mapCenter != null && GMapsCenterPanel.this.mapCenter.getLat() != null && !txt.equals(String.format("%.7f", GMapsCenterPanel.this.mapCenter.getLat()))) {
                    GMapsCenterPanel.this.doLatChange(tadr);
                }
            }
        });
        lbl = new Label(cmp, 0);
        lbl.setText("Longitude");
        this.tlon = new Text(cmp, 2048);
        gd = new GridData();
        gd.widthHint = 100;
        this.tlon.setLayoutData((Object)gd);
        this.tlon.addVerifyListener((VerifyListener)new NumberValidator((Number)new Float("-180"), (Number)new Float("180"), Float.class));
        this.tlon.addTraverseListener(e -> {
            if (e.detail == 4 || e.keyCode == 13) {
                this.doLonChange(tadr);
                e.doit = false;
            }
        });
        this.tlon.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String txt = GMapsCenterPanel.this.tlon.getText();
                if (!Misc.isNullOrEmpty((String)txt) && GMapsCenterPanel.this.mapCenter != null && GMapsCenterPanel.this.mapCenter.getLng() != null && !txt.equals(String.format("%.7f", GMapsCenterPanel.this.mapCenter.getLng()))) {
                    GMapsCenterPanel.this.doLonChange(tadr);
                }
            }
        });
    }

    public void initMap() {
    }

    protected void centerMap(LatLng coords) {
        if (coords == null) {
            return;
        }
        LatLng lastCoords = coords;
        if (this.centering) {
            return;
        }
        this.centering = true;
        try {
            this.setMapCenter(lastCoords);
            lastCoords = null;
            System.out.println(this.mapCenter.toJsString());
            this.tlon.setText(String.format("%.7f", this.mapCenter.getLng()));
            this.tlat.setText(String.format("%.7f", this.mapCenter.getLat()));
            this.map.getJavascriptMapSupport().evaluateJavascript("myMap.panTo(" + this.mapCenter.toJsString() + "); ");
        }
        finally {
            this.centering = false;
            this.centerMap(lastCoords);
        }
    }

    protected void handleMapTypeChanged(MapType mapType) {
    }

    protected void handleMapZoomChanged(int newZoomLevel) {
    }

    protected void handleMapCenterChanged(LatLng position) {
        if (this.refreshing) {
            return;
        }
        this.refreshing = true;
        try {
            this.tlon.setText(String.format("%.7f", position.getLng()));
            this.tlat.setText(String.format("%.7f", position.getLat()));
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void handleAddressChanged(String address) {
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
        if (this.addressBar != null) {
            this.addressBar.setText(address);
        }
    }

    public LatLng getMapCenter() {
        return this.mapCenter;
    }

    public void setMapCenter(LatLng mapCenter) {
        this.mapCenter = mapCenter;
    }

    public MapType getMapType() {
        return this.mapType;
    }

    public void setMapType(MapType mapType) {
        this.mapType = mapType;
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    public void refresh() {
        this.initMap();
        this.initMarkers = true;
        try {
            if (!this.initialised) {
                this.map.getJavascriptMapSupport().setZoomLevel(this.getZoomLevel());
                this.map.getJavascriptMapSupport().setMapType(this.mapType != null ? this.mapType : MapType.ROADMAP);
                if (this.mapCenter == null || this.mapCenter.getLat() == null || this.mapCenter.getLng() == null) {
                    LatLng coords;
                    if (this.address != null && !this.address.isEmpty() && (coords = GMapUtils.getAddressCoordinates(this.address)) != null) {
                        this.centerMap(coords);
                    }
                } else {
                    this.centerMap(this.mapCenter);
                }
                this.initialised = true;
            }
            this.postInitMap();
        }
        finally {
            this.initMarkers = false;
        }
    }

    protected void postInitMap() {
        this.map.getJavascriptMapSupport().evaluateJavascript("MENU_KIND=_MENU_MINIMAL");
    }

    protected void doAddressChanged(Text tadr) {
        this.refreshing = true;
        try {
            LatLng coords = GMapUtils.getAddressCoordinates(tadr.getText());
            if (coords != null) {
                this.centerMap(coords);
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void doLatChange(Text tadr) {
        if (this.refreshing || this.centering) {
            return;
        }
        String txt = this.tlat.getText();
        if (txt.isEmpty()) {
            return;
        }
        this.refreshing = true;
        try {
            Double d = Double.valueOf(txt);
            this.centerMap(new LatLng(d, this.mapCenter.getLng()));
            this.address = null;
            tadr.setText("");
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void doLonChange(Text tadr) {
        if (this.refreshing || this.centering) {
            return;
        }
        String txt = this.tlon.getText();
        if (txt.isEmpty()) {
            return;
        }
        this.refreshing = true;
        try {
            Double d = Double.valueOf(txt);
            this.centerMap(new LatLng(this.mapCenter.getLat(), d));
            this.address = null;
            tadr.setText("");
        }
        finally {
            this.refreshing = false;
        }
    }

    protected class DetailsPanelMapSupport
    extends BaseJavaMapSupport {
        DetailsPanelMapSupport(Browser browser) {
            super(browser);
        }

        @Override
        public void setMapType(MapType mapType) {
            if (GMapsCenterPanel.this.initMarkers) {
                return;
            }
            super.setMapType(mapType);
            GMapsCenterPanel.this.handleMapTypeChanged(mapType);
        }

        @Override
        public void setZoomLevel(int newZoomLevel) {
            if (GMapsCenterPanel.this.initMarkers) {
                return;
            }
            super.setZoomLevel(newZoomLevel);
            GMapsCenterPanel.this.handleMapZoomChanged(newZoomLevel);
        }

        @Override
        public void setMapCenter(LatLng position) {
            if (GMapsCenterPanel.this.initMarkers) {
                return;
            }
            super.setMapCenter(position);
            GMapsCenterPanel.this.handleMapCenterChanged(position);
        }
    }

    class InitialConfigurationFunction
    extends GMapEnabledFunction {
        public InitialConfigurationFunction(Browser browser, String name, JavaMapSupport mapSupport) {
            super(browser, name, mapSupport);
        }

        public Object function(Object[] arguments) {
            GMapsCenterPanel.this.refresh();
            return null;
        }
    }
}

