/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.map.ui;

import com.jaspersoft.studio.widgets.map.browserfunctions.AddNewMarker;
import com.jaspersoft.studio.widgets.map.browserfunctions.ClearMarkersList;
import com.jaspersoft.studio.widgets.map.browserfunctions.GMapEnabledFunction;
import com.jaspersoft.studio.widgets.map.browserfunctions.RemoveMarker;
import com.jaspersoft.studio.widgets.map.browserfunctions.UpdateMarkerPosition;
import com.jaspersoft.studio.widgets.map.core.LatLng;
import com.jaspersoft.studio.widgets.map.core.Marker;
import com.jaspersoft.studio.widgets.map.messages.Messages;
import com.jaspersoft.studio.widgets.map.support.BaseJavaMapSupport;
import com.jaspersoft.studio.widgets.map.support.GMapUtils;
import com.jaspersoft.studio.widgets.map.support.JavaMapSupport;
import com.jaspersoft.studio.widgets.map.ui.MapTile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

@Deprecated
public class GMapsDetailsPanel {
    private List markersList;
    private Text addressLocation;
    private Button goToBtn;
    private Scale mapZoom;
    private Label zoomLevelLbl;
    private Label mapCenterCoordinatesLbl;
    private MapTile map;

    public GMapsDetailsPanel(Composite parent, int style) {
        SashForm sash = new SashForm(parent, style | 0x100);
        if (parent.getLayout() instanceof GridLayout) {
            sash.setLayoutData((Object)new GridData(1808));
        }
        this.map = new MapTile((Composite)sash, 0);
        this.map.configureJavaSupport(new DetailsPanelMapSupport(this.map.getMapControl()));
        this.map.getFunctions().add(new AddNewMarker(this.map.getMapControl(), "javaCall_AddMarker", this.map.getJavaMapSupport()));
        this.map.getFunctions().add(new ClearMarkersList(this.map.getMapControl(), "javaCall_ClearMarkers", this.map.getJavaMapSupport()));
        this.map.getFunctions().add(new RemoveMarker(this.map.getMapControl(), "javaCall_DelMarker", this.map.getJavaMapSupport()));
        this.map.getFunctions().add(new UpdateMarkerPosition(this.map.getMapControl(), "javaCall_UpdateMarkerPosition", this.map.getJavaMapSupport()));
        this.map.getFunctions().add(new InitialConfigurationFunction(this.map.getMapControl(), "javaCall_InitialConfiguration", this.map.getJavaMapSupport()));
        Composite containerCmp = new Composite((Composite)sash, 2048);
        containerCmp.setLayout((Layout)new GridLayout(1, true));
        Label mapCenterLbl = new Label(containerCmp, 0);
        mapCenterLbl.setText(Messages.GMapsDetailsPanel_MapCenterLbl);
        this.mapCenterCoordinatesLbl = new Label(containerCmp, 0);
        this.mapCenterCoordinatesLbl.setText(Messages.GMapsDetailsPanel_NoCoordinates);
        this.mapCenterCoordinatesLbl.setLayoutData((Object)new GridData(4, 4, true, false));
        Label addressLocationLbl = new Label(containerCmp, 0);
        addressLocationLbl.setText(Messages.GMapsDetailsPanel_AddressLookup);
        Group searchGrp = new Group(containerCmp, 2048);
        searchGrp.setLayout((Layout)new GridLayout(2, false));
        searchGrp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.addressLocation = new Text((Composite)searchGrp, 2048);
        this.addressLocation.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.goToBtn = new Button((Composite)searchGrp, 8);
        this.goToBtn.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 2, 1));
        this.goToBtn.setText(Messages.GMapsDetailsPanel_FindBtn);
        this.goToBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LatLng coords = GMapUtils.getAddressCoordinates(GMapsDetailsPanel.this.addressLocation.getText());
                if (coords != null) {
                    GMapsDetailsPanel.this.map.getJavascriptMapSupport().evaluateJavascript("myMap.panTo(new google.maps.LatLng(" + coords.getLat() + "," + coords.getLng() + "));");
                    GMapsDetailsPanel.this.map.getJavascriptMapSupport().evaluateJavascript("myMap.addMarker(new google.maps.LatLng(" + coords.getLat() + "," + coords.getLng() + "));");
                } else {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.GMapsDetailsPanel_LocationErrorTitle, (String)Messages.GMapsDetailsPanel_LocationErrorMsg);
                }
            }
        });
        this.zoomLevelLbl = new Label(containerCmp, 0);
        this.zoomLevelLbl.setText(Messages.GMapsDetailsPanel_ZoomLbl1);
        this.zoomLevelLbl.setLayoutData((Object)new GridData(4, 4, true, false));
        this.mapZoom = new Scale(containerCmp, 0);
        this.mapZoom.setMinimum(0);
        this.mapZoom.setMaximum(19);
        this.mapZoom.setIncrement(1);
        this.mapZoom.setLayoutData((Object)new GridData(4, 4, true, false));
        this.mapZoom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GMapsDetailsPanel.this.map.getJavascriptMapSupport().evaluateJavascript("JAVA_TO_JAVASCRIPT_CALLED=true");
                GMapsDetailsPanel.this.map.getJavascriptMapSupport().setZoomLevel(GMapsDetailsPanel.this.mapZoom.getSelection());
                GMapsDetailsPanel.this.zoomLevelLbl.setText(String.valueOf(Messages.GMapsDetailsPanel_ZoomLbl2) + GMapsDetailsPanel.this.mapZoom.getSelection());
            }
        });
        Label markersLbl = new Label(containerCmp, 0);
        markersLbl.setText(Messages.GMapsDetailsPanel_MarkersLbl);
        markersLbl.setLayoutData((Object)new GridData(4, 4, true, false));
        this.markersList = new List(containerCmp, 2816);
        this.markersList.setLayoutData((Object)new GridData(4, 4, true, true));
        Button b = new Button(containerCmp, 8);
        b.setLayoutData((Object)new GridData(131072, 4, false, false));
        b.setText(Messages.GMapsDetailsPanel_DeleteMarkersBtn);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GMapsDetailsPanel.this.map.getJavascriptMapSupport().clearMarkers();
            }
        });
        this.markersList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int markerIdx = GMapsDetailsPanel.this.markersList.getSelectionIndex();
                GMapsDetailsPanel.this.map.getJavascriptMapSupport().highlightMarker(markerIdx);
            }
        });
        this.markersList.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    int markerIdx = GMapsDetailsPanel.this.markersList.getSelectionIndex();
                    RemoveMarker.removeMarker(markerIdx, GMapsDetailsPanel.this.map.getJavaMapSupport());
                    GMapsDetailsPanel.this.map.getJavascriptMapSupport().evaluateJavascript("JAVA_TO_JAVASCRIPT_CALLED=true");
                    GMapsDetailsPanel.this.map.getJavascriptMapSupport().removeMarker(markerIdx);
                }
            }
        });
        this.map.activateMapTile();
        sash.setWeights(new int[]{4, 1});
    }

    class DetailsPanelMapSupport
    extends BaseJavaMapSupport {
        DetailsPanelMapSupport(Browser browser) {
            super(browser);
        }

        @Override
        public void removeMarker(int markerIndex) {
            super.removeMarker(markerIndex);
            GMapsDetailsPanel.this.markersList.remove(markerIndex);
        }

        @Override
        public void highlightMarker(int markerIdx) {
            super.highlightMarker(markerIdx);
            GMapsDetailsPanel.this.markersList.setSelection(markerIdx);
        }

        @Override
        public void updateMarkerPosition(int markerIdx, LatLng newPosition) {
            super.updateMarkerPosition(markerIdx, newPosition);
            GMapsDetailsPanel.this.markersList.setItem(markerIdx, newPosition.getLat() + " : " + newPosition.getLng());
        }

        @Override
        public void clearMarkers() {
            super.clearMarkers();
            GMapsDetailsPanel.this.markersList.removeAll();
        }

        @Override
        public void removeMarker(Marker oldMarker) {
            int mIdx = this.getMarkers().indexOf(oldMarker);
            if (mIdx > 0) {
                this.getMarkers().remove(mIdx);
                GMapsDetailsPanel.this.markersList.remove(mIdx);
            }
        }

        @Override
        public void addNewMarker(Marker newMarker) {
            super.addNewMarker(newMarker);
            LatLng position = newMarker.getPosition();
            GMapsDetailsPanel.this.markersList.add(position.getLat() + " : " + position.getLng());
        }

        @Override
        public void setZoomLevel(int newZoomLevel) {
            super.setZoomLevel(newZoomLevel);
            GMapsDetailsPanel.this.mapZoom.setSelection(newZoomLevel);
            GMapsDetailsPanel.this.zoomLevelLbl.setText(String.valueOf(Messages.GMapsDetailsPanel_ZoomLbl2) + newZoomLevel);
        }

        @Override
        public int getZoomLevel() {
            return GMapsDetailsPanel.this.mapZoom.getSelection();
        }

        @Override
        public void setMapCenter(LatLng position) {
            super.setMapCenter(position);
            GMapsDetailsPanel.this.mapCenterCoordinatesLbl.setText("<" + position.getLat() + " , " + position.getLng() + ">");
        }
    }

    class InitialConfigurationFunction
    extends GMapEnabledFunction {
        public InitialConfigurationFunction(Browser browser, String name, JavaMapSupport mapSupport) {
            super(browser, name, mapSupport);
        }

        public Object function(Object[] arguments) {
            GMapsDetailsPanel.this.map.getJavascriptMapSupport().evaluateJavascript("MENU_KIND=_MENU_COMPLETE");
            return null;
        }
    }
}

