/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.map.ui;

import com.jaspersoft.studio.widgets.map.core.Marker;
import com.jaspersoft.studio.widgets.map.ui.GMapsMarkersPanel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class GMapsPathsPanel
extends GMapsMarkersPanel {
    protected Combo cPaths;

    public GMapsPathsPanel(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void createMarkersLabel(Composite containerCmp) {
    }

    @Override
    protected void createRightPanel(Composite containerCmp) {
        Label lbl = new Label(containerCmp, 0);
        lbl.setText("Paths");
        this.cPaths = new Combo(containerCmp, 0);
        this.cPaths.setLayoutData((Object)new GridData(768));
        this.cPaths.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GMapsPathsPanel.this.initMarkers) {
                    return;
                }
                GMapsPathsPanel.this.handlePathChanged();
            }
        });
        this.cPaths.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GMapsPathsPanel.this.initMarkers) {
                    return;
                }
                GMapsPathsPanel.this.handlePathChanged();
            }
        });
        super.createRightPanel(containerCmp);
    }

    protected void drawPolyline() {
        String snippet = "var pathCoordinates = [\n";
        int cnt = this.markersList.getItemCount();
        int i = 0;
        while (i < cnt) {
            snippet = String.valueOf(snippet) + "{lat:" + this.markersList.getItem(i).replaceAll(" : ", ", lng:") + "}";
            if (i < cnt - 1) {
                snippet = String.valueOf(snippet) + ",";
            }
            snippet = String.valueOf(snippet) + "\n";
            ++i;
        }
        snippet = String.valueOf(snippet) + "];\n";
        snippet = String.valueOf(snippet) + "mypath.setMap(null);\n";
        snippet = String.valueOf(snippet) + "mypath = new google.maps.Polyline({\n";
        snippet = String.valueOf(snippet) + "path: pathCoordinates,\n";
        snippet = String.valueOf(snippet) + "geodesic: true,\n";
        snippet = String.valueOf(snippet) + "strokeColor: '#FF0000',\n";
        snippet = String.valueOf(snippet) + "strokeOpacity: 1.0,\n";
        snippet = String.valueOf(snippet) + "strokeWeight: 2\n";
        snippet = String.valueOf(snippet) + " });\n";
        snippet = String.valueOf(snippet) + "mypath.setMap(myMap.map);\n";
        this.map.getJavascriptMapSupport().evaluateJavascript(snippet);
    }

    protected void handlePathChanged() {
    }

    protected void fillPaths() {
    }

    @Override
    protected void handleUpdateMarkerPosition(int markerIdx, Marker m) {
        super.handleUpdateMarkerPosition(markerIdx, m);
        this.drawPolyline();
    }

    @Override
    protected void handleRemoveMarker(int[] markerIndex) {
        super.handleRemoveMarker(markerIndex);
        this.drawPolyline();
        this.fillPaths();
    }

    @Override
    protected void handleNewMarker(Marker newMarker) {
        super.handleNewMarker(newMarker);
        this.drawPolyline();
        this.fillPaths();
    }

    public void initMarkers() {
    }
}

