/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.map.ui;

import com.jaspersoft.studio.widgets.map.MapActivator;
import com.jaspersoft.studio.widgets.map.browserfunctions.GMapEnabledFunction;
import com.jaspersoft.studio.widgets.map.browserfunctions.TestJavaCallSupport;
import com.jaspersoft.studio.widgets.map.browserfunctions.UpdateMapCenter;
import com.jaspersoft.studio.widgets.map.browserfunctions.UpdateMapType;
import com.jaspersoft.studio.widgets.map.browserfunctions.UpdateZoomLevel;
import com.jaspersoft.studio.widgets.map.messages.Messages;
import com.jaspersoft.studio.widgets.map.support.BaseJSMapSupport;
import com.jaspersoft.studio.widgets.map.support.BaseJavaMapSupport;
import com.jaspersoft.studio.widgets.map.support.JSMapSupport;
import com.jaspersoft.studio.widgets.map.support.JavaMapSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class MapTile {
    private List<GMapEnabledFunction> functions;
    private JSMapSupport jsMapSupp;
    private JavaMapSupport javaMapSupp;
    protected Browser mapControl;
    private String mapURL;

    public MapTile(Composite parent, int style) {
        this(parent, style, MapActivator.getFileLocation("mapfiles/gmaps_library/map.html"));
    }

    public MapTile(Composite parent, int style, String mapURL) {
        this.createBrowser(parent, style);
        this.addListeners();
        this.mapURL = mapURL;
    }

    protected void createBrowser(Composite parent, int style) {
        this.mapControl = new Browser(parent, style | 0x800);
        this.mapControl.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
    }

    protected void addListeners() {
    }

    public void configureJavaSupport(BaseJavaMapSupport javaSupport) {
        if (this.javaMapSupp != null) {
            throw new RuntimeException(Messages.MapTile_JavaSupportAlreadyDefinedError);
        }
        this.javaMapSupp = javaSupport;
    }

    public void configureJavascriptSupport(BaseJSMapSupport jsSupport) {
        if (this.jsMapSupp != null) {
            throw new RuntimeException(Messages.MapTile_JavascriptSupportAlreadyDefined);
        }
        this.jsMapSupp = jsSupport;
    }

    public void configureFunctions(List<GMapEnabledFunction> functs) {
        this.functions = new ArrayList<GMapEnabledFunction>(functs);
    }

    public void setLayoutData(Object layoutData) {
        this.mapControl.setLayoutData(layoutData);
    }

    public JSMapSupport getJavascriptMapSupport() {
        if (this.jsMapSupp == null) {
            this.jsMapSupp = new BaseJSMapSupport(this.mapControl);
        }
        return this.jsMapSupp;
    }

    public boolean hasJavaMapSupport() {
        return this.javaMapSupp != null;
    }

    public JavaMapSupport getJavaMapSupport() {
        if (this.javaMapSupp == null) {
            this.javaMapSupp = new BaseJavaMapSupport(this.mapControl);
        }
        return this.javaMapSupp;
    }

    public List<GMapEnabledFunction> getFunctions() {
        if (this.functions == null) {
            this.functions = new ArrayList<GMapEnabledFunction>(4);
            this.functions.add(new TestJavaCallSupport(this.mapControl, "javaCall_TestJavaCallSupport", this.getJavaMapSupport()));
            this.functions.add(new UpdateZoomLevel(this.mapControl, "javaCall_UpdateZoomLevel", this.getJavaMapSupport()));
            this.functions.add(new UpdateMapCenter(this.mapControl, "javaCall_UpdateMapCenter", this.getJavaMapSupport()));
            this.functions.add(new UpdateMapType(this.mapControl, "javaCall_UpdateMapType", this.getJavaMapSupport()));
        }
        return this.functions;
    }

    public Browser getMapControl() {
        return this.mapControl;
    }

    public void activateMapTile() {
        this.getJavaMapSupport();
        this.getJavascriptMapSupport();
        this.getFunctions();
        this.mapControl.setUrl(this.mapURL);
    }
}

