/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.map.ui;

import com.jaspersoft.studio.widgets.map.browserfunctions.AddNewMarker;
import com.jaspersoft.studio.widgets.map.browserfunctions.ClearMarkersList;
import com.jaspersoft.studio.widgets.map.browserfunctions.RemoveMarker;
import com.jaspersoft.studio.widgets.map.browserfunctions.UpdateMarkerPosition;
import com.jaspersoft.studio.widgets.map.core.LatLng;
import com.jaspersoft.studio.widgets.map.core.MapType;
import com.jaspersoft.studio.widgets.map.core.Marker;
import com.jaspersoft.studio.widgets.map.messages.Messages;
import com.jaspersoft.studio.widgets.map.support.BaseJavaMapSupport;
import com.jaspersoft.studio.widgets.map.ui.BasicInfoMapDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

@Deprecated
public class MarkersPickupDialog
extends BasicInfoMapDialog {
    private List<Marker> markers = new ArrayList<Marker>();
    private org.eclipse.swt.widgets.List markersWidget;
    private boolean initMarkers = false;

    public MarkersPickupDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    protected void createContent(Composite parent) {
        SashForm sash = new SashForm(parent, 256);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        sash.setSashWidth(10);
        this.createMap((Composite)sash);
        Composite panelCmp = new Composite((Composite)sash, 0);
        GridLayout panelCmpGL = new GridLayout(1, true);
        panelCmpGL.marginWidth = 0;
        panelCmpGL.marginHeight = 0;
        panelCmp.setLayout((Layout)panelCmpGL);
        panelCmp.setLayoutData((Object)new GridData(4, 4, true, true));
        Label markersLbl = new Label(panelCmp, 0);
        markersLbl.setText(Messages.MarkersPickupDialog_MarkersLbl);
        markersLbl.setLayoutData((Object)new GridData(128, 16384, true, false));
        this.markersWidget = new org.eclipse.swt.widgets.List(panelCmp, 2816);
        this.markersWidget.setLayoutData((Object)new GridData(4, 4, true, true));
        Button delMarkersBtn = new Button(panelCmp, 8);
        delMarkersBtn.setLayoutData((Object)new GridData(131072, 1024, false, false));
        delMarkersBtn.setText(Messages.MarkersPickupDialog_DeleteMarkersBtn);
        delMarkersBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarkersPickupDialog.this.map.getJavascriptMapSupport().clearMarkers();
            }
        });
        this.markersWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int markerIdx = MarkersPickupDialog.this.markersWidget.getSelectionIndex();
                MarkersPickupDialog.this.map.getJavascriptMapSupport().highlightMarker(markerIdx);
            }
        });
        this.markersWidget.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    int markerIdx = MarkersPickupDialog.this.markersWidget.getSelectionIndex();
                    RemoveMarker.removeMarker(markerIdx, MarkersPickupDialog.this.map.getJavaMapSupport());
                    MarkersPickupDialog.this.map.getJavascriptMapSupport().evaluateJavascript("JAVA_TO_JAVASCRIPT_CALLED=true");
                    MarkersPickupDialog.this.map.getJavascriptMapSupport().removeMarker(markerIdx);
                }
            }
        });
        this.map.activateMapTile();
        sash.setWeights(new int[]{75, 25});
    }

    @Override
    protected void configureMapTile() {
        this.map.configureJavaSupport(new PanelJavaMapSupport(this, this.map.getMapControl()){

            @Override
            public void setZoomLevel(int newZoomLevel) {
                this.setZoomLevel(newZoomLevel);
            }

            @Override
            public void setMapCenter(LatLng position) {
                this.setMapCenter(position);
            }

            @Override
            public void setMapType(MapType mapType) {
                this.setMapType(mapType);
            }
        });
        this.map.getFunctions().add(new AddNewMarker(this.map.getMapControl(), "javaCall_AddMarker", this.map.getJavaMapSupport()));
        this.map.getFunctions().add(new ClearMarkersList(this.map.getMapControl(), "javaCall_ClearMarkers", this.map.getJavaMapSupport()));
        this.map.getFunctions().add(new RemoveMarker(this.map.getMapControl(), "javaCall_DelMarker", this.map.getJavaMapSupport()));
        this.map.getFunctions().add(new UpdateMarkerPosition(this.map.getMapControl(), "javaCall_UpdateMarkerPosition", this.map.getJavaMapSupport()));
        this.map.getFunctions().add(new BasicInfoMapDialog.InitialConfigurationFunction(this.map.getMapControl(), "javaCall_InitialConfiguration", this.map.getJavaMapSupport()));
    }

    public List<Marker> getMarkersList() {
        return this.markers;
    }

    @Override
    protected Object initConfigurationFunction(Object[] arguments) {
        this.initMarkers = true;
        try {
            this.map.getJavascriptMapSupport().evaluateJavascript("MENU_KIND=_MENU_COMPLETE");
            super.initConfigurationFunction(arguments);
            if (this.markers.isEmpty()) {
                return null;
            }
            for (Marker m : this.markers) {
                this.map.getJavascriptMapSupport().addNewMarker(m);
                this.markersWidget.add(String.valueOf(String.format("%.6f", m.getPosition().getLat())) + " : " + String.format("%.6f", m.getPosition().getLng()));
            }
        }
        finally {
            this.initMarkers = false;
        }
        return null;
    }

    @Override
    protected void addCenterMarker(LatLng coords) {
    }

    class PanelJavaMapSupport
    extends BaseJavaMapSupport {
        PanelJavaMapSupport(Browser browser) {
            super(browser);
        }

        @Override
        public void removeMarker(int markerIndex) {
            if (MarkersPickupDialog.this.initMarkers) {
                return;
            }
            super.removeMarker(markerIndex);
            MarkersPickupDialog.this.markersWidget.remove(markerIndex);
            MarkersPickupDialog.this.markers.remove(markerIndex);
        }

        @Override
        public void highlightMarker(int markerIdx) {
            if (MarkersPickupDialog.this.initMarkers) {
                return;
            }
            super.highlightMarker(markerIdx);
            MarkersPickupDialog.this.markersWidget.setSelection(markerIdx);
        }

        @Override
        public void updateMarkerPosition(int markerIdx, LatLng newPosition) {
            if (MarkersPickupDialog.this.initMarkers) {
                return;
            }
            super.updateMarkerPosition(markerIdx, newPosition);
            MarkersPickupDialog.this.markersWidget.setItem(markerIdx, String.valueOf(String.format("%.6f", newPosition.getLat())) + " : " + String.format("%.6f", newPosition.getLng()));
        }

        @Override
        public void clearMarkers() {
            if (MarkersPickupDialog.this.initMarkers) {
                return;
            }
            super.clearMarkers();
            MarkersPickupDialog.this.markersWidget.removeAll();
            MarkersPickupDialog.this.markers.clear();
        }

        @Override
        public void removeMarker(Marker oldMarker) {
            if (MarkersPickupDialog.this.initMarkers) {
                return;
            }
            int mIdx = this.getMarkers().indexOf(oldMarker);
            if (mIdx > 0) {
                this.getMarkers().remove(mIdx);
                MarkersPickupDialog.this.markersWidget.remove(mIdx);
                MarkersPickupDialog.this.markers.remove(mIdx);
            }
        }

        @Override
        public void addNewMarker(Marker newMarker) {
            if (MarkersPickupDialog.this.initMarkers) {
                return;
            }
            super.addNewMarker(newMarker);
            LatLng position = newMarker.getPosition();
            MarkersPickupDialog.this.markersWidget.add(String.valueOf(String.format("%.6f", position.getLat())) + " : " + String.format("%.6f", position.getLng()));
            MarkersPickupDialog.this.markers.add(newMarker);
        }
    }
}

