/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.map.ui;

import com.jaspersoft.studio.widgets.map.browserfunctions.AddNewMarker;
import com.jaspersoft.studio.widgets.map.browserfunctions.ClearMarkersList;
import com.jaspersoft.studio.widgets.map.browserfunctions.RemoveMarker;
import com.jaspersoft.studio.widgets.map.browserfunctions.UpdateMarkerPosition;
import com.jaspersoft.studio.widgets.map.core.LatLng;
import com.jaspersoft.studio.widgets.map.core.MapType;
import com.jaspersoft.studio.widgets.map.core.Marker;
import com.jaspersoft.studio.widgets.map.support.BaseJavaMapSupport;
import com.jaspersoft.studio.widgets.map.ui.BasicInfoMapDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

@Deprecated
public class PathPickupDialog
extends BasicInfoMapDialog {
    private org.eclipse.swt.widgets.List pointsWidget;
    private Map<String, List<Marker>> pathMap = new HashMap<String, List<Marker>>();
    private boolean initPoints = false;
    private Combo paths;

    public PathPickupDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    protected void createContent(Composite parent) {
        SashForm sash = new SashForm(parent, 256);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        sash.setSashWidth(10);
        this.createMap((Composite)sash);
        Composite panelCmp = new Composite((Composite)sash, 0);
        GridLayout panelCmpGL = new GridLayout(1, true);
        panelCmpGL.marginWidth = 0;
        panelCmpGL.marginHeight = 0;
        panelCmp.setLayout((Layout)panelCmpGL);
        panelCmp.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lbl = new Label(panelCmp, 0);
        lbl.setText("Paths");
        lbl.setLayoutData((Object)new GridData(128, 16384, true, false));
        this.paths = new Combo(panelCmp, 0);
        this.paths.setLayoutData((Object)new GridData(768));
        this.paths.setItems(this.pathMap.keySet().toArray(new String[this.pathMap.keySet().size()]));
        if (this.paths.getItemCount() > 0) {
            this.paths.select(0);
        }
        this.paths.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathPickupDialog.this.changePath();
            }
        });
        lbl = new Label(panelCmp, 0);
        lbl.setText("Points");
        lbl.setLayoutData((Object)new GridData(128, 16384, true, false));
        this.pointsWidget = new org.eclipse.swt.widgets.List(panelCmp, 2816);
        this.pointsWidget.setLayoutData((Object)new GridData(4, 4, true, true));
        Button delMarkersBtn = new Button(panelCmp, 8);
        delMarkersBtn.setLayoutData((Object)new GridData(131072, 1024, false, false));
        delMarkersBtn.setText("Delete Points");
        delMarkersBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int size = PathPickupDialog.this.pointsWidget.getItemCount();
                int i = 0;
                while (i < size) {
                    PathPickupDialog.this.map.getJavascriptMapSupport().removeMarker(0);
                    ++i;
                }
            }
        });
        this.pointsWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int markerIdx = PathPickupDialog.this.pointsWidget.getSelectionIndex();
                PathPickupDialog.this.map.getJavascriptMapSupport().highlightMarker(markerIdx);
            }
        });
        this.pointsWidget.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    int markerIdx = PathPickupDialog.this.pointsWidget.getSelectionIndex();
                    RemoveMarker.removeMarker(markerIdx, PathPickupDialog.this.map.getJavaMapSupport());
                    PathPickupDialog.this.map.getJavascriptMapSupport().evaluateJavascript("JAVA_TO_JAVASCRIPT_CALLED=true");
                    PathPickupDialog.this.map.getJavascriptMapSupport().removeMarker(markerIdx);
                }
            }
        });
        this.map.activateMapTile();
        sash.setWeights(new int[]{75, 25});
    }

    private void changePath() {
        this.initPoints = true;
        try {
            this.map.getJavascriptMapSupport().clearMarkers();
            this.pointsWidget.removeAll();
            List<Marker> p = this.getPoints4Path();
            for (Marker m : p) {
                this.map.getJavascriptMapSupport().addNewMarker(m);
                this.pointsWidget.add(String.valueOf(String.format("%.6f", m.getPosition().getLat())) + " : " + String.format("%.6f", m.getPosition().getLng()));
            }
            this.drawPolyline();
        }
        finally {
            this.initPoints = false;
        }
    }

    @Override
    protected void configureMapTile() {
        this.map.configureJavaSupport(new PanelJavaMapSupport(this, this.map.getMapControl()){

            @Override
            public void setZoomLevel(int newZoomLevel) {
                this.setZoomLevel(newZoomLevel);
            }

            @Override
            public void setMapCenter(LatLng position) {
                this.setMapCenter(position);
            }

            @Override
            public void setMapType(MapType mapType) {
                this.setMapType(mapType);
            }
        });
        this.map.getFunctions().add(new AddNewMarker(this.map.getMapControl(), "javaCall_AddMarker", this.map.getJavaMapSupport()));
        this.map.getFunctions().add(new ClearMarkersList(this.map.getMapControl(), "javaCall_ClearMarkers", this.map.getJavaMapSupport()));
        this.map.getFunctions().add(new RemoveMarker(this.map.getMapControl(), "javaCall_DelMarker", this.map.getJavaMapSupport()));
        this.map.getFunctions().add(new UpdateMarkerPosition(this.map.getMapControl(), "javaCall_UpdateMarkerPosition", this.map.getJavaMapSupport()));
        this.map.getFunctions().add(new BasicInfoMapDialog.InitialConfigurationFunction(this.map.getMapControl(), "javaCall_InitialConfiguration", this.map.getJavaMapSupport()));
    }

    public void addPoint(Marker point, String name) {
        List<Marker> pl = this.pathMap.get(name);
        if (pl == null) {
            pl = new ArrayList<Marker>();
        }
        pl.add(point);
        this.pathMap.put(name, pl);
    }

    public Map<String, List<Marker>> getPointsList() {
        return this.pathMap;
    }

    @Override
    protected Object initConfigurationFunction(Object[] arguments) {
        this.initPoints = true;
        try {
            this.map.getJavascriptMapSupport().evaluateJavascript("MENU_KIND=_MENU_COMPLETE");
            super.initConfigurationFunction(arguments);
            List<Marker> p = this.getPoints4Path();
            if (p == null || p.isEmpty()) {
                return null;
            }
            for (Marker m : p) {
                this.map.getJavascriptMapSupport().addNewMarker(m);
                this.pointsWidget.add(String.valueOf(String.format("%.6f", m.getPosition().getLat())) + " : " + String.format("%.6f", m.getPosition().getLng()));
            }
            this.drawPolyline();
        }
        finally {
            this.initPoints = false;
        }
        return null;
    }

    private void drawPolyline() {
        String snippet = "var pathCoordinates = [\n";
        this.pointsWidget.removeAll();
        List<Marker> ps = this.getPoints4Path();
        int i = 0;
        while (i < ps.size()) {
            Marker p = ps.get(i);
            snippet = String.valueOf(snippet) + "{lat:" + p.getPosition().getLat() + ", lng: " + p.getPosition().getLng() + "}";
            if (i < ps.size() - 1) {
                snippet = String.valueOf(snippet) + ",";
            }
            snippet = String.valueOf(snippet) + "\n";
            this.pointsWidget.add(String.valueOf(String.format("%.6f", p.getPosition().getLat())) + " : " + String.format("%.6f", p.getPosition().getLng()));
            ++i;
        }
        snippet = String.valueOf(snippet) + "];\n";
        snippet = String.valueOf(snippet) + "mypath.setMap(null);\n";
        snippet = String.valueOf(snippet) + "mypath = new google.maps.Polyline({\n";
        snippet = String.valueOf(snippet) + "path: pathCoordinates,\n";
        snippet = String.valueOf(snippet) + "geodesic: true,\n";
        snippet = String.valueOf(snippet) + "strokeColor: '#FF0000',\n";
        snippet = String.valueOf(snippet) + "strokeOpacity: 1.0,\n";
        snippet = String.valueOf(snippet) + "strokeWeight: 2\n";
        snippet = String.valueOf(snippet) + " });\n";
        snippet = String.valueOf(snippet) + "mypath.setMap(myMap.map);\n";
        System.out.println(snippet);
        this.map.getJavascriptMapSupport().evaluateJavascript(snippet);
    }

    @Override
    protected void addCenterMarker(LatLng coords) {
    }

    private List<Marker> getPoints4Path() {
        return this.pathMap.get(this.paths.getText());
    }

    class PanelJavaMapSupport
    extends BaseJavaMapSupport {
        PanelJavaMapSupport(Browser browser) {
            super(browser);
        }

        @Override
        public void removeMarker(int markerIndex) {
            if (PathPickupDialog.this.initPoints) {
                return;
            }
            super.removeMarker(markerIndex);
            PathPickupDialog.this.pointsWidget.remove(markerIndex);
            PathPickupDialog.this.getPoints4Path().remove(markerIndex);
            PathPickupDialog.this.drawPolyline();
        }

        @Override
        public void highlightMarker(int markerIdx) {
            if (PathPickupDialog.this.initPoints) {
                return;
            }
            super.highlightMarker(markerIdx);
            PathPickupDialog.this.pointsWidget.setSelection(markerIdx);
        }

        @Override
        public void updateMarkerPosition(int markerIdx, LatLng newPosition) {
            if (PathPickupDialog.this.initPoints) {
                return;
            }
            super.updateMarkerPosition(markerIdx, newPosition);
            List p = PathPickupDialog.this.getPoints4Path();
            ((Marker)p.get(markerIdx)).setPosition(newPosition);
            PathPickupDialog.this.drawPolyline();
        }

        @Override
        public void clearMarkers() {
            if (PathPickupDialog.this.initPoints) {
                return;
            }
            super.clearMarkers();
            PathPickupDialog.this.pointsWidget.removeAll();
            PathPickupDialog.this.getPoints4Path().clear();
            PathPickupDialog.this.drawPolyline();
        }

        @Override
        public void removeMarker(Marker oldMarker) {
            if (PathPickupDialog.this.initPoints) {
                return;
            }
            int mIdx = this.getMarkers().indexOf(oldMarker);
            if (mIdx > 0) {
                this.getMarkers().remove(mIdx);
                PathPickupDialog.this.pointsWidget.remove(mIdx);
                PathPickupDialog.this.getPoints4Path().remove(mIdx);
                PathPickupDialog.this.drawPolyline();
            }
        }

        @Override
        public void addNewMarker(Marker newMarker) {
            if (PathPickupDialog.this.initPoints) {
                return;
            }
            super.addNewMarker(newMarker);
            ArrayList<Marker> ps = PathPickupDialog.this.getPoints4Path();
            if (ps == null) {
                ps = new ArrayList<Marker>();
                PathPickupDialog.this.pathMap.put(PathPickupDialog.this.paths.getText(), ps);
                PathPickupDialog.this.paths.add(PathPickupDialog.this.paths.getText());
                PathPickupDialog.this.changePath();
                PathPickupDialog.this.initPoints = true;
                try {
                    PathPickupDialog.this.map.getJavascriptMapSupport().addNewMarker(newMarker);
                }
                finally {
                    PathPickupDialog.this.initPoints = false;
                }
            }
            ps.add(newMarker);
            PathPickupDialog.this.drawPolyline();
        }
    }
}

