/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.bundle;

import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;

public class PartContainer {
    private URL partPath = null;
    private JasperDesign loadedPart = null;

    public PartContainer(String parthPathTextual) {
        File partFile = new File(parthPathTextual);
        if (partFile.exists()) {
            try {
                this.partPath = partFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public PartContainer(URL partPath) {
        this.partPath = partPath;
    }

    public JasperDesign getJasperDesign() {
        if (this.loadedPart != null) {
            return this.loadedPart;
        }
        if (this.partPath != null) {
            InputStream is = null;
            try {
                is = this.partPath.openStream();
                this.loadedPart = JRXmlLoader.load((JasperReportsContext)JasperReportsConfiguration.getDefaultInstance(), (InputStream)is);
                return this.loadedPart;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception ex) {
                this.closeInputStream(is);
                ex.printStackTrace();
            }
        }
        return null;
    }

    private void closeInputStream(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {}
    }

    public void clearDesign() {
        this.loadedPart = null;
    }

    public PartContainer clone() {
        PartContainer newPart = new PartContainer(this.partPath);
        if (this.loadedPart != null) {
            try {
                newPart.loadedPart = ModelUtils.copyJasperDesign((JasperReportsContext)JasperReportsConfiguration.getDefaultInstance(), (JasperDesign)this.loadedPart);
            }
            catch (JRException e) {
                e.printStackTrace();
            }
        }
        return newPart;
    }
}

