/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.editors;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.book.dnd.ResourceTransferDropTargetListener;
import com.jaspersoft.studio.book.editors.BookEditPartFactory;
import com.jaspersoft.studio.book.editors.BookEditorContextMenuProvider;
import com.jaspersoft.studio.book.editors.actions.BookCompileAction;
import com.jaspersoft.studio.book.editors.actions.BookDatasetAction;
import com.jaspersoft.studio.book.editors.actions.CreateNewBookPartAction;
import com.jaspersoft.studio.book.editors.actions.CreateNewGroupAction;
import com.jaspersoft.studio.book.editors.actions.DeleteBookPartAction;
import com.jaspersoft.studio.book.editors.actions.DeleteBookSectionAction;
import com.jaspersoft.studio.book.editparts.BookSectionEditPart;
import com.jaspersoft.studio.book.model.MBookReport;
import com.jaspersoft.studio.editor.AGraphicEditor;
import com.jaspersoft.studio.editor.IGraphicalEditor;
import com.jaspersoft.studio.editor.ZoomActualAction;
import com.jaspersoft.studio.editor.gef.parts.JSSGraphicalViewerKeyHandler;
import com.jaspersoft.studio.editor.gef.parts.MainDesignerRootEditPart;
import com.jaspersoft.studio.editor.gef.ui.actions.RZoomComboContributionItem;
import com.jaspersoft.studio.editor.java2d.JSSScrollingGraphicalViewer;
import com.jaspersoft.studio.editor.outline.JDReportOutlineView;
import com.jaspersoft.studio.editor.outline.actions.CreateParameterAction;
import com.jaspersoft.studio.editor.outline.actions.CreateParameterSetAction;
import com.jaspersoft.studio.editor.outline.actions.CreateScriptletAction;
import com.jaspersoft.studio.editor.outline.actions.CreateSortFieldAction;
import com.jaspersoft.studio.editor.outline.actions.CreateVariableAction;
import com.jaspersoft.studio.editor.outline.actions.HideDefaultVariablesAction;
import com.jaspersoft.studio.editor.outline.actions.HideDefaultsParametersAction;
import com.jaspersoft.studio.editor.outline.actions.SortParametersAction;
import com.jaspersoft.studio.editor.outline.actions.SortVariablesAction;
import com.jaspersoft.studio.editor.outline.actions.field.CreateFieldAction;
import com.jaspersoft.studio.editor.outline.actions.field.CreateFieldsContainerAction;
import com.jaspersoft.studio.editor.outline.actions.field.DeleteFieldsAllGroupAction;
import com.jaspersoft.studio.editor.outline.actions.field.DeleteFieldsGroupAction;
import com.jaspersoft.studio.editor.outline.actions.field.ShowFieldsTreeAction;
import com.jaspersoft.studio.editor.outline.actions.field.SortFieldsAction;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.plugin.ExtensionManager;
import com.jaspersoft.studio.repository.actions.Separator;
import com.jaspersoft.studio.swt.widgets.ResizableToolItem;
import com.jaspersoft.studio.utils.AContributorAction;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;

public class JRBookDesignEditor
extends AGraphicEditor {
    private PropertyChangeListener modelChangesListener;
    private ExtensionManager m = JaspersoftStudioPlugin.getExtensionManager();
    protected RZoomComboContributionItem zoomItem = null;
    private ToolBar additionalToolbar;

    public JRBookDesignEditor(JasperReportsConfiguration jrContext) {
        super(jrContext);
        this.modelChangesListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JRBookDesignEditor.this.getSite().getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        JRBookDesignEditor.this.firePropertyChange(257);
                    }
                });
            }
        };
    }

    protected void createGraphicalViewer(Composite parent) {
        JSSScrollingGraphicalViewer viewer = new JSSScrollingGraphicalViewer();
        viewer.createControl(parent).setLayoutData((Object)new GridData(1808));
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
    }

    public void createPartControl(Composite parent) {
        GridLayout containerLayout = new GridLayout(1, false);
        containerLayout.verticalSpacing = 0;
        containerLayout.horizontalSpacing = 0;
        containerLayout.marginWidth = 0;
        containerLayout.marginHeight = 0;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)containerLayout);
        this.createToolBar(container);
        this.createGraphicalViewer(container);
        this.initializedToolBar();
    }

    private void createToolBar(Composite container) {
        this.additionalToolbar = new ToolBar(container, 8520000);
        GridData additionalToolbarGD = new GridData(4, 0x1000000, true, false);
        this.additionalToolbar.setLayoutData((Object)additionalToolbarGD);
    }

    private void initializedToolBar() {
        ZoomManager property;
        ActionRegistry registry = this.getActionRegistry();
        this.createToolBarButton(registry.getAction((Object)"compileAction"));
        this.createToolBarButton(registry.getAction((Object)"datasetAction"));
        this.createToolBarButton((IAction)new Separator());
        if (this.zoomItem != null) {
            this.zoomItem.dispose();
            this.zoomItem = null;
        }
        if ((property = (ZoomManager)this.getGraphicalViewer().getProperty(ZoomManager.class.toString())) != null) {
            this.createToolBarButton(this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
            this.createToolBarButton(this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_out"));
            this.zoomItem = new RZoomComboContributionItem(property);
            this.zoomItem.fill(this.additionalToolbar, 5);
        }
        this.createToolBarButton((IAction)new Separator());
        for (AContributorAction contAction : this.m.getActions()) {
            this.createToolBarButton((IAction)contAction);
            contAction.setJrConfig((JasperReportsConfiguration)this.getGraphicalViewer().getProperty("JRCONTEXT"));
        }
        this.additionalToolbar.pack();
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, false).applyTo((Control)this.additionalToolbar);
    }

    private void createToolBarButton(final IAction action) {
        if (action instanceof Separator) {
            new ToolItem(this.additionalToolbar, 2);
        } else {
            ResizableToolItem toolItem = new ResizableToolItem(this.additionalToolbar, 0x800008, action, 25);
            toolItem.setToolTipText(action.getToolTipText());
            toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    action.run();
                }
            });
        }
    }

    protected ContextMenuProvider createContextMenuProvider(EditPartViewer graphicalViewer) {
        return new BookEditorContextMenuProvider(graphicalViewer, this.getActionRegistry());
    }

    protected EditPartFactory createEditParFactory() {
        return new BookEditPartFactory();
    }

    protected JDReportOutlineView createOutline(TreeViewer viewer) {
        this.outlinePage = new JDReportOutlineView((IGraphicalEditor)this, (EditPartViewer)viewer){

            protected void initActions(ActionRegistry registry, IActionBars bars) {
            }

            protected ContextMenuProvider getMenuContentProvider() {
                return JRBookDesignEditor.this.createContextMenuProvider(this.getViewer());
            }
        };
        return this.outlinePage;
    }

    protected void createActions() {
        super.createActions();
        this.createBookRelatedActions();
        this.createDatasetRelatedActions();
    }

    private void createBookRelatedActions() {
        List selectionActions = this.getSelectionActions();
        ActionRegistry registry = this.getActionRegistry();
        Object action = new CreateNewBookPartAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new DeleteBookPartAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new DeleteBookSectionAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
    }

    private void createDatasetRelatedActions() {
        List selectionActions = this.getSelectionActions();
        ActionRegistry registry = this.getActionRegistry();
        Object action = new BookCompileAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new BookDatasetAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new CreateNewGroupAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new CreateFieldAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("create_field");
        action = new CreateFieldsContainerAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("create_fieldscontainer");
        action = new CreateSortFieldAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("create_sort_field");
        action = new CreateVariableAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("create_variable");
        action = new SortVariablesAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("sort_variables");
        action = new SortParametersAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("sort_parameters");
        action = new SortFieldsAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("sort_fields");
        action = new ShowFieldsTreeAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("showfieldstree");
        action = new DeleteFieldsGroupAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("deleteFieldsGroupTree");
        action = new DeleteFieldsAllGroupAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("deleteFieldsGroupAllTree");
        action = new HideDefaultsParametersAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("hide_default_parameters");
        action = new HideDefaultVariablesAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("hide_default_variables");
        action = new CreateScriptletAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("create_scriptlet");
        action = new CreateParameterAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("create_parameter");
        action = new CreateParameterSetAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("create_parameter_set");
    }

    protected void configureGraphicalViewer() {
        JSSScrollingGraphicalViewer viewer = (JSSScrollingGraphicalViewer)this.getGraphicalViewer();
        viewer.getControl().setBackground(ColorConstants.white);
        viewer.getEditDomain().setDefaultTool((Tool)new SelectionTool(){

            protected boolean updateTargetUnderMouse() {
                if (!this.isTargetLocked()) {
                    EditPart editPart = null;
                    if (this.getCurrentViewer() != null) {
                        editPart = this.getCurrentViewer().findObjectAtExcluding(this.getLocation(), this.getExclusionSet(), this.getTargetingConditional());
                        if (editPart instanceof MainDesignerRootEditPart) {
                            this.getCurrentViewer().getEditPartRegistry();
                            EditPart bookSectionPart = this.getCurrentViewer().findObjectAtExcluding(new Point(6, this.getLocation().y), this.getExclusionSet(), this.getTargetingConditional());
                            if (bookSectionPart != null && bookSectionPart instanceof BookSectionEditPart) {
                                editPart = bookSectionPart;
                            }
                            boolean changed = this.getTargetEditPart() != editPart;
                            this.setTargetEditPart(editPart);
                            return changed;
                        }
                        return super.updateTargetUnderMouse();
                    }
                    return super.updateTargetUnderMouse();
                }
                return false;
            }
        });
        viewer.getEditDomain().loadDefaultTool();
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        ((FigureCanvas)graphicalViewer.getControl()).setHorizontalScrollBarVisibility(FigureCanvas.NEVER);
        graphicalViewer.setEditPartFactory(this.createEditParFactory());
        MainDesignerRootEditPart rootEditPart = new MainDesignerRootEditPart();
        graphicalViewer.setRootEditPart((RootEditPart)rootEditPart);
        graphicalViewer.setKeyHandler((KeyHandler)new JSSGraphicalViewerKeyHandler(graphicalViewer));
        graphicalViewer.addDropTargetListener((TransferDropTargetListener)new ResourceTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
        graphicalViewer.setContextMenu((MenuManager)this.createContextMenuProvider((EditPartViewer)this.getGraphicalViewer()));
        graphicalViewer.setProperty("JRCONTEXT", (Object)this.jrContext);
        ZoomManager zoomManager = (ZoomManager)graphicalViewer.getProperty(ZoomManager.class.toString());
        this.getActionRegistry().registerAction((IAction)new ZoomInAction(zoomManager));
        this.getActionRegistry().registerAction((IAction)new ZoomOutAction(zoomManager));
        this.getActionRegistry().registerAction((IAction)new ZoomActualAction(zoomManager));
        graphicalViewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
    }

    public void setModel(INode model) {
        INode currModel = this.getModel();
        if (currModel != null) {
            ((MBookReport)((Object)currModel.getChildren().get(0))).getPropertyChangeSupport().removePropertyChangeListener(this.modelChangesListener);
        }
        super.setModel(model);
        if (model != null) {
            ((MBookReport)((Object)model.getChildren().get(0))).getPropertyChangeSupport().addPropertyChangeListener(this.modelChangesListener);
        }
    }

    public void setFocus() {
        super.setFocus();
        if (UIUtils.isMacOSX()) {
            this.getGraphicalViewer().getControl().redraw();
        }
    }
}

